/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.hyperlink.JsfJSPTagNameHyperlink;
import org.jboss.tools.jsf.text.ext.hyperlink.TLDAttributeHyperlink;
import org.jboss.tools.jsf.text.ext.hyperlink.TLDTagHyperlink;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.PageProcessor;
import org.jboss.tools.jst.web.kb.internal.KbObject;
import org.jboss.tools.jst.web.kb.internal.taglib.AbstractAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.AbstractComponent;
import org.jboss.tools.jst.web.kb.internal.taglib.TLDTag;
import org.jboss.tools.jst.web.kb.taglib.IAttribute;
import org.jboss.tools.jst.web.kb.taglib.IComponent;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.web.ui.internal.text.ext.util.TaglibManagerWrapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JsfJSPTagNameHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (!(textViewer instanceof JSPTextEditor.JSPStructuredTextViewer)) {
            return null;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(textViewer.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            IRegion reg = this.getRegion(n, region.getOffset());
            boolean prefixExist = false;
            if (reg != null && n instanceof IDOMElement) {
                String tagName = n.getNodeName();
                int i = tagName.indexOf(":");
                KbQuery query = new KbQuery();
                query.setType(KbQuery.Type.TAG_NAME);
                if (i > 0) {
                    query.setPrefix(tagName.substring(0, i));
                    prefixExist = true;
                } else {
                    query.setPrefix("");
                }
                query.setOffset(reg.getOffset());
                query.setValue(tagName);
                query.setUri(this.getURI(region, textViewer.getDocument()));
                query.setMask(false);
                ELContext context = PageContextFactory.createPageContext((IDocument)textViewer.getDocument());
                if (context instanceof IPageContext) {
                    IComponent[] components = PageProcessor.getInstance().getComponents(query, (IPageContext)context);
                    ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>();
                    IComponent[] iComponentArray = components;
                    int n2 = components.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        IComponent component = iComponentArray[n3];
                        if (!component.isExtended() && this.validateComponent(component, ((IPageContext)context).getNameSpaces(reg.getOffset()), query.getPrefix())) {
                            TLDTagHyperlink link = new TLDTagHyperlink((AbstractComponent)component, reg);
                            link.setDocument(textViewer.getDocument());
                            hyperlinks.add((IHyperlink)link);
                        }
                        ++n3;
                    }
                    this.sortHyperlinks(hyperlinks);
                    if (hyperlinks.size() > 0) {
                        IHyperlink[] iHyperlinkArray = hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
                        return iHyperlinkArray;
                    }
                }
            } else if (reg != null && n instanceof IDOMAttr) {
                String tagName = ((IDOMAttr)n).getOwnerElement().getNodeName();
                int i = tagName.indexOf(":");
                KbQuery query = new KbQuery();
                query.setType(KbQuery.Type.ATTRIBUTE_NAME);
                if (i > 0) {
                    query.setPrefix(tagName.substring(0, i));
                    prefixExist = true;
                } else {
                    query.setPrefix("");
                }
                query.setUri(this.getURI(region, textViewer.getDocument()));
                query.setParentTags(new String[]{tagName});
                query.setParent(tagName);
                query.setOffset(reg.getOffset());
                query.setValue(n.getNodeName());
                query.setMask(false);
                ELContext context = PageContextFactory.createPageContext((IDocument)textViewer.getDocument());
                if (context instanceof IPageContext) {
                    IAttribute[] attributes = PageProcessor.getInstance().getAttributes(query, (IPageContext)context);
                    ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>();
                    IAttribute[] iAttributeArray = attributes;
                    int n4 = attributes.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IAttribute attribute = iAttributeArray[n5];
                        if (!attribute.isExtended() && this.validateComponent(attribute.getComponent(), ((IPageContext)context).getNameSpaces(reg.getOffset()), query.getPrefix()) && attribute instanceof AbstractAttribute) {
                            TLDAttributeHyperlink link = new TLDAttributeHyperlink((AbstractAttribute)attribute, reg);
                            link.setDocument(textViewer.getDocument());
                            hyperlinks.add((IHyperlink)link);
                        }
                        ++n5;
                    }
                    this.sortHyperlinks(hyperlinks);
                    if (hyperlinks.size() > 0) {
                        IHyperlink[] iHyperlinkArray = hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
                        return iHyperlinkArray;
                    }
                }
            }
            if (prefixExist) {
                IHyperlink[] iHyperlinkArray = this.parse(textViewer.getDocument(), xmlDocument, region);
                return iHyperlinkArray;
            }
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    private boolean validateComponent(IComponent component, Map<String, List<INameSpace>> nameSpaces, String prefix) {
        XModelObject xmodelObject;
        IFile file;
        if (!this.validateNameSpace(component, nameSpaces, prefix)) {
            return false;
        }
        return component instanceof AbstractComponent && ((file = TLDTagHyperlink.getFile((AbstractComponent)component)) != null && file.getFullPath() != null && file.getFullPath().toString().endsWith(".jar") ? (xmodelObject = TLDTagHyperlink.getXModelObject((KbObject)((AbstractComponent)component))) != null && TLDTagHyperlink.getFileName(xmodelObject) != null : file != null);
    }

    private boolean validateNameSpace(IComponent component, Map<String, List<INameSpace>> nameSpaces, String prefix) {
        String uri;
        List<INameSpace> list;
        if (component != null && (list = nameSpaces.get(uri = component.getTagLib().getURI())) != null) {
            for (INameSpace nameSpace : list) {
                if (!nameSpace.getPrefix().equals(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    private void sortHyperlinks(ArrayList<IHyperlink> hyperlinks) {
        for (IHyperlink link : hyperlinks) {
            int index;
            AbstractComponent tag;
            if (!(link instanceof TLDTagHyperlink) || !((tag = ((TLDTagHyperlink)link).getComponent()) instanceof TLDTag) || (index = hyperlinks.indexOf(link)) == 0) continue;
            IHyperlink first = hyperlinks.get(0);
            hyperlinks.set(0, link);
            hyperlinks.set(index, first);
        }
    }

    private IHyperlink[] parse(IDocument document, Document xmlDocument, IRegion superRegion) {
        Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)superRegion.getOffset());
        IRegion r = this.getRegion(n, superRegion.getOffset());
        if (r == null) {
            return null;
        }
        JsfJSPTagNameHyperlink link = new JsfJSPTagNameHyperlink(r);
        link.setDocument(document);
        return new IHyperlink[]{link};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IRegion getRegion(Node n, int offset) {
        int nameEnd;
        int nameStart;
        if (n == null || !(n instanceof IDOMNode)) {
            return null;
        }
        if (n instanceof IDOMAttr) {
            int start;
            IDOMAttr attr = (IDOMAttr)n;
            String attrName = attr.getName();
            nameStart = start = attr.getStartOffset();
            nameEnd = nameStart + attrName.length();
        } else {
            if (!(n instanceof IDOMElement)) return null;
            IDOMElement elem = (IDOMElement)n;
            String tagName = elem.getTagName();
            if (offset >= elem.getStartOffset() && offset <= elem.getStartEndOffset()) {
                int start = elem.getStartOffset();
                nameStart = start + "<".length();
                nameEnd = nameStart + tagName.length();
            } else {
                if (offset < elem.getEndStartOffset() || offset > elem.getEndStartOffset() + elem.getLength()) return null;
                int start = elem.getEndStartOffset();
                nameStart = start + "</".length();
                nameEnd = nameStart + tagName.length();
            }
        }
        if (offset >= nameEnd) return null;
        return new Region(nameStart, nameEnd - nameStart);
    }

    private String getURI(IRegion region, IDocument document) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            Node node = null;
            node = n instanceof Attr ? ((Attr)n).getOwnerElement() : n;
            if (!(node instanceof Element)) {
                return null;
            }
            String nodeName = node.getNodeName();
            if (nodeName.indexOf(58) == -1) {
                return null;
            }
            String nodePrefix = nodeName.substring(0, nodeName.indexOf(":"));
            if (nodePrefix == null || nodePrefix.length() == 0) {
                return null;
            }
            TaglibManagerWrapper tmw = new TaglibManagerWrapper();
            tmw.init(document, region.getOffset());
            if (!tmw.exists()) {
                return null;
            }
            String string = tmw.getUri(nodePrefix);
            return string;
        }
        finally {
            smw.dispose();
        }
    }
}

