/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.docker.core.Activator;

public class DockerMachine {
    public static String[] getNames(String pathToDockerMachine) {
        return DockerMachine.execute(pathToDockerMachine, new String[]{"ls", "-q"}, new String[0]);
    }

    public static String getHost(String name, String dockerMachineInstallDir, String vmDriverInstallDir) {
        String[] res = DockerMachine.execute(dockerMachineInstallDir, new String[]{"url", name}, vmDriverInstallDir);
        return res.length == 1 ? res[0] : null;
    }

    public static String getCertPath(String name, String pathToDockerMachine, String vmDriverInstallDir) {
        String[] envVariables;
        String[] stringArray = envVariables = DockerMachine.execute(pathToDockerMachine, new String[]{"env", name}, vmDriverInstallDir);
        int n = envVariables.length;
        int n2 = 0;
        while (n2 < n) {
            String envVariable = stringArray[n2];
            if (envVariable.contains("DOCKER_CERT_PATH")) {
                return envVariable.split("=")[1].replace("\"", "");
            }
            ++n2;
        }
        return null;
    }

    private static String[] execute(String dockerMachineInstallDir, String[] args, String ... extraPaths) {
        try {
            String[] command = new String[args.length + 1];
            command[0] = String.valueOf(dockerMachineInstallDir) + (dockerMachineInstallDir.endsWith(File.separator) ? "" : File.separator) + "docker-machine";
            System.arraycopy(args, 0, command, 1, args.length);
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            Map<String, String> environment = processBuilder.environment();
            StringBuilder path = new StringBuilder(dockerMachineInstallDir);
            String[] stringArray = extraPaths;
            int n = extraPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String extraPath = stringArray[n2];
                path.append(File.pathSeparator).append(extraPath);
                ++n2;
            }
            environment.put("PATH", path.toString());
            Process p = processBuilder.start();
            p.waitFor();
            if (p.exitValue() == 0) {
                ArrayList<String> result = new ArrayList<String>();
                Throwable throwable = null;
                stringArray = null;
                try (BufferedReader buff = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                    String line;
                    while ((line = buff.readLine()) != null) {
                        result.add(line);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return result.toArray(new String[0]);
            }
            StringBuffer errorMessage = new StringBuffer();
            Throwable throwable = null;
            stringArray = null;
            try (BufferedReader buff = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
                String line;
                while ((line = buff.readLine()) != null) {
                    errorMessage.append(line).append('\n');
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", errorMessage.toString()));
        }
        catch (IOException | InterruptedException e) {
            Activator.log(e);
        }
        return new String[0];
    }
}

