/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;

public class DockerImage
implements IDockerImage {
    private static final String REGISTRY_HOST = "[a-zA-Z0-9]+([\\._-][a-zA-Z0-9]+)*";
    private static final String REGISTRY_PORT = "[0-9]+";
    private static final String REPOSITORY = "[a-z0-9]+([\\._-][a-z0-9]+)*";
    private static final String NAME = "[a-z0-9]+([\\._-][a-z0-9]+)*";
    private static final String TAG = "[a-zA-Z0-9]+([\\._-][a-zA-Z0-9]+)*";
    public static final Pattern imageNamePattern = Pattern.compile("([a-zA-Z0-9]+([\\._-][a-zA-Z0-9]+)*\\:[0-9]+/)?((?<repository>[a-z0-9]+([\\._-][a-z0-9]+)*)/)?(?<name>[a-z0-9]+([\\._-][a-z0-9]+)*)(\\:(?<tag>[a-zA-Z0-9]+([\\._-][a-zA-Z0-9]+)*))?");
    private static final ThreadLocal<SimpleDateFormat> formatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private final DockerConnection parent;
    private final String created;
    private final String createdDate;
    private final String id;
    private final String parentId;
    private final List<String> repoTags;
    private final String repo;
    private final List<String> tags;
    private final Long size;
    private final Long virtualSize;
    private final boolean intermediateImage;
    private final boolean danglingImage;

    public DockerImage(DockerConnection parent, @Deprecated List<String> repoTags, String repo, List<String> tags, String id, String parentId, String created, Long size, Long virtualSize, boolean intermediateImage, boolean danglingImage) {
        this.parent = parent;
        this.repoTags = repoTags;
        this.repo = repo;
        this.tags = tags;
        this.id = id;
        this.parentId = parentId;
        this.created = created;
        this.createdDate = formatter.get().format(new Date(Long.valueOf(created) * 1000L));
        this.size = size;
        this.virtualSize = virtualSize;
        this.intermediateImage = intermediateImage;
        this.danglingImage = danglingImage;
    }

    public static Map<String, List<String>> extractTagsByRepo(List<String> repoTags) {
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        for (String entry : repoTags) {
            String repo;
            int indexOfColonChar = entry.lastIndexOf(58);
            String string = repo = indexOfColonChar > -1 ? entry.substring(0, indexOfColonChar) : entry;
            if (!results.containsKey(repo)) {
                results.put(repo, new ArrayList());
            }
            if (indexOfColonChar <= -1) continue;
            ((List)results.get(repo)).add(entry.substring(indexOfColonChar + 1));
        }
        return results;
    }

    public static List<String> extractTags(List<String> repoTags) {
        if (repoTags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (String repoTag : repoTags) {
            int indexOfColonChar = repoTag.lastIndexOf(58);
            if (indexOfColonChar == -1) continue;
            tags.add(repoTag.substring(indexOfColonChar + 1));
        }
        return tags;
    }

    @Override
    public DockerConnection getConnection() {
        return this.parent;
    }

    @Override
    public List<String> repoTags() {
        return this.repoTags;
    }

    @Override
    public String repo() {
        return this.repo;
    }

    @Override
    public List<String> tags() {
        return this.tags;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String parentId() {
        return this.parentId;
    }

    @Override
    public String created() {
        return this.created;
    }

    @Override
    public String createdDate() {
        return this.createdDate;
    }

    @Override
    public Long size() {
        return this.size;
    }

    @Override
    public Long virtualSize() {
        return this.virtualSize;
    }

    @Override
    public boolean isDangling() {
        return this.danglingImage;
    }

    @Override
    public boolean isIntermediateImage() {
        return this.intermediateImage;
    }

    public String toString() {
        return "Image: id=" + this.id() + "\n" + "  parentId=" + this.parentId() + "\n" + "  created=" + this.created() + "\n" + "  repoTags=" + this.repoTags().toString() + "\n" + "  size=" + this.size() + "\n" + "  virtualSize=" + this.virtualSize() + "\n";
    }
}

