/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.spotify.docker.client.ObjectMapperProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerRegistry;
import org.eclipse.linuxtools.docker.core.IRepositoryTag;
import org.eclipse.linuxtools.docker.core.Messages;
import org.eclipse.linuxtools.internal.docker.core.RepositoryTag;
import org.eclipse.osgi.util.NLS;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;

public class DockerHubRegistry
implements IDockerRegistry {
    private static final String REGISTRY_LOCATION = "https://registry.hub.docker.com/";

    @Override
    public List<IRepositoryTag> getTags(String repository) throws InterruptedException, ExecutionException, DockerException {
        ClientConfig DEFAULT_CONFIG = new ClientConfig(new Class[]{ObjectMapperProvider.class, JacksonFeature.class});
        Client client = ClientBuilder.newClient((Configuration)DEFAULT_CONFIG);
        WebTarget pingApiv1Resource = client.target(REGISTRY_LOCATION).path("v1").path("_ping");
        try {
            Response response = (Response)pingApiv1Resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().get().get();
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new DockerException(NLS.bind((String)Messages.List_Docker_Containers_Failure, (Object)REGISTRY_LOCATION));
            }
        }
        catch (ExecutionException e) {
            Activator.log(e);
            return Collections.emptyList();
        }
        WebTarget queryTagsResource = client.target(REGISTRY_LOCATION).path("v1").path("repositories").path(repository).path("tags");
        GenericType<List<RepositoryTag>> REPOSITORY_TAGS_RESULT_LIST = new GenericType<List<RepositoryTag>>(){};
        List result = (List)queryTagsResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().method("GET", (GenericType)REPOSITORY_TAGS_RESULT_LIST).get();
        return new ArrayList<IRepositoryTag>(result);
    }
}

