/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.spotify.docker.client.ContainerNotFoundException;
import com.spotify.docker.client.DockerCertificateException;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.DockerRequestException;
import com.spotify.docker.client.LogMessage;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.Image;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.docker.client.messages.ImageSearchResult;
import com.spotify.docker.client.messages.Info;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.docker.client.messages.Version;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerContainerNotFoundException;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerLoggingStatus;
import org.eclipse.linuxtools.docker.core.IDockerConfParameter;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionInfo;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerContainerExit;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerContainerListener;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.docker.core.IDockerImageListener;
import org.eclipse.linuxtools.docker.core.IDockerImageSearchResult;
import org.eclipse.linuxtools.docker.core.IDockerPortBinding;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.core.ILogger;
import org.eclipse.linuxtools.docker.core.Messages;
import org.eclipse.linuxtools.internal.docker.core.AbstractKillableThread;
import org.eclipse.linuxtools.internal.docker.core.DockerClientFactory;
import org.eclipse.linuxtools.internal.docker.core.DockerConnectionInfo;
import org.eclipse.linuxtools.internal.docker.core.DockerContainer;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerExit;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerInfo;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerRefreshManager;
import org.eclipse.linuxtools.internal.docker.core.DockerHostConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;
import org.eclipse.linuxtools.internal.docker.core.DockerImageInfo;
import org.eclipse.linuxtools.internal.docker.core.DockerImageSearchResult;
import org.eclipse.linuxtools.internal.docker.core.DockerProgressHandler;
import org.eclipse.linuxtools.internal.docker.core.HttpHijackWorkaround;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;

public class DockerConnection
implements IDockerConnection,
Closeable {
    private final String name;
    private final String socketPath;
    private final String tcpHost;
    private final String tcpCertPath;
    private final String username;
    private final Object imageLock = new Object();
    private final Object containerLock = new Object();
    private final Object actionLock = new Object();
    private final Object clientLock = new Object();
    private DockerClientFactory dockerClientFactory = new DockerClientFactory();
    private DockerClient client;
    private Map<String, Job> actionJobs;
    private Map<String, LogThread> loggingThreads = new HashMap<String, LogThread>();
    private List<IDockerContainer> containers;
    private Map<String, IDockerContainer> containersById;
    private boolean active = false;
    private boolean containersLoaded = false;
    private List<IDockerImage> images;
    private boolean imagesLoaded = false;
    ListenerList containerListeners;
    ListenerList imageListeners;

    private DockerConnection(String name, String socketPath, String username, String password) {
        this.name = name;
        this.socketPath = socketPath;
        this.username = username;
        this.tcpHost = null;
        this.tcpCertPath = null;
        this.storePassword(socketPath, username, password);
    }

    private DockerConnection(String name, String tcpHost, String tcpCertPath, String username, String password) {
        this.name = name;
        this.socketPath = null;
        this.username = username;
        this.tcpHost = tcpHost;
        this.tcpCertPath = tcpCertPath;
        this.storePassword(this.socketPath, username, password);
        DockerContainerRefreshManager dcrm = DockerContainerRefreshManager.getInstance();
        this.addContainerListener(dcrm);
    }

    private void storePassword(String uri, String username, String passwd) {
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        String key = DockerConnection.getPreferencesKey(uri, username);
        ISecurePreferences node = root.node(key);
        try {
            if (passwd != null && !passwd.equals("")) {
                node.put("password", passwd, true);
            }
        }
        catch (StorageException e) {
            Activator.log(e);
        }
    }

    public static String getPreferencesKey(String uri, String username) {
        String key = "/org/eclipse/linuxtools/docker/core/";
        key = String.valueOf(key) + uri + "/" + username;
        return EncodingUtils.encodeSlashes((String)key);
    }

    @Override
    public boolean isOpen() {
        return this.client != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(boolean registerContainerRefreshManager) throws DockerException {
        DockerConnection dockerConnection = this;
        synchronized (dockerConnection) {
            if (this.client == null) {
                try {
                    this.setClient(this.dockerClientFactory.getClient(this.socketPath, this.tcpHost, this.tcpCertPath));
                    if (registerContainerRefreshManager) {
                        DockerContainerRefreshManager dcrm = DockerContainerRefreshManager.getInstance();
                        this.addContainerListener(dcrm);
                    }
                }
                catch (DockerCertificateException e) {
                    throw new DockerException(NLS.bind((String)Messages.Open_Connection_Failure, (Object)this.name));
                }
            }
        }
    }

    public DockerClient getClient() {
        return this.client;
    }

    public void setClient(DockerClient client) {
        this.client = client;
    }

    public void setDockerClientFactory(DockerClientFactory dockerClientFactory) {
        this.dockerClientFactory = dockerClientFactory;
    }

    @Override
    public void ping() throws DockerException {
        try {
            if (this.client == null) {
                throw new DockerException(Messages.Docker_Daemon_Ping_Failure);
            }
            this.client.ping();
        }
        catch (com.spotify.docker.client.DockerException | InterruptedException e) {
            throw new DockerException(Messages.Docker_Daemon_Ping_Failure, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.clientLock;
        synchronized (object) {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
    }

    @Override
    public IDockerConnectionInfo getInfo() throws DockerException {
        try {
            Info info = this.client.info();
            Version version = this.client.version();
            return new DockerConnectionInfo(info, version);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException | InterruptedException e) {
            throw new DockerException(Messages.Docker_General_Info_Failure, e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUri() {
        return this.socketPath != null ? this.socketPath : this.tcpHost;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void addContainerListener(IDockerContainerListener listener) {
        if (this.containerListeners == null) {
            this.containerListeners = new ListenerList(1);
        }
        this.containerListeners.add((Object)listener);
    }

    @Override
    public void removeContainerListener(IDockerContainerListener listener) {
        if (this.containerListeners != null) {
            this.containerListeners.remove((Object)listener);
        }
    }

    private DockerClient getClientCopy() throws DockerException {
        try {
            return this.dockerClientFactory.getClient(this.socketPath, this.tcpHost, this.tcpCertPath);
        }
        catch (DockerCertificateException e) {
            throw new DockerException(NLS.bind((String)Messages.Open_Connection_Failure, (Object)this.name));
        }
    }

    public void notifyContainerListeners(List<IDockerContainer> list) {
        if (this.containerListeners != null) {
            Object[] listeners = this.containerListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IDockerContainerListener)listeners[i]).listChanged(this, list);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job getActionJob(String id) {
        Object object = this.actionLock;
        synchronized (object) {
            Job j = null;
            if (this.actionJobs != null) {
                return this.actionJobs.get(id);
            }
            return j;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerActionJob(String id, Job j) {
        Object object = this.actionLock;
        synchronized (object) {
            if (this.actionJobs == null) {
                this.actionJobs = new HashMap<String, Job>();
            }
            this.actionJobs.put(id, j);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionJob(String id, Job j) {
        Object object = this.actionLock;
        synchronized (object) {
            if (this.actionJobs != null && this.actionJobs.get(id) == j) {
                this.actionJobs.remove(id);
            }
        }
    }

    @Override
    public List<IDockerContainer> getContainers() {
        return this.getContainers(false);
    }

    @Override
    public List<IDockerContainer> getContainers(boolean force) {
        if (!this.isContainersLoaded() || force) {
            try {
                return this.listContainers();
            }
            catch (DockerException e) {
                Activator.log(e);
            }
        }
        return this.containers;
    }

    @Override
    public boolean isContainersLoaded() {
        return this.containersLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List<IDockerContainer> listContainers() throws DockerException {
        updatedContainers = new HashMap<String, IDockerContainer>();
        nativeContainers = new ArrayList<E>();
        var3_4 = this.clientLock;
        synchronized (var3_4) {
            if (this.client != null) ** break block29
            var7_5 = Collections.emptyList();
            // MONITOREXIT @DISABLED, blocks:[0, 1, 11] lbl9 : MonitorExitStatement: MONITOREXIT : var3_4
            var8_6 = this.containerLock;
        }
        synchronized (var8_6) {
            this.containersById = updatedContainers;
            this.containers = this.sort(this.containersById.values(), new Comparator<IDockerContainer>(){

                @Override
                public int compare(IDockerContainer container, IDockerContainer otherContainer) {
                    return container.name().compareTo(otherContainer.name());
                }
            });
            this.containersLoaded = true;
        }
        return var7_5;
        {
            try {
                try {
                    nativeContainers.addAll(this.client.listContainers(new DockerClient.ListContainersParam[]{DockerClient.ListContainersParam.allContainers()}));
                    this.active = true;
                    // MONITOREXIT @DISABLED, blocks:[3, 4, 5, 11] lbl28 : MonitorExitStatement: MONITOREXIT : var3_4
                    {
                        catch (Throwable v1) {
                            throw v1;
                        }
                    }
                    for (Container nativeContainer : nativeContainers) {
                        if (nativeContainer.status().startsWith(Messages.Exited_specifier)) {
                            var5_11 = this.loggingThreads;
                            synchronized (var5_11) {
                                if (this.loggingThreads.containsKey(nativeContainer.id())) {
                                    this.loggingThreads.get(nativeContainer.id()).requestStop();
                                    this.loggingThreads.remove(nativeContainer.id());
                                }
                            }
                        }
                        if (nativeContainer.status().equals(Messages.Removal_In_Progress_specifier)) continue;
                        if (this.containers != null && this.containersById.containsKey(nativeContainer.id())) {
                            container = this.containersById.get(nativeContainer.id());
                            updatedContainers.put(nativeContainer.id(), new DockerContainer(this, nativeContainer, container.info()));
                            continue;
                        }
                        updatedContainers.put(nativeContainer.id(), new DockerContainer(this, nativeContainer));
                    }
                }
                catch (com.spotify.docker.client.DockerException | InterruptedException e) {
                    if (this.active) {
                        this.active = false;
                        throw new DockerException(NLS.bind((String)Messages.List_Docker_Containers_Failure, (Object)this.getName()), e);
                    }
                    var8_7 = this.containerLock;
                    synchronized (var8_7) {
                        this.containersById = updatedContainers;
                        this.containers = this.sort(this.containersById.values(), new /* invalid duplicate definition of identical inner class */);
                        this.containersLoaded = true;
                        ** break block31
                    }
                }
            }
            catch (Throwable var6_12) {
                var8_8 = this.containerLock;
                synchronized (var8_8) {
                    this.containersById = updatedContainers;
                    this.containers = this.sort(this.containersById.values(), new /* invalid duplicate definition of identical inner class */);
                    this.containersLoaded = true;
                }
                throw var6_12;
            }
        }
        var8_9 = this.containerLock;
        synchronized (var8_9) {
            this.containersById = updatedContainers;
            this.containers = this.sort(this.containersById.values(), new /* invalid duplicate definition of identical inner class */);
            this.containersLoaded = true;
        }
lbl-1000:
        // 2 sources

        {
            this.notifyContainerListeners(this.containers);
            return this.containers;
        }
    }

    private <T> List<T> sort(Collection<T> values, Comparator<T> comparator) {
        ArrayList<T> result = new ArrayList<T>(values);
        Collections.sort(result, comparator);
        return result;
    }

    @Override
    public IDockerContainer getContainer(String id) {
        List<IDockerContainer> containers = this.getContainers();
        for (IDockerContainer container : containers) {
            if (!container.id().equals(id)) continue;
            return container;
        }
        return null;
    }

    @Override
    public IDockerContainerInfo getContainerInfo(String id) {
        try {
            ContainerInfo info = this.client.inspectContainer(id);
            return new DockerContainerInfo(info);
        }
        catch (DockerRequestException e) {
            Activator.logErrorMessage(e.message());
            return null;
        }
        catch (com.spotify.docker.client.DockerException | InterruptedException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", "Failed to inspect container '" + id + "'", e));
            return null;
        }
    }

    @Override
    public IDockerImageInfo getImageInfo(String id) {
        try {
            ImageInfo info = this.client.inspectImage(id);
            return new DockerImageInfo(info);
        }
        catch (DockerRequestException e) {
            Activator.logErrorMessage(e.message());
            return null;
        }
        catch (com.spotify.docker.client.DockerException | InterruptedException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", "Failed to inspect container '" + id + "'", e));
            return null;
        }
    }

    @Override
    public void addImageListener(IDockerImageListener listener) {
        if (this.imageListeners == null) {
            this.imageListeners = new ListenerList(1);
        }
        this.imageListeners.add((Object)listener);
    }

    @Override
    public void removeImageListener(IDockerImageListener listener) {
        if (this.imageListeners != null) {
            this.imageListeners.remove((Object)listener);
        }
    }

    public void notifyImageListeners(List<IDockerImage> list) {
        if (this.imageListeners != null) {
            Object[] listeners = this.imageListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IDockerImageListener)listeners[i]).listChanged(this, list);
                ++i;
            }
        }
    }

    @Override
    public List<IDockerImage> getImages() {
        return this.getImages(false);
    }

    public IDockerImage getImage(String id) {
        List<IDockerImage> images = this.getImages();
        for (IDockerImage image : images) {
            if (!image.id().equals(id)) continue;
            return image;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IDockerImage> getImages(boolean force) {
        List<IDockerImage> latestImages;
        Object object = this.imageLock;
        synchronized (object) {
            latestImages = this.images;
        }
        if (!this.isImagesLoaded() || force) {
            try {
                try {
                    latestImages = this.listImages();
                }
                catch (DockerException e) {
                    Object object2 = this.imageLock;
                    synchronized (object2) {
                        this.images = Collections.emptyList();
                    }
                    Activator.log(e);
                    this.imagesLoaded = true;
                }
            }
            finally {
                this.imagesLoaded = true;
            }
        }
        return latestImages;
    }

    @Override
    public boolean isImagesLoaded() {
        return this.imagesLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IDockerImage> listImages() throws DockerException {
        ArrayList<IDockerImage> dilist = new ArrayList<IDockerImage>();
        Object object = this.imageLock;
        synchronized (object) {
            List rawImages = null;
            try {
                Object object2 = this.clientLock;
                synchronized (object2) {
                    if (this.client == null) {
                        return dilist;
                    }
                    rawImages = this.client.listImages(new DockerClient.ListImagesParam[]{DockerClient.ListImagesParam.allImages()});
                }
            }
            catch (DockerRequestException e) {
                throw new DockerException(e.message());
            }
            catch (com.spotify.docker.client.DockerException | InterruptedException e) {
                DockerException f = new DockerException(e);
                throw f;
            }
            HashSet<String> imageParentIds = new HashSet<String>();
            for (Image rawImage : rawImages) {
                imageParentIds.add(rawImage.parentId());
            }
            for (Image rawImage : rawImages) {
                boolean taggedImage = rawImage.repoTags() == null || rawImage.repoTags().size() != 1 || !rawImage.repoTags().contains((Object)"<none>:<none>");
                boolean intermediateImage = !taggedImage && imageParentIds.contains(rawImage.id());
                boolean danglingImage = !taggedImage && !intermediateImage;
                Map<String, List<String>> repoTags = DockerImage.extractTagsByRepo((List<String>)rawImage.repoTags());
                for (Map.Entry<String, List<String>> entry : repoTags.entrySet()) {
                    String repo = entry.getKey();
                    List<String> tags = entry.getValue();
                    dilist.add(new DockerImage(this, (List<String>)rawImage.repoTags(), repo, tags, rawImage.id(), rawImage.parentId(), rawImage.created(), rawImage.size(), rawImage.virtualSize(), intermediateImage, danglingImage));
                }
            }
            this.images = dilist;
        }
        this.notifyImageListeners(dilist);
        return dilist;
    }

    @Override
    public boolean hasImage(String repository, String tag) {
        for (IDockerImage image : this.getImages()) {
            if (!image.repo().equals(repository)) continue;
            for (String imageTag : image.tags()) {
                if (!imageTag.startsWith(tag)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void pullImage(String id, IDockerProgressHandler handler) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            this.client.pull(id, (ProgressHandler)d);
            this.listImages();
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public List<IDockerImageSearchResult> searchImages(String term) throws DockerException {
        try {
            List searchResults = this.client.searchImages(term);
            ArrayList<IDockerImageSearchResult> results = new ArrayList<IDockerImageSearchResult>();
            for (ImageSearchResult r : searchResults) {
                results.add(new DockerImageSearchResult(r.getDescription(), r.isOfficial(), r.isAutomated(), r.getName(), r.getStarCount()));
            }
            return results;
        }
        catch (com.spotify.docker.client.DockerException | InterruptedException e) {
            throw new DockerException(e);
        }
    }

    @Override
    public void pushImage(String name, IDockerProgressHandler handler) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            this.client.push(name, (ProgressHandler)d);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public void removeImage(String name) throws DockerException, InterruptedException {
        try {
            this.client.removeImage(name, true, false);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public void removeTag(String tag) throws DockerException, InterruptedException {
        try {
            this.client.removeImage(tag, false, false);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public void tagImage(String name, String newTag) throws DockerException, InterruptedException {
        try {
            this.client.tag(name, newTag);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public String buildImage(IPath path, IDockerProgressHandler handler) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            Path p = FileSystems.getDefault().getPath(path.makeAbsolute().toOSString(), new String[0]);
            return this.client.build(p, (ProgressHandler)d, new DockerClient.BuildParameter[]{DockerClient.BuildParameter.FORCE_RM});
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException | IOException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    @Override
    public String buildImage(IPath path, String name, IDockerProgressHandler handler) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            Path p = FileSystems.getDefault().getPath(path.makeAbsolute().toOSString(), new String[0]);
            return this.client.build(p, name, (ProgressHandler)d, new DockerClient.BuildParameter[]{DockerClient.BuildParameter.FORCE_RM});
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException | IOException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    public String buildImage(IPath path, String name, IDockerProgressHandler handler, Map<String, Object> buildOptions) throws DockerException, InterruptedException {
        try {
            DockerProgressHandler d = new DockerProgressHandler(handler);
            Path p = FileSystems.getDefault().getPath(path.makeAbsolute().toOSString(), new String[0]);
            return this.client.build(p, name, (ProgressHandler)d, this.getBuildParameters(buildOptions));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException | IOException e) {
            DockerException f = new DockerException(e);
            throw f;
        }
    }

    private DockerClient.BuildParameter[] getBuildParameters(Map<String, Object> buildOptions) {
        ArrayList<DockerClient.BuildParameter> buildParameters = new ArrayList<DockerClient.BuildParameter>();
        for (Map.Entry<String, Object> entry : buildOptions.entrySet()) {
            String optionName = entry.getKey();
            Object optionValue = entry.getValue();
            if (optionName.equals("quietBuild") && optionValue.equals(true)) {
                buildParameters.add(DockerClient.BuildParameter.QUIET);
                continue;
            }
            if (optionName.equals("noCache") && optionValue.equals(true)) {
                buildParameters.add(DockerClient.BuildParameter.NO_CACHE);
                continue;
            }
            if (optionName.equals("rm") && optionValue.equals(false)) {
                buildParameters.add(DockerClient.BuildParameter.NO_RM);
                continue;
            }
            if (!optionName.equals("forcerm") || !optionValue.equals(true)) continue;
            buildParameters.add(DockerClient.BuildParameter.FORCE_RM);
        }
        return buildParameters.toArray(new DockerClient.BuildParameter[0]);
    }

    public void save() {
        DockerConnectionManager.getInstance().saveConnections();
    }

    @Override
    @Deprecated
    public String createContainer(IDockerContainerConfig c) throws DockerException, InterruptedException {
        DockerHostConfig hc = new DockerHostConfig(HostConfig.builder().build());
        return this.createContainer(c, hc);
    }

    @Override
    @Deprecated
    public String createContainer(IDockerContainerConfig c, String containerName) throws DockerException, InterruptedException {
        DockerHostConfig hc = new DockerHostConfig(HostConfig.builder().build());
        return this.createContainer(c, hc, containerName);
    }

    @Override
    public String createContainer(IDockerContainerConfig c, IDockerHostConfig hc) throws DockerException, InterruptedException {
        return this.createContainer(c, hc, null);
    }

    @Override
    public String createContainer(IDockerContainerConfig c, IDockerHostConfig hc, String containerName) throws DockerException, InterruptedException {
        try {
            HostConfig.Builder hbuilder = HostConfig.builder().containerIDFile(hc.containerIDFile()).publishAllPorts(Boolean.valueOf(hc.publishAllPorts())).privileged(Boolean.valueOf(hc.privileged())).networkMode(hc.networkMode());
            if (hc.binds() != null) {
                hbuilder.binds(hc.binds());
            }
            if (hc.dns() != null) {
                hbuilder.dns(hc.dns());
            }
            if (hc.dnsSearch() != null) {
                hbuilder.dnsSearch(hc.dnsSearch());
            }
            if (hc.links() != null) {
                hbuilder.links(hc.links());
            }
            if (hc.lxcConf() != null) {
                List<IDockerConfParameter> lxcconf = hc.lxcConf();
                ArrayList<HostConfig.LxcConfParameter> lxcreal = new ArrayList<HostConfig.LxcConfParameter>();
                for (IDockerConfParameter iDockerConfParameter : lxcconf) {
                    lxcreal.add(new HostConfig.LxcConfParameter(iDockerConfParameter.key(), iDockerConfParameter.value()));
                }
                hbuilder.lxcConf(lxcreal);
            }
            if (hc.portBindings() != null) {
                Map<String, List<IDockerPortBinding>> bindings = hc.portBindings();
                HashMap realBindings = new HashMap();
                for (Map.Entry entry : bindings.entrySet()) {
                    String key = (String)entry.getKey();
                    List bindingList = (List)entry.getValue();
                    ArrayList<PortBinding> newList = new ArrayList<PortBinding>();
                    for (IDockerPortBinding binding : bindingList) {
                        newList.add(PortBinding.of((String)binding.hostIp(), (String)binding.hostPort()));
                    }
                    realBindings.put(key, newList);
                }
                hbuilder.portBindings(realBindings);
            }
            if (hc.volumesFrom() != null) {
                hbuilder.volumesFrom(hc.volumesFrom());
            }
            if (((DockerHostConfig)hc).memory() != null) {
                hbuilder.memory(((DockerHostConfig)hc).memory());
            }
            if (((DockerHostConfig)hc).cpuShares() != null && ((DockerHostConfig)hc).cpuShares() > 0L) {
                hbuilder.cpuShares(((DockerHostConfig)hc).cpuShares());
            }
            ContainerConfig.Builder builder = ContainerConfig.builder().hostname(c.hostname()).domainname(c.domainname()).user(c.user()).attachStdin(Boolean.valueOf(c.attachStdin())).attachStdout(Boolean.valueOf(c.attachStdout())).attachStderr(Boolean.valueOf(c.attachStderr())).tty(Boolean.valueOf(c.tty())).openStdin(Boolean.valueOf(c.openStdin())).stdinOnce(Boolean.valueOf(c.stdinOnce())).cmd(c.cmd()).image(c.image()).hostConfig(hbuilder.build()).workingDir(c.workingDir()).networkDisabled(Boolean.valueOf(c.networkDisabled()));
            if (c.portSpecs() != null) {
                builder = builder.portSpecs(c.portSpecs());
            }
            if (c.exposedPorts() != null) {
                builder = builder.exposedPorts(c.exposedPorts());
            }
            if (c.env() != null) {
                builder = builder.env(c.env());
            }
            if (c.volumes() != null) {
                builder = builder.volumes(c.volumes());
            }
            if (c.entrypoint() != null) {
                builder = builder.entrypoint(c.entrypoint());
            }
            if (c.onBuild() != null) {
                builder = builder.onBuild(c.onBuild());
            }
            ContainerCreation creation = this.client.createContainer(builder.build(), containerName != null && !containerName.isEmpty() ? containerName : null);
            String string = creation.id();
            this.listContainers();
            return string;
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopContainer(String id) throws DockerException, InterruptedException {
        try {
            this.client.stopContainer(id, 10);
            Map<String, LogThread> map = this.loggingThreads;
            synchronized (map) {
                if (this.loggingThreads.containsKey(id)) {
                    this.loggingThreads.get(id).kill();
                    this.loggingThreads.remove(id);
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killContainer(String id) throws DockerException, InterruptedException {
        try {
            this.client.killContainer(id);
            Map<String, LogThread> map = this.loggingThreads;
            synchronized (map) {
                if (this.loggingThreads.containsKey(id)) {
                    this.loggingThreads.get(id).kill();
                    this.loggingThreads.remove(id);
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void pauseContainer(String id) throws DockerException, InterruptedException {
        try {
            this.client.pauseContainer(id);
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpauseContainer(String id, OutputStream stream) throws DockerException, InterruptedException {
        try {
            this.client.unpauseContainer(id);
            if (stream != null) {
                Map<String, LogThread> map = this.loggingThreads;
                synchronized (map) {
                    LogThread t = this.loggingThreads.get(id);
                    if (t == null || !t.isAlive()) {
                        t = new LogThread(id, this.getClientCopy(), true);
                        this.loggingThreads.put(id, t);
                        t.setOutputStream(stream);
                        t.start();
                    } else {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void removeContainer(String id) throws DockerException, InterruptedException {
        try {
            this.client.removeContainer(id);
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    @Deprecated
    public void startContainer(String id, IDockerHostConfig config, OutputStream stream) throws DockerException, InterruptedException {
        this.startContainer(id, stream);
    }

    @Override
    @Deprecated
    public void startContainer(String id, String loggingId, IDockerHostConfig config, OutputStream stream) throws DockerException, InterruptedException {
        this.startContainer(id, loggingId, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startContainer(String id, OutputStream stream) throws DockerException, InterruptedException {
        try {
            this.client.startContainer(id);
            IDockerContainerInfo containerInfo = this.getContainerInfo(id);
            if (stream != null && containerInfo != null && containerInfo.config() != null && !containerInfo.config().tty()) {
                Map<String, LogThread> map = this.loggingThreads;
                synchronized (map) {
                    LogThread t = this.loggingThreads.get(id);
                    if (t == null || !t.isAlive()) {
                        t = new LogThread(id, this.getClientCopy(), true);
                        this.loggingThreads.put(id, t);
                        t.setOutputStream(stream);
                        t.start();
                    }
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startContainer(String id, String loggingId, OutputStream stream) throws DockerException, InterruptedException {
        try {
            this.client.startContainer(id);
            IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
            boolean autoLog = preferences.getBoolean("autoLogOnStart", true);
            if (autoLog && !this.getContainerInfo(id).config().tty()) {
                Map<String, LogThread> map = this.loggingThreads;
                synchronized (map) {
                    LogThread t = this.loggingThreads.get(loggingId);
                    if (t == null || !t.isAlive()) {
                        t = new LogThread(id, this.getClientCopy(), true);
                        this.loggingThreads.put(loggingId, t);
                        t.setOutputStream(stream);
                        t.start();
                    }
                }
            }
            this.listContainers();
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e);
        }
    }

    @Override
    public void commitContainer(String id, String repo, String tag, String comment, String author) throws DockerException {
        try {
            ContainerInfo info = this.client.inspectContainer(id);
            this.client.commitContainer(id, repo, tag, info.config(), comment, author);
            this.listImages();
            this.getImages(true);
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException | InterruptedException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumDockerLoggingStatus loggingStatus(String id) {
        Map<String, LogThread> map = this.loggingThreads;
        synchronized (map) {
            LogThread t = this.loggingThreads.get(id);
            if (t == null) {
                return EnumDockerLoggingStatus.LOGGING_NONE;
            }
            if (t.isAlive()) {
                return EnumDockerLoggingStatus.LOGGING_ACTIVE;
            }
            return EnumDockerLoggingStatus.LOGGING_COMPLETE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void stopLoggingThread(String id) {
        var2_2 = this.loggingThreads;
        synchronized (var2_2) {
            t = this.loggingThreads.get(id);
            if (t != null) {
                t.requestStop();
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            if (true) ** GOTO lbl17
        }
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
lbl17:
            // 3 sources

        } while (this.loggingStatus(id) == EnumDockerLoggingStatus.LOGGING_ACTIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logContainer(String id, OutputStream stream) throws DockerException, InterruptedException {
        try {
            Map<String, LogThread> map = this.loggingThreads;
            synchronized (map) {
                ContainerInfo info = this.client.inspectContainer(id);
                LogThread t = this.loggingThreads.get(id);
                if (t == null || !t.isAlive()) {
                    t = new LogThread(id, this.getClientCopy(), info.state().running());
                    this.loggingThreads.put(id, t);
                    t.setOutputStream(stream);
                    t.start();
                } else {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    public IDockerContainerExit waitForContainer(String id) throws DockerException, InterruptedException {
        try {
            DockerClient copy = this.getClientCopy();
            ContainerExit x = copy.waitContainer(id);
            DockerContainerExit exit = new DockerContainerExit(x.statusCode());
            this.listContainers();
            copy.close();
            return exit;
        }
        catch (ContainerNotFoundException e) {
            throw new DockerContainerNotFoundException((Exception)((Object)e));
        }
        catch (DockerRequestException e) {
            throw new DockerException(e.message());
        }
        catch (com.spotify.docker.client.DockerException e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    public void attachCommand(final String id, final InputStream in, OutputStream out) throws DockerException {
        final byte[] prevCmd = new byte[1024];
        try {
            final LogStream pty_stream = this.client.attachContainer(id, new DockerClient.AttachParameter[]{DockerClient.AttachParameter.STDIN, DockerClient.AttachParameter.STDOUT, DockerClient.AttachParameter.STDERR, DockerClient.AttachParameter.STREAM, DockerClient.AttachParameter.LOGS});
            IDockerContainerInfo info = this.getContainerInfo(id);
            boolean isTtyEnabled = info.config().tty();
            boolean isOpenStdin = info.config().openStdin();
            if (isTtyEnabled) {
                OutputStream tout = DockerConnection.noBlockingOutputStream(HttpHijackWorkaround.getOutputStream(pty_stream, this.getUri()));
                InputStream tin = HttpHijackWorkaround.getInputStream(pty_stream);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("delegateId", "org.eclipse.tm.terminal.connector.streams.launcher.streams");
                properties.put("tm.terminal.connector.id", "org.eclipse.tm.terminal.connector.streams.StreamsConnector");
                properties.put("title", info.name());
                properties.put("localEcho", false);
                properties.put("terminal.forceNew", true);
                properties.put("streams.stdin", tout);
                properties.put("streams.stdout", tin);
                properties.put("PREVENT_JVM_GC_FINALIZE", pty_stream);
                ITerminalService service = TerminalServiceFactory.getService();
                service.openConsole(properties, null);
            }
            Thread t_in = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    byte[] buff = new byte[1024];
                    try {
                        WritableByteChannel pty_out = HttpHijackWorkaround.getOutputStream(pty_stream, DockerConnection.this.getUri());
                        while (true) {
                            int n = in.read(buff);
                            if (n == -1) return;
                            if (!DockerConnection.this.getContainerInfo(id).state().running().booleanValue()) {
                                return;
                            }
                            byte[] byArray = prevCmd;
                            // MONITORENTER : prevCmd
                            pty_out.write(ByteBuffer.wrap(buff, 0, n));
                            int i = 0;
                            while (true) {
                                if (i >= prevCmd.length) {
                                    // MONITOREXIT : byArray
                                    break;
                                }
                                prevCmd[i] = buff[i];
                                ++i;
                            }
                            buff = new byte[1024];
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            if (!isTtyEnabled && isOpenStdin) {
                t_in.start();
            }
        }
        catch (Exception e) {
            throw new DockerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public String getTcpCertPath() {
        return this.tcpCertPath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockerConnection other = (DockerConnection)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name;
    }

    public static OutputStream noBlockingOutputStream(final WritableByteChannel out) {
        return new OutputStream(){

            @Override
            public synchronized void write(int i) throws IOException {
                byte[] b = new byte[]{(byte)i};
                this.write(b);
            }

            @Override
            public synchronized void write(byte[] b, int off, int len) throws IOException {
                if (len == 0) {
                    return;
                }
                ByteBuffer buff = ByteBuffer.wrap(b, off, len);
                while (buff.remaining() > 0) {
                    out.write(buff);
                }
            }

            @Override
            public void close() throws IOException {
                out.close();
            }
        };
    }

    /* synthetic */ DockerConnection(String string, String string2, String string3, String string4, DockerConnection dockerConnection) {
        this(string, string2, string3, string4);
    }

    /* synthetic */ DockerConnection(String string, String string2, String string3, String string4, String string5, DockerConnection dockerConnection) {
        this(string, string2, string3, string4, string5);
    }

    public static class Builder {
        private String unixSocketPath;
        private String name;
        private String tcpHost;
        private String tcpCertPath;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder unixSocket(String unixSocketPath) {
            if (unixSocketPath != null && !unixSocketPath.matches("\\w+://.*")) {
                unixSocketPath = "unix://" + unixSocketPath;
            }
            this.unixSocketPath = unixSocketPath;
            return this;
        }

        public Builder tcpHost(String tcpHost) {
            if (tcpHost != null) {
                if (!tcpHost.matches("\\w+://.*")) {
                    tcpHost = "tcp://" + tcpHost;
                }
                this.tcpHost = tcpHost.replace("tcp://", "http://");
            }
            return this;
        }

        public Builder tcpCertPath(String tcpCertPath) {
            this.tcpCertPath = tcpCertPath;
            if (this.tcpHost != null && this.tcpCertPath != null) {
                this.tcpHost = this.tcpHost.replace("http://", "https://");
            }
            return this;
        }

        public DockerConnection build() {
            if (this.unixSocketPath != null) {
                return new DockerConnection(this.name, this.unixSocketPath, null, null, null);
            }
            return new DockerConnection(this.name, this.tcpHost, this.tcpCertPath, null, null, null);
        }
    }

    private class LogThread
    extends AbstractKillableThread
    implements ILogger {
        private String id;
        private DockerClient copyClient;
        private OutputStream outputStream;
        private boolean follow;

        public LogThread(String id, DockerClient copyClient, boolean follow) {
            this.id = id;
            this.copyClient = copyClient;
            this.follow = follow;
        }

        @Override
        public LogThread clone() {
            return new LogThread(this.id, this.copyClient, this.follow);
        }

        @Override
        public void setOutputStream(OutputStream stream) {
            this.outputStream = stream;
        }

        @Override
        public void execute() throws InterruptedException, IOException {
            try {
                try {
                    IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
                    boolean timestamps = preferences.getBoolean("logTimestamp", true);
                    LogStream stream = null;
                    stream = timestamps ? this.copyClient.logs(this.id, new DockerClient.LogsParameter[]{DockerClient.LogsParameter.FOLLOW, DockerClient.LogsParameter.STDOUT, DockerClient.LogsParameter.STDERR, DockerClient.LogsParameter.TIMESTAMPS}) : this.copyClient.logs(this.id, new DockerClient.LogsParameter[]{DockerClient.LogsParameter.FOLLOW, DockerClient.LogsParameter.STDOUT, DockerClient.LogsParameter.STDERR});
                    int delayTime = 100;
                    do {
                        Thread.sleep(delayTime);
                        delayTime = 1000;
                        while (stream.hasNext()) {
                            ByteBuffer b = ((LogMessage)stream.next()).content();
                            byte[] bytes = new byte[b.remaining()];
                            b.get(bytes);
                            if (this.outputStream == null) continue;
                            this.outputStream.write(bytes);
                        }
                    } while (this.follow && !this.stop);
                    DockerConnection.this.listContainers();
                }
                catch (DockerRequestException e) {
                    Activator.logErrorMessage(e.message());
                    throw new InterruptedException();
                }
                catch (com.spotify.docker.client.DockerException | IOException e) {
                    Activator.logErrorMessage(e.getMessage());
                    throw new InterruptedException();
                }
                catch (Exception e) {
                    Activator.logErrorMessage(e.getMessage());
                    this.follow = false;
                    this.copyClient.close();
                    if (this.outputStream != null) {
                        this.outputStream.close();
                    }
                }
            }
            finally {
                this.follow = false;
                this.copyClient.close();
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
        }
    }
}

