/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerConnectionInfo;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettingsFinder;
import org.eclipse.linuxtools.docker.core.Messages;
import org.eclipse.linuxtools.internal.docker.core.BaseConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.UnixSocketConnectionSettings;

public class DefaultDockerConnectionSettingsFinder
implements IDockerConnectionSettingsFinder {
    public static final String DOCKER_CERT_PATH = "DOCKER_CERT_PATH";
    public static final String DOCKER_TLS_VERIFY = "DOCKER_TLS_VERIFY";
    public static final String DOCKER_TLS_VERIFY_TRUE = "1";
    public static final String DOCKER_HOST = "DOCKER_HOST";

    @Override
    public List<IDockerConnectionSettings> findConnectionSettings() {
        IDockerConnectionSettings defaultsWithShellEnv;
        IDockerConnectionSettings defaultsWithSystemEnv;
        ArrayList<IDockerConnectionSettings> availableConnectionSettings = new ArrayList<IDockerConnectionSettings>();
        IDockerConnectionSettings defaultsWithUnixSocket = this.defaultsWithUnixSocket();
        if (defaultsWithUnixSocket != null) {
            availableConnectionSettings.add(defaultsWithUnixSocket);
        }
        if ((defaultsWithSystemEnv = this.defaultsWithSystemEnv()) != null) {
            availableConnectionSettings.add(defaultsWithSystemEnv);
        }
        if ((defaultsWithShellEnv = this.defaultsWithShellEnv()) != null) {
            availableConnectionSettings.add(defaultsWithShellEnv);
        }
        for (IDockerConnectionSettings connectionSettings : availableConnectionSettings) {
            switch (connectionSettings.getType()) {
                case UNIX_SOCKET_CONNECTION: {
                    UnixSocketConnectionSettings unixSocketConnectionSettings = (UnixSocketConnectionSettings)connectionSettings;
                    DockerConnection unixSocketConnection = new DockerConnection.Builder().unixSocket(unixSocketConnectionSettings.getPath()).build();
                    this.resolveDockerName(unixSocketConnectionSettings, unixSocketConnection);
                    break;
                }
                case TCP_CONNECTION: {
                    TCPConnectionSettings tcpConnectionSettings = (TCPConnectionSettings)connectionSettings;
                    DockerConnection tcpConnection = new DockerConnection.Builder().tcpHost(tcpConnectionSettings.getHost()).tcpCertPath(tcpConnectionSettings.getPathToCertificates()).build();
                    this.resolveDockerName(tcpConnectionSettings, tcpConnection);
                }
            }
        }
        return availableConnectionSettings;
    }

    private void resolveDockerName(BaseConnectionSettings connectionSettings, DockerConnection connection) {
        try {
            try {
                connection.open(false);
                IDockerConnectionInfo info = connection.getInfo();
                if (info != null) {
                    connectionSettings.setName(info.getName());
                    connectionSettings.setSettingsResolved(true);
                }
            }
            catch (DockerException e) {
                connectionSettings.setSettingsResolved(false);
                connection.close();
            }
        }
        finally {
            connection.close();
        }
    }

    private IDockerConnectionSettings defaultsWithUnixSocket() {
        File unixSocketFile = new File("/var/run/docker.sock");
        if (unixSocketFile.exists() && unixSocketFile.canRead() && unixSocketFile.canWrite()) {
            UnixSocketAddress address = new UnixSocketAddress(unixSocketFile);
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (UnixSocketChannel channel = UnixSocketChannel.open((UnixSocketAddress)address);){
                    return new UnixSocketConnectionSettings(unixSocketFile.getAbsolutePath());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private IDockerConnectionSettings defaultsWithSystemEnv() {
        String dockerHostEnv = System.getenv(DOCKER_HOST);
        if (dockerHostEnv != null) {
            String tlsVerifyEnv = System.getenv(DOCKER_TLS_VERIFY);
            boolean useTls = tlsVerifyEnv != null && tlsVerifyEnv.equals(DOCKER_TLS_VERIFY_TRUE);
            String pathToCertificates = System.getenv(DOCKER_CERT_PATH);
            return new TCPConnectionSettings(dockerHostEnv, useTls, pathToCertificates);
        }
        return null;
    }

    private IDockerConnectionSettings defaultsWithShellEnv() {
        String connectionSettingsDetectionScriptName;
        block5: {
            connectionSettingsDetectionScriptName = this.getConnectionSettingsDetectionScriptName();
            if (connectionSettingsDetectionScriptName != null) break block5;
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", Messages.Docker_No_Settings_Description_Script));
            return null;
        }
        try {
            File connectionSettingsDetectionScript = this.getConnectionSettingsDetectionScript(connectionSettingsDetectionScriptName);
            String[] cmdArray = this.getConnectionSettingsDetectionCommandArray(connectionSettingsDetectionScript);
            Process process = Runtime.getRuntime().exec(cmdArray);
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue == 0) {
                InputStream processInputStream = process.getInputStream();
                Properties dockerSettings = new Properties();
                dockerSettings.load(processInputStream);
                Object dockerHostEnvVariable = dockerSettings.get(DOCKER_HOST);
                Object dockerTlsVerifyEnvVariable = dockerSettings.get(DOCKER_TLS_VERIFY);
                Object dockerCertPathEnvVariable = dockerSettings.get(DOCKER_CERT_PATH);
                return new TCPConnectionSettings(dockerHostEnvVariable != null ? dockerHostEnvVariable.toString() : null, dockerTlsVerifyEnvVariable != null ? Boolean.valueOf(dockerTlsVerifyEnvVariable.equals(DOCKER_TLS_VERIFY_TRUE)) : null, dockerCertPathEnvVariable != null ? dockerCertPathEnvVariable.toString() : null);
            }
            if (exitValue != 1) {
                InputStream processErrorStream = process.getErrorStream();
                String errorMessage = this.streamToString(processErrorStream);
                Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", errorMessage));
            }
        }
        catch (IOException | IllegalArgumentException | InterruptedException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.core", Messages.Retrieve_Default_Settings_Failure, (Throwable)e));
        }
        return null;
    }

    private String[] getConnectionSettingsDetectionCommandArray(File script) {
        if (Platform.getOS().equals("win32")) {
            return new String[]{"cmd.exe", "/C", script.getAbsolutePath()};
        }
        return new String[]{script.getAbsolutePath()};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File getConnectionSettingsDetectionScript(String scriptName) {
        File script = Activator.getDefault().getBundle().getDataFile(scriptName);
        if (script == null || script.exists() && script.lastModified() >= Activator.getDefault().getBundle().getLastModified()) return script;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileOutputStream output = new FileOutputStream(script);
                try {
                    try (InputStream is = DockerConnection.class.getResourceAsStream("/resources/" + scriptName);){
                        int n;
                        byte[] buff = new byte[1024];
                        while ((n = is.read(buff)) > 0) {
                            output.write(buff, 0, n);
                        }
                        script.setExecutable(true);
                    }
                    if (output == null) return script;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (output == null) throw throwable;
                    output.close();
                    throw throwable;
                }
                output.close();
                return script;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.logErrorMessage(e.getMessage());
        }
        return script;
    }

    private String getConnectionSettingsDetectionScriptName() {
        if (Platform.getOS().equals("linux")) {
            return "script.sh";
        }
        if (Platform.getOS().equals("macosx")) {
            return "script-macosx.sh";
        }
        if (Platform.getOS().equals("win32")) {
            return "script.bat";
        }
        return null;
    }

    private String streamToString(InputStream stream) {
        BufferedReader buff = new BufferedReader(new InputStreamReader(stream));
        StringBuffer res = new StringBuffer();
        String line = "";
        try {
            while ((line = buff.readLine()) != null) {
                res.append(System.getProperty("line.separator"));
                res.append(line);
            }
            buff.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res.length() > 0 ? res.substring(1) : "";
    }

    public static class Defaults {
        public static final String DEFAULT_UNIX_SOCKET_PATH = "unix:///var/run/docker.sock";
        private boolean settingsResolved;
        private String name = null;
        private final Map<EnumDockerConnectionSettings, Object> settings = new HashMap<EnumDockerConnectionSettings, Object>();

        public boolean isSettingsResolved() {
            return this.settingsResolved;
        }

        public String getName() {
            return this.name;
        }

        public EnumDockerConnectionSettings getBindingMode() {
            if (this.settings.containsKey((Object)EnumDockerConnectionSettings.BINDING_MODE)) {
                return (EnumDockerConnectionSettings)((Object)this.settings.get((Object)EnumDockerConnectionSettings.BINDING_MODE));
            }
            return EnumDockerConnectionSettings.UNIX_SOCKET;
        }

        public String getUnixSocketPath() {
            return (String)this.settings.get((Object)EnumDockerConnectionSettings.UNIX_SOCKET_PATH);
        }

        public String getTcpHost() {
            return (String)this.settings.get((Object)EnumDockerConnectionSettings.TCP_HOST);
        }

        public boolean getTcpTlsVerify() {
            if (this.settings.containsKey((Object)EnumDockerConnectionSettings.TCP_TLS_VERIFY)) {
                return (Boolean)this.settings.get((Object)EnumDockerConnectionSettings.TCP_TLS_VERIFY);
            }
            return false;
        }

        public String getTcpCertPath() {
            return (String)this.settings.get((Object)EnumDockerConnectionSettings.TCP_CERT_PATH);
        }
    }
}

