/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.coordinates.rcp;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.IProjectCoordinateAdvisor;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.internal.coordinates.rcp.ProjectCoordinateJsonTypeAdapter;
import org.eclipse.recommenders.internal.coordinates.rcp.l10n.LogMessages;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.utils.Logs;

public class ManualProjectCoordinateAdvisor
implements IProjectCoordinateAdvisor,
IRcpService {
    private final File persistenceFile;
    private final Gson gson;
    private Map<DependencyInfo, ProjectCoordinate> manualMappings = Maps.newHashMap();
    private static final Type MANUAL_MAPPINGS_TYPE_TOKEN = new TypeToken<Map<DependencyInfo, ProjectCoordinate>>(){}.getType();

    @Inject
    public ManualProjectCoordinateAdvisor(@Named(value="MANUAL_MAPPINGS") File persistenceFile) {
        this.persistenceFile = persistenceFile;
        this.gson = new GsonBuilder().registerTypeAdapter(ProjectCoordinate.class, (Object)new ProjectCoordinateJsonTypeAdapter()).enableComplexMapKeySerialization().serializeNulls().create();
    }

    public Optional<ProjectCoordinate> suggest(DependencyInfo dependencyInfo) {
        ProjectCoordinate pc = this.manualMappings.get(dependencyInfo);
        if (pc != null) {
            return Optional.of((Object)pc);
        }
        return Optional.absent();
    }

    public void setManualMapping(DependencyInfo dependencyInfo, ProjectCoordinate pc) {
        this.manualMappings.put(dependencyInfo, pc);
    }

    public void removeManualMapping(DependencyInfo dependencyInfo) {
        this.manualMappings.remove(dependencyInfo);
    }

    @PostConstruct
    public void open() throws IOException {
        if (!this.persistenceFile.exists()) {
            return;
        }
        try {
            String json = Files.toString((File)this.persistenceFile, (Charset)Charsets.UTF_8);
            Map deserialized = (Map)this.gson.fromJson(json, MANUAL_MAPPINGS_TYPE_TOKEN);
            if (deserialized != null) {
                this.manualMappings = deserialized;
            }
        }
        catch (JsonParseException | IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_READ_MANUAL_MAPPINGS, (Throwable)e, (Object[])new Object[]{this.persistenceFile});
            return;
        }
    }

    @PreDestroy
    public void close() throws IOException {
        try {
            String json = this.gson.toJson(this.manualMappings, MANUAL_MAPPINGS_TYPE_TOKEN);
            Files.write((CharSequence)json, (File)this.persistenceFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_WRITE_MANUAL_MAPPINGS, (Throwable)e, (Object[])new Object[]{this.persistenceFile});
            FileUtils.deleteQuietly((File)this.persistenceFile);
        }
    }
}

