/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.xulrunner.editor;

import org.eclipse.swt.graphics.Point;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.jboss.tools.vpe.xulrunner.util.XulRunnerVpeUtils;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNSHTMLElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;

public class XulRunnerHint {
    private Point position;
    private nsIDOMDocument document;
    private nsIDOMElement hintElement;
    private String hint;

    public XulRunnerHint(nsIDOMDocument document) {
        this.document = document;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public void redraw() {
        if (this.hintElement == null) {
            nsIDOMElement parent = XulRunnerVpeUtils.getRootElement(this.document);
            this.hintElement = XulRunnerVpeUtils.createAnonymousElement(this.document, "span", (nsIDOMNode)parent, "mozResizingInfo", false);
        }
        nsIDOMNSHTMLElement hintHtmlElement = XPCOM.queryInterface((nsISupports)this.hintElement, nsIDOMNSHTMLElement.class);
        if (this.hint == null) {
            hintHtmlElement.setInnerHTML("");
            this.hintElement.setAttribute("style", "visibility:hidden");
        } else {
            this.hintElement.setAttribute("style", "");
            hintHtmlElement.setInnerHTML(this.hint);
            XulRunnerVpeUtils.setElementPosition(this.hintElement, this.position.x, this.position.y);
        }
    }

    public void dispose() {
        if (this.hintElement != null && this.hintElement.getParentNode() != null) {
            this.hintElement.getParentNode().removeChild((nsIDOMNode)this.hintElement);
        }
        this.hintElement = null;
        this.document = null;
    }
}

