/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.marker;

import java.text.MessageFormat;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.quickfix.IQuickFix;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;
import org.jboss.tools.common.refactoring.TestableResolutionWithDialog;
import org.jboss.tools.common.ui.CommonUIPlugin;

public class MakeFieldProtectedMarkerResolution
implements IQuickFix,
TestableResolutionWithDialog {
    private static final String PUBLIC = "public";
    private static final String PROTECTED = "protected";
    private String label;
    private IField field;
    private String description;
    private ICompilationUnit cUnit;

    public MakeFieldProtectedMarkerResolution(IField field) {
        this.cUnit = CDIMarkerResolutionUtils.getJavaMember((IJavaElement)field).getCompilationUnit();
        this.label = MessageFormat.format(CDIUIMessages.MAKE_FIELD_PROTECTED_MARKER_RESOLUTION_TITLE, field.getElementName());
        this.field = field;
        this.description = this.getPreview();
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        this.do_run(false, false);
    }

    public void runForTest(IMarker marker) {
        this.do_run(false, true);
    }

    private void do_run(boolean leaveDirty, boolean test) {
        Shell shell;
        boolean cont;
        if (!test && !(cont = MessageDialog.openQuestion((Shell)(shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()), (String)CDIUIMessages.QUESTION, (String)CDIUIMessages.DECREASING_FIELD_VISIBILITY_MAY_CAUSE_COMPILATION_PROBLEMS))) {
            return;
        }
        try {
            if (this.cUnit == null) {
                return;
            }
            ICompilationUnit compilationUnit = this.cUnit.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            CompilationUnitChange change = this.getChange(compilationUnit);
            if (change.getEdit().hasChildren()) {
                if (leaveDirty) {
                    change.setSaveMode(4);
                }
                change.perform((IProgressMonitor)new NullProgressMonitor());
                this.cUnit.reconcile(0, false, null, (IProgressMonitor)new NullProgressMonitor());
            }
            compilationUnit.discardWorkingCopy();
        }
        catch (CoreException ex) {
            CDIUIPlugin.getDefault().logError(ex);
        }
    }

    private CompilationUnitChange getChange(ICompilationUnit compilationUnit) throws JavaModelException {
        CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
        MultiTextEdit edit = new MultiTextEdit();
        change.setEdit((TextEdit)edit);
        IBuffer buffer = compilationUnit.getBuffer();
        int flag = this.field.getFlags();
        String text = buffer.getText(this.field.getSourceRange().getOffset(), this.field.getSourceRange().getLength());
        int position = this.field.getSourceRange().getOffset();
        if (Flags.isPublic((int)flag)) {
            ReplaceEdit re = new ReplaceEdit(position += text.indexOf(PUBLIC), PUBLIC.length(), PROTECTED);
            edit.addChild((TextEdit)re);
        }
        return change;
    }

    private CompilationUnitChange getPreviewChange() {
        if (this.cUnit != null) {
            try {
                ICompilationUnit compilationUnit = this.cUnit.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                CompilationUnitChange change = this.getChange(compilationUnit);
                compilationUnit.discardWorkingCopy();
                return change;
            }
            catch (JavaModelException e) {
                CommonPlugin.getDefault().logError((Throwable)e);
            }
        }
        return null;
    }

    private String getPreview() {
        CompilationUnitChange previewChange = this.getPreviewChange();
        try {
            return MarkerResolutionUtils.getPreview((Change)previewChange);
        }
        catch (CoreException e) {
            CommonUIPlugin.getDefault().logError((Throwable)e);
            return this.label;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Image getImage() {
        return CDIImages.getImage((ImageDescriptor)CDIImages.QUICKFIX_EDIT);
    }

    public int getRelevance() {
        return 100;
    }

    public void apply(IDocument document) {
        this.do_run(true, false);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.description;
    }

    public String getDisplayString() {
        return this.label;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

