/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.category;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.site.WorkspaceSiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewCategoryCreationOperation
extends WorkspaceModifyOperation {
    private Display fDisplay;
    private final IPath fPath;
    private final String fFileName;

    public NewCategoryCreationOperation(Display display, IPath path, String fileName) {
        this.fDisplay = display;
        this.fPath = path;
        this.fFileName = fileName;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.beginTask(PDEUIMessages.NewCategoryDefinitionWizard_creatingManifest, 2);
        IFile file = this.createSiteManifest();
        monitor.worked(1);
        this.openFile(file);
        monitor.worked(1);
    }

    private IFile createSiteManifest() {
        IPath fFilePath = this.fPath.append(this.fFileName);
        IFile categoryFile = PDECore.getWorkspace().getRoot().getFile(fFilePath);
        if (categoryFile.exists()) {
            return categoryFile;
        }
        WorkspaceSiteModel model = new WorkspaceSiteModel(categoryFile);
        model.getSite();
        model.save();
        model.dispose();
        IDE.setDefaultEditor((IFile)categoryFile, (String)"org.eclipse.pde.ui.categoryEditor");
        return categoryFile;
    }

    private void openFile(final IFile file) {
        this.fDisplay.asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
                if (ww == null) {
                    return;
                }
                IWorkbenchPage page = ww.getActivePage();
                if (page == null || !file.exists()) {
                    return;
                }
                IWorkbenchPart focusPart = page.getActivePart();
                if (focusPart instanceof ISetSelectionTarget) {
                    StructuredSelection selection = new StructuredSelection((Object)file);
                    ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                }
                try {
                    page.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.pde.ui.categoryEditor");
                }
                catch (PartInitException partInitException) {}
            }
        });
    }
}

