/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.js.bower.internal.wizard;

import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.jst.js.bower.BowerJson;
import org.jboss.tools.jst.js.bower.internal.Messages;
import org.jboss.tools.jst.js.bower.internal.wizard.BowerInitPage;
import org.jboss.tools.jst.js.bower.util.BowerUtil;
import org.jboss.tools.jst.js.internal.Activator;
import org.jboss.tools.jst.js.util.WorkbenchResourceUtil;

public class BowerInitWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private BowerInitPage bowerInitPage;

    public BowerInitWizard() {
        this.setDefaultPageImageDescriptor(Activator.getImageDescriptor("/icons/bower_75.png"));
        this.setWindowTitle(Messages.BowerInitWizard_windowTitle);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        super.addPages();
        this.bowerInitPage = new BowerInitPage(this.selection);
        this.addPage((IWizardPage)this.bowerInitPage);
    }

    public boolean performFinish() {
        BowerJson bowerJson = this.bowerInitPage.getModel();
        String dir = this.bowerInitPage.getExecutionDir();
        try {
            IFile file;
            IContainer root = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(dir));
            if (root != null && root.exists() && !(file = ((Container)root).getFile("bower.json")).exists()) {
                String json = BowerUtil.generateJson(bowerJson);
                WorkbenchResourceUtil.createFile(file, json);
                WorkbenchResourceUtil.openInEditor(file, null);
            }
        }
        catch (CoreException e) {
            Activator.logError(e);
            return false;
        }
        return true;
    }
}

