/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.js.bower.internal.util;

import java.io.File;
import org.jboss.tools.common.util.PlatformUtil;

public final class ExternalToolDetector {
    private static final String USR_LOCAL_BIN = "/usr/local/bin";
    private static final String USR_BIN = "/usr/bin";

    private ExternalToolDetector() {
    }

    public static String detectNode() {
        String nodeLocation = ExternalToolDetector.detectFromPath(String.valueOf(File.separator) + "nodejs");
        if (nodeLocation == null) {
            if (PlatformUtil.isLinux()) {
                nodeLocation = ExternalToolDetector.detectNodeOnLinux();
            } else if (PlatformUtil.isMacOS()) {
                nodeLocation = ExternalToolDetector.detectNodeOnMac();
            }
        }
        return nodeLocation;
    }

    private static String detectNodeOnLinux() {
        String nodeLocation = null;
        File usrLocalBin = new File(USR_LOCAL_BIN);
        File usrBin = new File(USR_BIN);
        if (ExternalToolDetector.isDetected(usrLocalBin, "nodejs")) {
            nodeLocation = usrLocalBin.getAbsolutePath();
        } else if (ExternalToolDetector.isDetected(usrBin, "nodejs")) {
            nodeLocation = usrBin.getAbsolutePath();
        }
        if (nodeLocation == null) {
            if (ExternalToolDetector.isDetected(usrLocalBin, "node")) {
                nodeLocation = usrLocalBin.getAbsolutePath();
            } else if (ExternalToolDetector.isDetected(usrBin, "node")) {
                nodeLocation = usrBin.getAbsolutePath();
            }
        }
        return nodeLocation;
    }

    private static String detectNodeOnMac() {
        String nodeLocation = null;
        File usrLocalBin = new File(USR_LOCAL_BIN);
        File usrBin = new File(USR_BIN);
        if (ExternalToolDetector.isDetected(usrLocalBin, "node")) {
            nodeLocation = usrLocalBin.getAbsolutePath();
        } else if (ExternalToolDetector.isDetected(usrBin, "node")) {
            nodeLocation = usrBin.getAbsolutePath();
        }
        return nodeLocation;
    }

    public static String detectBower() {
        String bowerLocation = null;
        if (PlatformUtil.isWindows()) {
            String npmLocation = ExternalToolDetector.detectNpmFromPath();
            if (npmLocation != null) {
                File bowerHome;
                String separator = File.separator;
                if (!npmLocation.endsWith(separator)) {
                    npmLocation = String.valueOf(npmLocation) + separator;
                }
                if ((bowerHome = new File(npmLocation, "node_modules" + separator + "bower" + separator + "bin")) != null && bowerHome.exists()) {
                    bowerLocation = bowerHome.getAbsolutePath();
                }
            }
        } else {
            File usrLocalBin = new File(USR_LOCAL_BIN);
            if (ExternalToolDetector.isDetected(usrLocalBin, "bower")) {
                bowerLocation = usrLocalBin.getAbsolutePath();
            } else {
                File usrBin = new File(USR_BIN);
                if (ExternalToolDetector.isDetected(usrBin, "bower")) {
                    bowerLocation = usrBin.getAbsolutePath();
                }
            }
        }
        return bowerLocation;
    }

    private static boolean isDetected(File parent, String name) {
        File file;
        return parent != null && parent.exists() && (file = new File(parent, name)) != null && file.exists();
    }

    private static String detectNpmFromPath() {
        return ExternalToolDetector.detectFromPath(String.valueOf(File.separator) + "npm");
    }

    private static String detectFromPath(String pattern) {
        String location = null;
        String path = ExternalToolDetector.getPath();
        String spliter = ExternalToolDetector.getPathSpliter();
        if (path != null) {
            String[] pathElements;
            String[] stringArray = pathElements = path.split(spliter);
            int n = pathElements.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (element.contains(pattern)) {
                    location = element;
                    break;
                }
                ++n2;
            }
        }
        return location;
    }

    private static String getPath() {
        return System.getenv("PATH");
    }

    private static String getPathSpliter() {
        return PlatformUtil.isWindows() ? ";" : ":";
    }
}

