/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.symbols;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.source.AbstractContextSymbolFactory;
import org.eclipse.jst.jsf.context.symbol.source.IAdditionalContextSymbolInfo;
import org.eclipse.jst.jsf.designtime.symbols.FileContextUtil;
import org.eclipse.jst.jsf.designtime.symbols.JSFSymbolFactory;
import org.eclipse.jst.jsf.validation.internal.appconfig.AppConfigValidationUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ValueExpressionSymbolFactory
extends AbstractContextSymbolFactory {
    private final JSFSymbolFactory _factory = new JSFSymbolFactory();

    protected ISymbol internalCreate(String symbolName, int scope, IAdaptable context, List problems, IAdditionalContextSymbolInfo additionalInfo) {
        Node node = this.getNode(context);
        IStructuredDocumentContext sContext = this.getContext(context);
        String valueAttrName = additionalInfo.getValueExpressionAttributeName();
        if (node != null && valueAttrName != null) {
            Element element = null;
            element = node instanceof Element ? (Element)node : ((Attr)node).getOwnerElement();
            return this.createSymbol(symbolName, sContext, valueAttrName, element);
        }
        return null;
    }

    private ISymbol createSymbol(String name, IStructuredDocumentContext sContext, String valueAttrName, Element element) {
        Attr attr;
        if (element instanceof IDOMElement && (attr = element.getAttributeNode(valueAttrName)) instanceof IDOMAttr && attr.getValue() != null) {
            ValueType valueExpr;
            String elText = AppConfigValidationUtil.extractELExpression(attr.getValue()).getElText();
            IFile file = FileContextUtil.deriveIFileFromContext((IAdaptable)sContext);
            IStructuredDocumentContext elContext = IStructuredDocumentContextFactory.INSTANCE.getContext(sContext.getStructuredDocument(), (Node)attr);
            if (elText != null && file != null && elContext != null && (valueExpr = this._factory.getValueTypeFromEL(elText, elContext, file)) != null) {
                IJavaProject javaProject = this.getJavaProject((IAdaptable)sContext);
                return this._factory.createJavaComponentSymbol(name, valueExpr, null, javaProject);
            }
        }
        return null;
    }

    protected ISymbol internalCreate(String symbolName, int scope, IAdaptable context, List problems) {
        return null;
    }

    public boolean supports(IAdaptable context) {
        Node node = this.getNode(context);
        IJavaProject javaProject = this.getJavaProject(context);
        return javaProject != null && node instanceof Element || node instanceof Attr;
    }

    private Node getNode(IAdaptable context) {
        IDOMContextResolver domResolver;
        IStructuredDocumentContext sContext = this.getContext(context);
        if (sContext != null && (domResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(sContext)) != null) {
            return domResolver.getNode();
        }
        return null;
    }

    private IJavaProject getJavaProject(IAdaptable context) {
        IProject project;
        IStructuredDocumentContext sContext = this.getContext(context);
        if (sContext != null && (project = FileContextUtil.getProject((IStructuredDocumentContext)sContext.getAdapter(IStructuredDocumentContext.class))) != null) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    private IStructuredDocumentContext getContext(IAdaptable context) {
        if (context != null) {
            return (IStructuredDocumentContext)context.getAdapter(IStructuredDocumentContext.class);
        }
        return null;
    }
}

