/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParamAnnotations;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.search.JavaMemberSearchResultCollector;
import org.jboss.tools.ws.jaxrs.core.internal.utils.CollectionUtils;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;

public final class JavaElementsSearcher {
    private JavaElementsSearcher() {
    }

    public static Set<IType> findApplicationTypes(IJavaElement scope, IProgressMonitor progressMonitor) throws CoreException {
        Set<IType> set;
        long start = System.currentTimeMillis();
        try {
            IJavaSearchScope searchScope = JavaElementsSearcher.createSearchScope(scope);
            Set<IType> applicationTypes = JavaElementsSearcher.searchForAnnotatedTypes("javax.ws.rs.ApplicationPath", searchScope, progressMonitor);
            List<IType> applicationSubtypes = JavaElementsSearcher.findSubtypes(scope, "javax.ws.rs.core.Application", progressMonitor);
            applicationTypes.addAll(CollectionUtils.difference(applicationSubtypes, applicationTypes));
            set = applicationTypes;
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            Logger.tracePerf("Found Application types in scope {} in {}ms", scope.getElementName(), end - start);
            throw throwable;
        }
        long end = System.currentTimeMillis();
        Logger.tracePerf("Found Application types in scope {} in {}ms", scope.getElementName(), end - start);
        return set;
    }

    public static Set<IType> findProviderTypes(IJavaElement scope, IProgressMonitor progressMonitor) throws CoreException {
        HashSet<IType> hashSet;
        long start = System.currentTimeMillis();
        try {
            HashSet<IType> providerTypes = new HashSet<IType>();
            IJavaSearchScope searchScope = JavaElementsSearcher.createSearchScope(scope);
            Set<IType> annotatedTypes = JavaElementsSearcher.searchForAnnotatedTypes("javax.ws.rs.ext.Provider", searchScope, progressMonitor);
            providerTypes.addAll(annotatedTypes);
            providerTypes.addAll(JavaElementsSearcher.findSubtypes(scope, "javax.ws.rs.ext.MessageBodyReader", progressMonitor));
            providerTypes.addAll(JavaElementsSearcher.findSubtypes(scope, "javax.ws.rs.ext.MessageBodyWriter", progressMonitor));
            providerTypes.addAll(JavaElementsSearcher.findSubtypes(scope, "javax.ws.rs.ext.ExceptionMapper", progressMonitor));
            providerTypes.addAll(JavaElementsSearcher.findSubtypes(scope, "javax.ws.rs.container.ContainerRequestFilter", progressMonitor));
            providerTypes.addAll(JavaElementsSearcher.findSubtypes(scope, "javax.ws.rs.container.ContainerResponseFilter", progressMonitor));
            providerTypes.addAll(JavaElementsSearcher.findSubtypes(scope, "javax.ws.rs.ext.ReaderInterceptor", progressMonitor));
            providerTypes.addAll(JavaElementsSearcher.findSubtypes(scope, "javax.ws.rs.ext.WriterInterceptor", progressMonitor));
            hashSet = providerTypes;
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            Logger.tracePerf("Found Provider types in scope {} in {}ms", scope.getElementName(), end - start);
            throw throwable;
        }
        long end = System.currentTimeMillis();
        Logger.tracePerf("Found Provider types in scope {} in {}ms", scope.getElementName(), end - start);
        return hashSet;
    }

    public static Set<IType> findParamConverterProviderTypes(IJavaElement scope, IProgressMonitor progressMonitor) throws CoreException {
        HashSet<IType> hashSet;
        long start = System.currentTimeMillis();
        try {
            HashSet<IType> paramConverterTypes = new HashSet<IType>();
            IJavaSearchScope searchScope = JavaElementsSearcher.createSearchScope(scope);
            Set<IType> annotatedTypes = JavaElementsSearcher.searchForAnnotatedTypes("javax.ws.rs.ext.Provider", searchScope, progressMonitor);
            paramConverterTypes.addAll(annotatedTypes);
            List<IType> paramConverterProviderSubtypes = JavaElementsSearcher.findSubtypes(scope, "javax.ws.rs.ext.ParamConverterProvider", progressMonitor);
            paramConverterTypes.addAll(CollectionUtils.difference(paramConverterProviderSubtypes, paramConverterTypes));
            hashSet = paramConverterTypes;
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            Logger.tracePerf("Found Provider types in scope {} in {}ms", scope.getElementName(), end - start);
            throw throwable;
        }
        long end = System.currentTimeMillis();
        Logger.tracePerf("Found Provider types in scope {} in {}ms", scope.getElementName(), end - start);
        return hashSet;
    }

    public static Set<IType> findParameterAggregatorTypes(IJavaElement scope, IProgressMonitor progressMonitor) throws CoreException {
        HashSet<IType> hashSet;
        long start = System.currentTimeMillis();
        try {
            HashSet<IType> types = new HashSet<IType>();
            IJavaSearchScope searchScope = JavaElementsSearcher.createSearchScope(scope);
            Set<IMethod> annotatedMethods = JavaElementsSearcher.searchForAnnotatedMethods(JaxrsParamAnnotations.PARAM_ANNOTATIONS, searchScope, progressMonitor);
            for (IMethod annotatedMethod : annotatedMethods) {
                types.add((IType)annotatedMethod.getAncestor(7));
            }
            Set<IField> annotatedFields = JavaElementsSearcher.searchForAnnotatedFields(JaxrsParamAnnotations.PARAM_ANNOTATIONS, searchScope, progressMonitor);
            for (IField annotatedField : annotatedFields) {
                types.add((IType)annotatedField.getAncestor(7));
            }
            hashSet = types;
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            Logger.tracePerf("Found Provider types in scope {} in {}ms", scope.getElementName(), end - start);
            throw throwable;
        }
        long end = System.currentTimeMillis();
        Logger.tracePerf("Found Provider types in scope {} in {}ms", scope.getElementName(), end - start);
        return hashSet;
    }

    private static List<IType> findSubtypes(IJavaElement scope, String typeName, IProgressMonitor progressMonitor) throws CoreException, JavaModelException {
        IType superType = JdtUtils.resolveType(typeName, scope.getJavaProject(), progressMonitor);
        List<IType> subtypes = JdtUtils.findSubtypes(scope, superType, progressMonitor);
        return subtypes;
    }

    public static Set<IType> findResourceTypes(IJavaElement scope, IProgressMonitor progressMonitor) throws CoreException {
        Set<IType> set;
        long start = System.currentTimeMillis();
        try {
            IJavaSearchScope searchScope = JavaElementsSearcher.createSearchScope(scope);
            set = JavaElementsSearcher.searchForAnnotatedTypes("javax.ws.rs.Path", searchScope, progressMonitor);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            Logger.tracePerf("Found Resource types in scope {} in {}ms", scope.getElementName(), end - start);
            throw throwable;
        }
        long end = System.currentTimeMillis();
        Logger.tracePerf("Found Resource types in scope {} in {}ms", scope.getElementName(), end - start);
        return set;
    }

    public static Set<IType> findHttpMethodTypes(IJavaElement scope, IProgressMonitor progressMonitor) throws CoreException {
        Set<IType> set;
        long start = System.currentTimeMillis();
        try {
            IJavaSearchScope searchScope = JavaElementsSearcher.createSearchScope(scope);
            set = JavaElementsSearcher.searchForAnnotatedTypes("javax.ws.rs.HttpMethod", searchScope, progressMonitor);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            Logger.tracePerf("Found HTTP Method types in scope {} in {}ms", scope.getElementName(), end - start);
            throw throwable;
        }
        long end = System.currentTimeMillis();
        Logger.tracePerf("Found HTTP Method types in scope {} in {}ms", scope.getElementName(), end - start);
        return set;
    }

    public static Set<IType> findNameBindingTypes(IJavaElement scope, IProgressMonitor progressMonitor) throws CoreException {
        Set<IType> set;
        long start = System.currentTimeMillis();
        try {
            IJavaSearchScope searchScope = JavaElementsSearcher.createSearchScope(scope);
            set = JavaElementsSearcher.searchForAnnotatedTypes("javax.ws.rs.NameBinding", searchScope, progressMonitor);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            Logger.tracePerf("Found NameBinding types in scope {} in {}ms", scope.getElementName(), end - start);
            throw throwable;
        }
        long end = System.currentTimeMillis();
        Logger.tracePerf("Found NameBinding types in scope {} in {}ms", scope.getElementName(), end - start);
        return set;
    }

    public static Set<IMethod> findAnnotatedMethods(IJavaProject scope, String fullyQualifiedName, IProgressMonitor progressMonitor) throws CoreException {
        Set<IMethod> set;
        long start = System.currentTimeMillis();
        try {
            IJavaSearchScope searchScope = JavaElementsSearcher.createSearchScope((IJavaElement)scope);
            set = JavaElementsSearcher.searchForAnnotatedMethods(Arrays.asList(fullyQualifiedName), searchScope, progressMonitor);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            Logger.tracePerf("Found HTTP Method types in scope {} in {}ms", scope.getElementName(), end - start);
            throw throwable;
        }
        long end = System.currentTimeMillis();
        Logger.tracePerf("Found HTTP Method types in scope {} in {}ms", scope.getElementName(), end - start);
        return set;
    }

    private static IJavaSearchScope createSearchScope(IJavaElement scope) throws JavaModelException {
        IJavaSearchScope searchScope = scope instanceof IJavaProject ? SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{scope}, (int)9) : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{scope});
        return searchScope;
    }

    private static IJavaSearchScope createSearchScope(List<? extends IJavaElement> scope) throws JavaModelException {
        return SearchEngine.createJavaSearchScope((IJavaElement[])scope.toArray(new IJavaElement[scope.size()]));
    }

    private static Set<IType> searchForAnnotatedTypes(String annotationName, IJavaSearchScope searchScope, IProgressMonitor progressMonitor) throws CoreException {
        JavaMemberSearchResultCollector collector = new JavaMemberSearchResultCollector(7, searchScope);
        SearchPattern pattern = SearchPattern.createPattern((String)annotationName, (int)8, (int)65536, (int)8);
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)collector, progressMonitor);
        return collector.getResult();
    }

    public static Set<IMethod> findResourceMethods(IJavaElement scope, Set<String> httpMethodNames, IProgressMonitor progressMonitor) throws CoreException {
        IJavaSearchScope searchScope = JavaElementsSearcher.createSearchScope(scope);
        ArrayList<String> annotations = new ArrayList<String>(httpMethodNames.size() + 1);
        annotations.add("javax.ws.rs.Path");
        annotations.addAll(httpMethodNames);
        return JavaElementsSearcher.searchForAnnotatedMethods(annotations, searchScope, progressMonitor);
    }

    private static Set<IMethod> searchForAnnotatedMethods(List<String> annotationNames, IJavaSearchScope searchScope, IProgressMonitor progressMonitor) throws CoreException {
        JavaMemberSearchResultCollector collector = new JavaMemberSearchResultCollector(9, searchScope);
        SearchPattern pattern = null;
        for (String annotationName : annotationNames) {
            SearchPattern subPattern = SearchPattern.createPattern((String)annotationName, (int)8, (int)65536, (int)8);
            pattern = pattern == null ? subPattern : SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)subPattern);
        }
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)collector, progressMonitor);
        return collector.getResult();
    }

    private static Set<IField> searchForAnnotatedFields(List<String> annotationNames, IJavaSearchScope searchScope, IProgressMonitor progressMonitor) throws CoreException {
        JavaMemberSearchResultCollector collector = new JavaMemberSearchResultCollector(8, searchScope);
        SearchPattern pattern = null;
        for (String annotationName : annotationNames) {
            SearchPattern subPattern = SearchPattern.createPattern((String)annotationName, (int)8, (int)65536, (int)8);
            pattern = pattern == null ? subPattern : SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)subPattern);
        }
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)collector, progressMonitor);
        return collector.getResult();
    }

    public static Set<IType> findRelatedTypes(IType sourceType, List<IType> otherTypes, IProgressMonitor progressMonitor) throws CoreException {
        if (sourceType == null || otherTypes == null || otherTypes.isEmpty()) {
            return Collections.emptySet();
        }
        IJavaSearchScope firstSearchScope = JavaElementsSearcher.createSearchScope(otherTypes);
        JavaMemberSearchResultCollector firstCollector = new JavaMemberSearchResultCollector(7, firstSearchScope);
        SearchPattern firstPattern = SearchPattern.createPattern((IJavaElement)sourceType, (int)3, (int)8);
        new SearchEngine().search(firstPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, firstSearchScope, (SearchRequestor)firstCollector, progressMonitor);
        HashSet<IType> globalResult = new HashSet<IType>();
        Set firstSearchResult = firstCollector.getResult();
        globalResult.addAll(firstSearchResult);
        IJavaSearchScope secondSearchScope = JavaElementsSearcher.createSearchScope((IJavaElement)sourceType);
        for (IType otherType : otherTypes) {
            if (otherType.equals(sourceType)) continue;
            SearchPattern otherPattern = SearchPattern.createPattern((IJavaElement)otherType, (int)3, (int)8);
            JavaMemberSearchResultCollector otherCollector = new JavaMemberSearchResultCollector(7, secondSearchScope);
            new SearchEngine().search(otherPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, secondSearchScope, (SearchRequestor)otherCollector, progressMonitor);
            if (!otherCollector.hasResult()) continue;
            globalResult.add(otherType);
        }
        globalResult.remove(sourceType);
        return globalResult;
    }
}

