/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JavaMethodParameter;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregator;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorField;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorProperty;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceField;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceProperty;
import org.jboss.tools.ws.jaxrs.core.internal.utils.CollectionUtils;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.AnnotationUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.jdt.FlagsUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementCategory;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IAnnotatedSourceType;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJavaMethodParameter;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJavaMethodSignature;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsHttpMethod;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsResourceMethod
extends JaxrsJavaElement<IMethod>
implements IJaxrsResourceMethod {
    private SourceType returnedJavaType = null;
    private final List<IJavaMethodParameter> javaMethodParameters = new ArrayList<IJavaMethodParameter>();
    private final JaxrsResource parentResource;

    public static Builder from(IMethod method, Set<String> httpMethodNames) throws JavaModelException {
        CompilationUnit ast = JdtUtils.parse((IJavaElement)method, (IProgressMonitor)new NullProgressMonitor());
        return new Builder(method, ast, httpMethodNames);
    }

    public static Builder from(IMethod method, CompilationUnit ast, Set<String> httpMethodNames) {
        return new Builder(method, ast, httpMethodNames);
    }

    private JaxrsResourceMethod(Builder builder) {
        this(builder.javaMethod, builder.annotations, builder.metamodel, builder.parentResource, builder.returnedJavaType, builder.javaMethodParameters, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JaxrsResourceMethod createWorkingCopy() {
        JaxrsResourceMethod jaxrsResourceMethod = this;
        synchronized (jaxrsResourceMethod) {
            JaxrsResource parentWorkingCopy = this.getParentResource().getWorkingCopy();
            return parentWorkingCopy.getMethods().get(((IMethod)this.javaElement).getHandleIdentifier());
        }
    }

    protected JaxrsResourceMethod createWorkingCopy(JaxrsResource parentWorkingCopy) {
        ArrayList<IJavaMethodParameter> methodParametersWorkingCopies = new ArrayList<IJavaMethodParameter>();
        for (IJavaMethodParameter methodParameter : this.javaMethodParameters) {
            JavaMethodParameter workingCopy = ((JavaMethodParameter)methodParameter).createWorkingCopy();
            methodParametersWorkingCopies.add(workingCopy);
        }
        return new JaxrsResourceMethod((IMethod)this.getJavaElement(), AnnotationUtils.createWorkingCopies(this.getAnnotations()), this.getMetamodel(), parentWorkingCopy, this.getReturnedType(), methodParametersWorkingCopies, this);
    }

    @Override
    public JaxrsResourceMethod getWorkingCopy() {
        return (JaxrsResourceMethod)super.getWorkingCopy();
    }

    private JaxrsResourceMethod(IMethod javaMethod, Map<String, Annotation> annotations, JaxrsMetamodel metamodel, JaxrsResource parentResource, SourceType returnedJavaType, List<IJavaMethodParameter> javaMethodParameters, JaxrsResourceMethod primaryCopy) {
        super(javaMethod, annotations, metamodel, primaryCopy);
        this.parentResource = parentResource;
        if (this.parentResource != null) {
            this.parentResource.addMethod(this);
        }
        this.returnedJavaType = returnedJavaType;
        if (javaMethodParameters != null) {
            this.javaMethodParameters.addAll(javaMethodParameters);
        }
    }

    @Override
    public JaxrsResource getParentResource() {
        return this.parentResource;
    }

    @Override
    public void update(IJavaElement javaElement, CompilationUnit ast) throws CoreException {
        if (javaElement == null || !((IMethod)this.getJavaElement()).exists()) {
            this.remove(FlagsUtils.computeElementFlags(this));
        } else {
            switch (javaElement.getElementType()) {
                case 5: {
                    IType primaryType = ((ICompilationUnit)javaElement).findPrimaryType();
                    if (primaryType == null) break;
                    IMethod method = primaryType.getMethod(((IMethod)this.getJavaElement()).getElementName(), ((IMethod)this.getJavaElement()).getParameterNames());
                    this.update((IJavaElement)method, ast);
                    break;
                }
                case 9: {
                    this.update(JaxrsResourceMethod.from((IMethod)javaElement, ast, this.getMetamodel().findAllHttpMethodNames()).buildTransient());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(JaxrsResourceMethod transientMethod) throws CoreException {
        JaxrsResourceMethod jaxrsResourceMethod = this;
        synchronized (jaxrsResourceMethod) {
            if (transientMethod == null) {
                this.remove(FlagsUtils.computeElementFlags(this));
            } else {
                Flags updateFlags = this.internalUpdate(transientMethod);
                if (this.isMarkedForRemoval()) {
                    this.remove(updateFlags);
                } else if (this.hasMetamodel()) {
                    JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, updateFlags);
                    this.getMetamodel().update(delta);
                }
            }
        }
    }

    @Override
    public void remove(Flags flags) throws CoreException {
        this.getParentResource().removeMethod(this);
        super.remove(flags);
    }

    Flags internalUpdate(JaxrsResourceMethod transientMethod) throws CoreException {
        Flags flags = new Flags();
        flags.addFlags(this.updateAnnotations(transientMethod.getAnnotations()));
        flags.addFlags(this.updateMethodParameters(transientMethod.getJavaMethodParameters()));
        flags.addFlags(this.updateReturnedType(transientMethod.getReturnedType()));
        return flags;
    }

    private Flags updateReturnedType(SourceType returnedType) {
        if (this.returnedJavaType != null && returnedType == null || this.returnedJavaType == null && returnedType != null || this.returnedJavaType != null && returnedType != null && !this.returnedJavaType.equals(returnedType)) {
            this.returnedJavaType = returnedType;
            return new Flags(65536);
        }
        return Flags.NONE;
    }

    private Flags updateMethodParameters(List<IJavaMethodParameter> otherMethodParameters) {
        CollectionUtils.CollectionComparison<IJavaMethodParameter> comparison = CollectionUtils.compare(this.javaMethodParameters, otherMethodParameters);
        boolean changed = this.hasChanges(otherMethodParameters, comparison);
        this.javaMethodParameters.clear();
        this.javaMethodParameters.addAll(otherMethodParameters);
        if (changed) {
            return new Flags(32768);
        }
        return Flags.NONE;
    }

    private boolean hasChanges(List<IJavaMethodParameter> otherMethodParameters, CollectionUtils.CollectionComparison<IJavaMethodParameter> comparison) {
        if (!comparison.getAddedItems().isEmpty()) {
            return true;
        }
        if (!comparison.getRemovedItems().isEmpty()) {
            return true;
        }
        for (IJavaMethodParameter item : comparison.getItemsInCommon()) {
            IJavaMethodParameter thisMethodParameter = this.javaMethodParameters.get(this.javaMethodParameters.indexOf(item));
            IJavaMethodParameter otherMethodParameter = otherMethodParameters.get(otherMethodParameters.indexOf(item));
            if (thisMethodParameter == null || !((JavaMethodParameter)thisMethodParameter).hasChanges(otherMethodParameter)) continue;
            return true;
        }
        return false;
    }

    public SourceType getReturnedType() {
        return this.returnedJavaType;
    }

    public void setReturnedType(SourceType returnedType) {
        this.returnedJavaType = returnedType;
    }

    @Override
    boolean isMarkedForRemoval() {
        boolean hasPathAnnotation = this.hasAnnotation("javax.ws.rs.Path");
        boolean hasHttpMethodAnnotation = this.getHttpMethodAnnotation() != null;
        return !hasPathAnnotation && !hasHttpMethodAnnotation;
    }

    @Override
    public final EnumElementKind getElementKind() {
        Annotation pathAnnotation = this.getPathAnnotation();
        Annotation httpMethodAnnotation = this.getHttpMethodAnnotation();
        if (pathAnnotation == null && httpMethodAnnotation != null) {
            return EnumElementKind.RESOURCE_METHOD;
        }
        if (pathAnnotation != null && httpMethodAnnotation != null) {
            return EnumElementKind.SUBRESOURCE_METHOD;
        }
        if (pathAnnotation != null && httpMethodAnnotation == null) {
            return EnumElementKind.SUBRESOURCE_LOCATOR;
        }
        return EnumElementKind.UNDEFINED_RESOURCE_METHOD;
    }

    public Annotation getPathAnnotation() {
        return this.getAnnotation("javax.ws.rs.Path");
    }

    @Override
    public boolean hasPathTemplate() {
        Annotation pathAnnotation = this.getPathAnnotation();
        return pathAnnotation != null && pathAnnotation.getValue() != null;
    }

    @Override
    public String getPathTemplate() {
        Annotation pathAnnotation = this.getPathAnnotation();
        if (pathAnnotation == null) {
            return null;
        }
        return pathAnnotation.getValue();
    }

    public Annotation getHttpMethodAnnotation() {
        if (this.hasMetamodel()) {
            for (IJaxrsHttpMethod httpMethod : this.getMetamodel().findAllHttpMethods()) {
                Annotation annotation = this.getAnnotation(httpMethod.getJavaClassName());
                if (annotation == null) continue;
                return annotation;
            }
        }
        return null;
    }

    @Override
    public String getHttpMethodClassName() {
        Annotation httpMethodAnnotation = this.getHttpMethodAnnotation();
        if (httpMethodAnnotation == null) {
            return null;
        }
        return httpMethodAnnotation.getFullyQualifiedName();
    }

    public Annotation getConsumesAnnotation() {
        return this.getAnnotation("javax.ws.rs.Consumes");
    }

    @Override
    public List<String> getConsumedMediaTypes() {
        Annotation consumesAnnotation = this.getConsumesAnnotation();
        if (consumesAnnotation != null) {
            return consumesAnnotation.getValues("value");
        }
        return Collections.emptyList();
    }

    public Annotation getProducesAnnotation() {
        return this.getAnnotation("javax.ws.rs.Produces");
    }

    @Override
    public List<String> getProducedMediaTypes() {
        Annotation producesAnnotation = this.getProducesAnnotation();
        if (producesAnnotation != null) {
            return producesAnnotation.getValues("value");
        }
        return Collections.emptyList();
    }

    @Override
    public List<IJavaMethodParameter> getJavaMethodParameters() {
        return Collections.unmodifiableList(this.javaMethodParameters);
    }

    public IJavaMethodParameter getJavaMethodParameterByName(String parameterName) {
        for (IJavaMethodParameter javaMethodParameter : this.javaMethodParameters) {
            if (!javaMethodParameter.getName().equals(parameterName)) continue;
            return javaMethodParameter;
        }
        return null;
    }

    public List<IJavaMethodParameter> getJavaMethodParametersAnnotatedWith(String annotationName) {
        ArrayList<IJavaMethodParameter> matchingParameters = new ArrayList<IJavaMethodParameter>();
        for (IJavaMethodParameter parameter : this.javaMethodParameters) {
            if (parameter.getAnnotation(annotationName) == null) continue;
            matchingParameters.add(parameter);
        }
        return matchingParameters;
    }

    public IJavaMethodParameter getJavaMethodParameterAnnotatedWith(String annotationName, String annotationValue) {
        for (IJavaMethodParameter parameter : this.javaMethodParameters) {
            Annotation annotation = parameter.getAnnotation(annotationName);
            if (annotation == null || !annotationValue.equals(annotation.getValue())) continue;
            return parameter;
        }
        return null;
    }

    public void removeJavaMethodParameter(String parameterName) {
        Iterator<IJavaMethodParameter> iterator = this.javaMethodParameters.iterator();
        while (iterator.hasNext()) {
            IJavaMethodParameter javaMethodParameter = iterator.next();
            if (!javaMethodParameter.getName().equals(parameterName)) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    public Map<String, Annotation> getPathTemplateParameters() {
        HashMap<String, Annotation> proposals = new HashMap<String, Annotation>();
        proposals.putAll(AnnotationUtils.extractTemplateParameters(this.getPathAnnotation()));
        return proposals;
    }

    public List<IAnnotatedSourceType> getRelatedTypesAnnotatedWith(String annotationName) {
        ArrayList<IAnnotatedSourceType> annotatedSourceTypes = new ArrayList<IAnnotatedSourceType>();
        annotatedSourceTypes.addAll(this.getParentResource().getFieldsAnnotatedWith(annotationName));
        annotatedSourceTypes.addAll(this.getParentResource().getPropertiesAnnotatedWith(annotationName));
        annotatedSourceTypes.addAll(this.getJavaMethodParametersAnnotatedWith(annotationName));
        ArrayList<IAnnotatedSourceType> beanParameters = new ArrayList<IAnnotatedSourceType>();
        beanParameters.addAll(this.getParentResource().getFieldsAnnotatedWith("javax.ws.rs.BeanParam"));
        beanParameters.addAll(this.getParentResource().getPropertiesAnnotatedWith("javax.ws.rs.BeanParam"));
        beanParameters.addAll(this.getJavaMethodParametersAnnotatedWith("javax.ws.rs.BeanParam"));
        for (IAnnotatedSourceType beanParameter : beanParameters) {
            JaxrsParameterAggregator parameterAggregator;
            SourceType parameterAggregatorType = beanParameter.getType();
            if (parameterAggregatorType == null || (parameterAggregator = (JaxrsParameterAggregator)this.getMetamodel().findElement(parameterAggregatorType.getErasureName(), EnumElementCategory.PARAMETER_AGGREGATOR)) == null) continue;
            annotatedSourceTypes.addAll(parameterAggregator.getFieldsAnnotatedWith(annotationName));
            annotatedSourceTypes.addAll(parameterAggregator.getPropertiesAnnotatedWith(annotationName));
        }
        return annotatedSourceTypes;
    }

    public IAnnotatedSourceType getRelatedTypeAnnotatedWith(String annotationName, String annotationValue) {
        IJavaMethodParameter methodParameter = this.getJavaMethodParameterAnnotatedWith(annotationName, annotationValue);
        if (methodParameter != null) {
            return methodParameter;
        }
        JaxrsResourceField resourceField = this.getParentResource().getFieldAnnotatedWith(annotationName, annotationValue);
        if (resourceField != null) {
            return resourceField;
        }
        JaxrsResourceProperty resourceProperty = this.getParentResource().getPropertyAnnotatedWith(annotationName, annotationValue);
        if (resourceProperty != null) {
            return resourceProperty;
        }
        ArrayList<IAnnotatedSourceType> beanParameters = new ArrayList<IAnnotatedSourceType>();
        beanParameters.addAll(this.getParentResource().getFieldsAnnotatedWith("javax.ws.rs.BeanParam"));
        beanParameters.addAll(this.getParentResource().getPropertiesAnnotatedWith("javax.ws.rs.BeanParam"));
        beanParameters.addAll(this.getJavaMethodParametersAnnotatedWith("javax.ws.rs.BeanParam"));
        for (IAnnotatedSourceType beanParameter : beanParameters) {
            JaxrsParameterAggregator parameterAggregator;
            SourceType parameterAggregatorType = beanParameter.getType();
            if (parameterAggregatorType == null || (parameterAggregator = (JaxrsParameterAggregator)this.getMetamodel().findElement(parameterAggregatorType.getErasureName(), EnumElementCategory.PARAMETER_AGGREGATOR)) == null) continue;
            JaxrsParameterAggregatorField aggregatorField = parameterAggregator.getFieldAnnotatedWith(annotationName, annotationValue);
            if (aggregatorField != null) {
                return aggregatorField;
            }
            JaxrsParameterAggregatorProperty aggregatorProperty = parameterAggregator.getPropertyAnnotatedWith(annotationName, annotationValue);
            if (aggregatorProperty == null) continue;
            return aggregatorProperty;
        }
        return null;
    }

    /* synthetic */ JaxrsResourceMethod(Builder builder, JaxrsResourceMethod jaxrsResourceMethod) {
        this(builder);
    }

    public static class Builder {
        private final IMethod javaMethod;
        private final CompilationUnit ast;
        private final Set<String> httpMethodNames;
        private JaxrsResource parentResource;
        private JaxrsMetamodel metamodel;
        private Map<String, Annotation> annotations;
        private IJavaMethodSignature methodSignature;
        private SourceType returnedJavaType = null;
        private List<IJavaMethodParameter> javaMethodParameters = new ArrayList<IJavaMethodParameter>();

        public Builder(IMethod javaMethod, CompilationUnit ast, Set<String> httpMethodNames) {
            this.javaMethod = javaMethod;
            this.ast = ast;
            this.httpMethodNames = httpMethodNames;
        }

        public Builder withJavaMethodSignature(IJavaMethodSignature javaMethodSignature) {
            this.methodSignature = javaMethodSignature;
            return this;
        }

        public Builder withAnnotations(Map<String, Annotation> annotations) {
            this.annotations = annotations;
            return this;
        }

        public JaxrsResourceMethod buildTransient() throws CoreException {
            return this.buildInResource(null);
        }

        public JaxrsResourceMethod buildInResource(JaxrsResource parentResource) throws CoreException {
            long start;
            block12: {
                block11: {
                    block10: {
                        start = System.currentTimeMillis();
                        if (this.javaMethod != null && this.javaMethod.exists() && this.javaMethod.isStructureKnown()) break block10;
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                        return null;
                    }
                    try {
                        JdtUtils.makeConsistentIfNecessary((IMember)this.javaMethod);
                        this.parentResource = parentResource;
                        if (parentResource != null) {
                            this.metamodel = parentResource.getMetamodel();
                        }
                        if (this.annotations == null) {
                            this.annotations = JdtUtils.resolveAllAnnotations((IMember)this.javaMethod, this.ast);
                        }
                        Annotation httpMethodAnnotation = null;
                        Annotation pathAnnotation = this.annotations.get("javax.ws.rs.Path");
                        for (String httpMethodAnnotationName : this.httpMethodNames) {
                            if (!this.annotations.containsKey(httpMethodAnnotationName)) continue;
                            httpMethodAnnotation = this.annotations.get(httpMethodAnnotationName);
                            break;
                        }
                        if (httpMethodAnnotation != null || pathAnnotation != null) break block11;
                        Logger.debug("Cannot create ResourceMethod: no Path annotation nor HttpMethod found on method {}.{}()", this.javaMethod.getParent().getElementName(), this.javaMethod.getElementName());
                    }
                    catch (Throwable throwable) {
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                        throw throwable;
                    }
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                    return null;
                }
                if (this.methodSignature == null) {
                    this.methodSignature = JdtUtils.resolveMethodSignature(this.javaMethod, this.ast);
                }
                if (this.methodSignature != null) break block12;
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
                return null;
            }
            this.javaMethodParameters = this.methodSignature.getMethodParameters();
            this.returnedJavaType = this.methodSignature.getReturnedType();
            JaxrsResourceMethod resourceMethod = new JaxrsResourceMethod(this, null);
            if (parentResource != null) {
                resourceMethod.joinMetamodel();
            }
            JaxrsResourceMethod jaxrsResourceMethod = resourceMethod;
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS Resource Method in {}ms", end - start);
            return jaxrsResourceMethod;
        }
    }
}

