/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.configuration;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.ws.jaxrs.core.configuration.ProjectBuilderUtils;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsMetamodelLocator;

public class ProjectBuilderConfigurer
implements IProjectNature {
    private IProject project = null;

    public final void configure() throws CoreException {
        if (this.project == null) {
            return;
        }
        if (ProjectBuilderUtils.installProjectBuilder(this.project, "org.jboss.tools.ws.jaxrs.metamodelBuilder")) {
            Logger.debug("JAX-RS Builder is now installed.");
        } else {
            Logger.debug("JAX-RS Builder was already installed.");
        }
    }

    public final void deconfigure() throws CoreException {
        if (this.project == null) {
            return;
        }
        if (ProjectBuilderUtils.uninstallProjectBuilder(this.project, "org.jboss.tools.ws.jaxrs.metamodelBuilder")) {
            Logger.debug("JAX-RS Metamodel Builder is now uninstalled.");
        } else {
            Logger.debug("JAX-RS Metamodel Builder was not installed.");
        }
        JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get(this.project);
        if (metamodel != null) {
            Logger.info("Removing JAX-RS Metamodel from project '" + this.project.getName() + "'");
            metamodel.remove();
        }
    }

    public final IProject getProject() {
        return this.project;
    }

    public final void setProject(IProject p) {
        this.project = p;
    }
}

