/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IMenuService;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonUIActivator;

public class UIUtils {
    private static final String OPENSHIFT_EXPLORER_VIEW_ID = "org.jboss.tools.openshift.express.ui.explorer.expressConsoleView";

    public static void showOpenShiftExplorerView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(UIUtils.OPENSHIFT_EXPLORER_VIEW_ID);
                }
                catch (PartInitException e) {
                    OpenShiftCommonUIActivator.getDefault().getLogger().logError("Failed to show the OpenShift Explorer view", (Throwable)e);
                }
            }
        });
    }

    public static void selectAllOnFocus(final Text text) {
        FocusAdapter onFocus = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                text.selectAll();
            }
        };
        text.addFocusListener((FocusListener)onFocus);
        text.addDisposeListener(new DisposeListener((FocusListener)onFocus){
            private final /* synthetic */ FocusListener val$onFocus;
            {
                this.val$onFocus = focusListener;
            }

            public void widgetDisposed(DisposeEvent e) {
                text.removeFocusListener(this.val$onFocus);
            }
        });
    }

    public static void focusOnSelection(final Button button, final Text text) {
        final Listener onSelect = new Listener(){

            public void handleEvent(Event event) {
                if (!button.getSelection()) {
                    text.selectAll();
                    text.setFocus();
                }
            }
        };
        button.addListener(13, onSelect);
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                button.removeListener(13, onSelect);
            }
        });
    }

    public static void registerContributionManager(String id, final IContributionManager contributionManager, Control control) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)contributionManager);
        Assert.isTrue((control != null && !control.isDisposed() ? 1 : 0) != 0);
        final IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)contributionManager, id);
        contributionManager.update(true);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                menuService.releaseContributions((ContributionManager)contributionManager);
            }
        });
    }

    public static IMenuManager createContextMenu(Control control) {
        Assert.isTrue((control != null && !control.isDisposed() ? 1 : 0) != 0);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new GroupMarker("additions"));
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
        return menuManager;
    }

    public static void doForAllChildren(IWidgetVisitor visitor, Composite composite) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                UIUtils.doForAllChildren(visitor, (Composite)control);
            }
            visitor.visit(control);
            ++n2;
        }
    }

    public static void enableAllChildren(final boolean enabled, Composite composite) {
        UIUtils.doForAllChildren(new IWidgetVisitor(){

            @Override
            public void visit(Control control) {
                control.setEnabled(enabled);
            }
        }, composite);
    }

    public static Shell getShell() {
        Shell shell = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            shell = window.getShell();
        }
        return shell;
    }

    public static boolean isFirstElementOfType(Class<?> clazz, ISelection selection) {
        return UIUtils.getFirstElement(selection, clazz) != null;
    }

    public static <E> E getFirstElement(ISelection selection, Class<E> clazz) {
        Object firstSelectedElement = UIUtils.getFirstElement(selection);
        if (firstSelectedElement == null) {
            return null;
        }
        return UIUtils.adapt(firstSelectedElement, clazz);
    }

    public static <E> E adapt(Object object, Class<E> clazz) {
        if (clazz.isAssignableFrom(object.getClass())) {
            return (E)object;
        }
        if (IAdaptable.class.isAssignableFrom(object.getClass())) {
            return (E)((IAdaptable)object).getAdapter(clazz);
        }
        return (E)Platform.getAdapterManager().getAdapter(object, clazz);
    }

    public static <E> E[] getElements(ISelection selection, Class<E> clazz) {
        Object[] selectedElements = UIUtils.getElements(selection);
        ArrayList<Object> elements = new ArrayList<Object>();
        int index = 0;
        while (index < selectedElements.length) {
            Object adapted;
            if (clazz.isAssignableFrom(selectedElements[index].getClass())) {
                elements.add(selectedElements[index]);
            } else if (IAdaptable.class.isAssignableFrom(selectedElements[index].getClass())) {
                adapted = ((IAdaptable)selectedElements[index]).getAdapter(clazz);
                if (adapted != null) {
                    elements.add(adapted);
                }
            } else {
                adapted = Platform.getAdapterManager().getAdapter(selectedElements[index], clazz);
                if (adapted != null) {
                    elements.add(adapted);
                }
            }
            ++index;
        }
        return elements.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static Object getFirstElement(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        return ((IStructuredSelection)selection).getFirstElement();
    }

    public static Object[] getElements(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return new Object[0];
        }
        return ((IStructuredSelection)selection).toArray();
    }

    public static boolean areNumOfElementsSelected(int numOf, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        return ((IStructuredSelection)selection).size() == numOf;
    }

    public static boolean isSingleSelection(ISelection selection) {
        return UIUtils.areNumOfElementsSelected(1, selection);
    }

    public static void copyBackground(Control source, Control destination) {
        destination.setBackground(source.getBackground());
    }

    public static void copyMenuOf(Control source, Control target) {
        Menu menu = source.getMenu();
        if (menu != null) {
            target.setMenu(menu);
        }
    }

    public static void ensureDisplayExec(Runnable runnable) {
        Display display = Display.getCurrent();
        if (display == null) {
            Display.getDefault().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public static Text createSearchText(Composite parent) {
        final Text searchText = new Text(parent, 896);
        searchText.setMessage("type filter text");
        searchText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    searchText.setText("");
                }
            }
        });
        return searchText;
    }

    public static void setVisibleAndExclude(boolean visible, Control control) {
        Assert.isLegal((control != null && !control.isDisposed() ? 1 : 0) != 0);
        Assert.isLegal((boolean)(control.getLayoutData() instanceof GridData));
        control.setVisible(visible);
        ((GridData)control.getLayoutData()).exclude = !visible;
        control.getParent().layout();
    }

    public static <T> ISelection createSelection(T selectedObject) {
        StructuredSelection selection = new StructuredSelection();
        if (selectedObject != null) {
            selection = new StructuredSelection(selectedObject);
        }
        return selection;
    }

    public static interface IWidgetVisitor {
        public void visit(Control var1);
    }
}

