/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableViewerCellDecorationManager {
    private Image image;
    private Table table;
    private Map<ViewerCell, TableEditor> decorationByCell = new HashMap<ViewerCell, TableEditor>();

    public TableViewerCellDecorationManager(Image image, Table table) {
        this.image = image;
        this.table = table;
    }

    public void toggle(boolean show, ViewerCell cell) {
        if (show) {
            this.show(cell);
        } else {
            this.hide(cell);
        }
    }

    public void show(ViewerCell cell) {
        TableEditor editor = this.decorationByCell.get(cell);
        if (editor == null) {
            Control decoration = this.createDecoration(this.image, this.table);
            editor = this.createTableEditor(this.image, this.table);
            this.decorationByCell.put(cell, editor);
            editor.setEditor(decoration, (TableItem)cell.getItem(), cell.getColumnIndex());
        }
    }

    public void hide(ViewerCell cell) {
        TableEditor editor = this.decorationByCell.get(cell);
        if (editor != null) {
            this.hide(editor);
            this.decorationByCell.remove(cell);
        }
    }

    private void hide(TableEditor editor) {
        Control decoration = editor.getEditor();
        if (decoration != null) {
            decoration.setVisible(false);
            decoration.dispose();
        }
        editor.setEditor(null);
        editor.dispose();
    }

    public void hideAll() {
        for (TableEditor decoration : this.decorationByCell.values()) {
            this.hide(decoration);
        }
        this.decorationByCell.clear();
    }

    private Control createDecoration(Image image, Table table) {
        Label validationDecoration = new Label((Composite)table, 0);
        validationDecoration.setImage(image);
        return validationDecoration;
    }

    private TableEditor createTableEditor(Image image, Table table) {
        TableEditor tableEditor = new TableEditor(table);
        tableEditor.grabHorizontal = false;
        tableEditor.grabVertical = false;
        Rectangle bounds = image.getBounds();
        tableEditor.minimumHeight = bounds.height;
        tableEditor.minimumWidth = bounds.width;
        tableEditor.verticalAlignment = 1;
        tableEditor.horizontalAlignment = 16384;
        return tableEditor;
    }
}

