/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;

public class StyledTextUtils {
    private static Pattern LINK_REGEX = Pattern.compile("([^<]*)(<a>)?([^<]*)(<\\/a>)?(.*)");

    private StyledTextUtils() {
    }

    public static StyledText emulateLinkWidget(String text, StyledText styledText) {
        StyledTextUtils.setLinkText(text, styledText);
        StyledTextUtils.setTransparent(styledText);
        styledText.setEditable(false);
        styledText.setCursor(new Cursor((Device)styledText.getShell().getDisplay(), 21));
        return styledText;
    }

    public static void setLinkText(String text, StyledText styledText) {
        Matcher matcher = LINK_REGEX.matcher(text);
        if (!matcher.matches()) {
            styledText.setText(text);
            return;
        }
        if (StringUtils.isEmpty((String)matcher.group(2)) && StringUtils.isEmpty((String)matcher.group(4))) {
            styledText.setText(text);
        } else {
            styledText.setText(StyledTextUtils.removeLinkMarkers(matcher));
            int start = matcher.group(1).length();
            int stop = start + matcher.group(3).length();
            StyleRange linkStyle = StyledTextUtils.createLinkStyle(start, stop, styledText.getShell());
            styledText.setStyleRange(linkStyle);
        }
    }

    private static String removeLinkMarkers(Matcher matcher) {
        StringBuffer buffer = new StringBuffer();
        matcher.appendReplacement(buffer, "$1$3$5");
        return buffer.toString();
    }

    public static StyleRange createLinkStyle(int start, int stop, Shell shell) {
        Assert.isLegal((shell != null && !shell.isDisposed() ? 1 : 0) != 0);
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = stop - start;
        styleRange.fontStyle = 4;
        styleRange.underline = true;
        styleRange.foreground = shell.getDisplay().getSystemColor(36);
        return styleRange;
    }

    public static void setTransparent(StyledText styledText) {
        if ("cocoa".equals(Platform.getWS())) {
            styledText.setBackgroundImage(OpenShiftCommonImages.TRANSPARENT_PIXEL_IMG);
        } else {
            styledText.setBackground(styledText.getDisplay().getSystemColor(22));
        }
    }

    public static StyleRange createBoldStyle(String string, Color background) {
        StyleRange styleRange = new StyleRange();
        styleRange.fontStyle = 1;
        if (background != null) {
            styleRange.background = background;
        }
        styleRange.start = 0;
        styleRange.length = string.length();
        return styleRange;
    }
}

