/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.runtime.IStatus;

public class DataBindingUtils {
    public static void dispose(IObservable observable) {
        if (observable != null) {
            observable.dispose();
        }
    }

    public static void addValidationStatusProviders(Collection<ValidationStatusProvider> providers, DataBindingContext dbc) {
        for (ValidationStatusProvider provider : new ArrayList<ValidationStatusProvider>(providers)) {
            dbc.addValidationStatusProvider(provider);
        }
    }

    public static void removeValidationStatusProviders(Collection<ValidationStatusProvider> providers, DataBindingContext dbc) {
        for (ValidationStatusProvider provider : new ArrayList<ValidationStatusProvider>(providers)) {
            dbc.removeValidationStatusProvider(provider);
        }
    }

    public static void validateTargetsToModels(DataBindingContext dbc) {
        for (Binding binding : dbc.getBindings()) {
            binding.validateTargetToModel();
        }
    }

    public static void dispose(List<ValidationStatusProvider> providers) {
        for (ValidationStatusProvider provider : providers) {
            DataBindingUtils.dispose(provider);
        }
    }

    public static boolean isDisposed(ValidationStatusProvider provider) {
        return provider == null || provider.isDisposed();
    }

    public static void dispose(ValidationStatusProvider provider) {
        if (DataBindingUtils.isDisposed(provider)) {
            return;
        }
        provider.dispose();
    }

    public static void dispose(DataBindingContext dbc) {
        if (dbc != null) {
            dbc.dispose();
        }
    }

    public static boolean isValid(DataBindingContext dbc) {
        if (dbc == null) {
            return false;
        }
        for (Object element : dbc.getValidationStatusProviders()) {
            ValidationStatusProvider validationProvider = (ValidationStatusProvider)element;
            IStatus validationStatus = (IStatus)validationProvider.getValidationStatus().getValue();
            if (DataBindingUtils.isDisposed(validationProvider) || validationStatus.isOK()) continue;
            return false;
        }
        return true;
    }
}

