/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.databinding;

import java.util.regex.Pattern;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.jboss.tools.openshift.common.core.utils.StringUtils;

public class HostNameValidator
implements IValidator {
    private static final Pattern urlPattern = Pattern.compile("(https?://){0,1}[^\\.:0-9]+(\\.[^\\.:0-9]+)*(:[0-9]+){0,1}");

    public IStatus validate(Object value) {
        String server = (String)value;
        if (StringUtils.isEmpty((String)server)) {
            return ValidationStatus.cancel((String)"You have to provide a server to connect to.");
        }
        if (!urlPattern.matcher(server).matches()) {
            return ValidationStatus.error((String)"You have to provide a valid server to connect to.");
        }
        return ValidationStatus.ok();
    }
}

