/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.console;

import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.jboss.ide.eclipse.as.ui.UIUtil;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonUIActivator;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;

public class ConsoleUtils {
    public static final String CONSOLE_TYPE_KEY = "ConsoleType";
    public static final String CONSOLE_TYPE_VALUE = "OpenShiftTailConsole";

    public static void registerConsoleListener(IConsoleListener consoleListener) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = plugin.getConsoleManager();
        consoleManager.addConsoleListener(consoleListener);
    }

    public static void deregisterConsoleListener(IConsoleListener consoleListener) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = plugin.getConsoleManager();
        consoleManager.removeConsoleListener(consoleListener);
    }

    public static MessageConsole findMessageConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = plugin.getConsoleManager();
        IConsole[] existing = consoleManager.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole console = new MessageConsole(name, null);
        console.setAttribute(CONSOLE_TYPE_KEY, (Object)CONSOLE_TYPE_VALUE);
        consoleManager.addConsoles(new IConsole[]{console});
        return console;
    }

    public static void displayConsoleView(final IConsole console) {
        UIUtils.ensureDisplayExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPart part = null;
                try {
                    part = UIUtil.bringViewToFront((String)"org.eclipse.ui.console.ConsoleView");
                    if (part == null) {
                        OpenShiftCommonUIActivator.getDefault().getLogger().logWarning("Could not open console, org.eclipse.ui.console.ConsoleView was not found");
                        return;
                    }
                    IConsoleView view = (IConsoleView)part.getAdapter(IConsoleView.class);
                    if (view == null) {
                        return;
                    }
                    view.display(console);
                }
                catch (PartInitException e) {
                    OpenShiftCommonUIActivator.getDefault().getLogger().logWarning("Could not open console view", (Throwable)e);
                }
            }
        });
    }
}

