/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui.connection;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.JobUtils;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.InvertingBooleanConverter;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionFactory;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.egit.ui.util.EGitUIUtils;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonUIActivator;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionColumLabelProvider;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionEditorsStackedView;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPageModel;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNullValidator;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.databinding.TrimTrailingSlashConverter;
import org.jboss.tools.openshift.internal.common.ui.utils.StyledTextUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.IConnectionAware;

public class ConnectionWizardPage
extends AbstractOpenShiftWizardPage {
    private final ConnectionWizardPageModel pageModel;
    private ConnectionEditorsStackedView connectionEditors;
    private StyledText userdocLink;
    private StyledText signupLink;

    public ConnectionWizardPage(IWizard wizard, IConnectionAware<IConnection> wizardModel) {
        this(wizard, wizardModel, true);
    }

    public ConnectionWizardPage(IWizard wizard, IConnectionAware<IConnection> wizardModel, Class<? extends IConnection> connectionType) {
        this(wizard, wizardModel, connectionType, true);
    }

    protected ConnectionWizardPage(IWizard wizard, IConnectionAware<IConnection> wizardModel, boolean allowConnectionChange) {
        this(wizard, wizardModel, null, allowConnectionChange);
    }

    protected ConnectionWizardPage(IWizard wizard, IConnectionAware<IConnection> wizardModel, Class<? extends IConnection> connectionType, boolean allowConnectionChange) {
        super("Sign in to OpenShift", "Please sign in to your OpenShift server.", "Server Connection", wizard);
        this.pageModel = new ConnectionWizardPageModel(wizardModel.getConnection(), ConnectionsRegistrySingleton.getInstance().getAll(), connectionType, allowConnectionChange, wizardModel);
        EGitUIUtils.ensureEgitUIIsStarted();
    }

    @Override
    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).applyTo(parent);
        this.signupLink = new StyledText(parent, 64);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(3, 1).applyTo((Control)this.signupLink);
        this.showHideSignupLink();
        this.signupLink.addListener(3, this.onSignupLinkClicked());
        IObservableValue signupUrlObservable = BeanProperties.value((String)"signupUrl").observe((Object)this.pageModel);
        signupUrlObservable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ConnectionWizardPage.this.showHideSignupLink();
            }
        });
        this.userdocLink = new StyledText(parent, 64);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(3, 1).applyTo((Control)this.userdocLink);
        this.showHideUserdocLink();
        IObservableValue userdocUrlObservable = BeanProperties.value((String)"userdocUrl").observe((Object)this.pageModel);
        this.userdocLink.addSelectionListener((SelectionListener)this.onUserdocLinkClicked(userdocUrlObservable));
        userdocUrlObservable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ConnectionWizardPage.this.showHideUserdocLink();
            }
        });
        IObservableValue connectionFactoryObservable = BeanProperties.value((String)"connectionFactory").observe((Object)this.pageModel);
        Label fillerLabel = new Label(parent, 0);
        GridDataFactory.fillDefaults().span(3, 3).hint(-1, 6).applyTo((Control)fillerLabel);
        Label connectionLabel = new Label(parent, 0);
        connectionLabel.setText("Connection:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)connectionLabel);
        Combo connectionCombo = new Combo(parent, -1);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)connectionCombo);
        ComboViewer connectionComboViewer = new ComboViewer(connectionCombo);
        connectionComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        connectionComboViewer.setLabelProvider((IBaseLabelProvider)new ConnectionColumLabelProvider());
        connectionComboViewer.setInput(this.pageModel.getAllConnections());
        Binding selectedConnectionBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)connectionComboViewer)).validatingAfterGet((IValidator)new IsNotNullValidator(ValidationStatus.cancel((String)"You have to select or create a new connection.")))).to(BeanProperties.value((String)"selectedConnection", IConnection.class).observe((Object)this.pageModel)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)selectedConnectionBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Label connectionFactoryLabel = new Label(parent, 0);
        connectionFactoryLabel.setText("Server type:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)connectionFactoryLabel);
        Combo connectionFactoryCombo = new Combo(parent, -1);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)connectionFactoryCombo);
        ComboViewer connectionFactoriesViewer = new ComboViewer(connectionFactoryCombo);
        connectionFactoriesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        connectionFactoriesViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof IConnectionFactory)) {
                    return element.toString();
                }
                return ((IConnectionFactory)element).getName();
            }
        });
        connectionFactoriesViewer.setInput(this.pageModel.getAllConnectionFactories());
        IViewerObservableValue selectedServerType = ViewerProperties.singleSelection().observe((Viewer)connectionFactoriesViewer);
        ValueBindingBuilder.bind((IObservableValue)selectedServerType).to(connectionFactoryObservable).in(dbc);
        Button useDefaultServerCheckbox = new Button(parent, 32);
        useDefaultServerCheckbox.setText("Use default server");
        GridDataFactory.fillDefaults().span(3, 1).align(4, 4).applyTo((Control)useDefaultServerCheckbox);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)useDefaultServerCheckbox)).to(BeanProperties.value((String)"useDefaultHost", IConnection.class).observe((Object)this.pageModel)).in(dbc);
        Label serverLabel = new Label(parent, 0);
        serverLabel.setText("Server:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)serverLabel);
        Combo serversCombo = new Combo(parent, 2048);
        ComboViewer serversViewer = new ComboViewer(serversCombo);
        serversViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        serversViewer.setInput((Object)BeanProperties.list((String)"allHosts").observe((Object)this.pageModel));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)serversCombo);
        ISWTObservableValue serverUrlObservable = WidgetProperties.text().observe((Widget)serversCombo);
        serversCombo.addFocusListener((FocusListener)this.onServerFocusLost((IObservableValue)serverUrlObservable));
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)serverUrlObservable).converting((IConverter)new TrimTrailingSlashConverter())).to(BeanProperties.value((String)"host").observe((Object)this.pageModel)).in(dbc);
        MultiValidator serverUrlValidator = new MultiValidator((IObservableValue)serverUrlObservable){
            private final /* synthetic */ IObservableValue val$serverUrlObservable;
            {
                this.val$serverUrlObservable = iObservableValue;
            }

            protected IStatus validate() {
                Object value = this.val$serverUrlObservable.getValue();
                if (!(value instanceof String) || org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)((String)value))) {
                    return ValidationStatus.cancel((String)"Please provide an OpenShift server url.");
                }
                if (!UrlUtils.isValid((String)((String)value))) {
                    return ValidationStatus.error((String)"Please provide a valid OpenShift server url.");
                }
                return ValidationStatus.ok();
            }
        };
        ControlDecorationSupport.create((ValidationStatusProvider)serverUrlValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        dbc.addValidationStatusProvider((ValidationStatusProvider)serverUrlValidator);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)serversCombo)).notUpdatingParticipant()).to(BeanProperties.value((String)"useDefaultHost").observe((Object)this.pageModel)).converting((IConverter)new InvertingBooleanConverter())).in(dbc);
        dbc.addValidationStatusProvider((ValidationStatusProvider)new MultiValidator(){

            protected IStatus validate() {
                return (IStatus)BeanProperties.value((String)"connectedStatus", IStatus.class).observe((Object)ConnectionWizardPage.this.pageModel).getValue();
            }
        });
        Group authenticationDetailsGroup = new Group(parent, 0);
        authenticationDetailsGroup.setText("Authentication");
        GridDataFactory.fillDefaults().align(4, 4).span(3, 1).applyTo((Control)authenticationDetailsGroup);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo((Composite)authenticationDetailsGroup);
        Composite authenticationDetailsContainer = new Composite((Composite)authenticationDetailsGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)authenticationDetailsContainer);
        this.connectionEditors = new ConnectionEditorsStackedView(connectionFactoryObservable, this, authenticationDetailsContainer, dbc);
        this.connectionEditors.createControls();
    }

    private void showHideSignupLink() {
        boolean userdocExists = !org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)this.pageModel.getSignupUrl());
        IConnectionFactory factory = this.pageModel.getConnectionFactory();
        if (factory != null) {
            StyledTextUtils.emulateLinkWidget(NLS.bind((String)"If you do not have an account on {0}, please <a>sign up here</a>.", (Object)factory.getName()), this.signupLink);
        }
        UIUtils.setVisibleAndExclude(userdocExists, (Control)this.signupLink);
    }

    private void showHideUserdocLink() {
        IConnectionFactory factory;
        boolean signupUrlExists;
        boolean bl = signupUrlExists = !org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)this.pageModel.getUserdocUrl());
        if (signupUrlExists && (factory = this.pageModel.getConnectionFactory()) != null) {
            StyledTextUtils.emulateLinkWidget(NLS.bind((String)"New to OpenShift {0}? Explore the <a>getting started documentation</a>.", (Object)factory.getName()), this.userdocLink);
        }
        UIUtils.setVisibleAndExclude(signupUrlExists, (Control)this.userdocLink);
    }

    private FocusAdapter onServerFocusLost(final IObservableValue serverUrlObservable) {
        return new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String value = (String)serverUrlObservable.getValue();
                if (org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)value)) {
                    return;
                }
                String url = value;
                if (!url.startsWith("http://") && !url.contains(":")) {
                    url = UrlUtils.ensureStartsWithScheme((String)value, (String)"https://");
                }
                if (!url.endsWith("://")) {
                    url = org.jboss.tools.openshift.common.core.utils.StringUtils.removeTrailingSlashes((String)url);
                }
                if (!(url = StringUtils.removeEnd((String)url, (String)"/console")).equals(value)) {
                    serverUrlObservable.setValue((Object)url);
                }
            }
        };
    }

    protected Listener onSignupLinkClicked() {
        return new Listener(){

            public void handleEvent(Event event) {
                String signupUrl = ConnectionWizardPage.this.pageModel.getSignupUrl();
                if (org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)signupUrl)) {
                    return;
                }
                new BrowserUtility().checkedCreateInternalBrowser(signupUrl, signupUrl, "org.jboss.tools.openshift.ui", OpenShiftCommonUIActivator.getDefault().getLog());
                WizardUtils.close((IWizard)ConnectionWizardPage.this.getWizard());
            }
        };
    }

    protected SelectionAdapter onUserdocLinkClicked(final IObservableValue userdocUrlObservable) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String userdocUrl = (String)userdocUrlObservable.getValue();
                if (org.jboss.tools.openshift.common.core.utils.StringUtils.isEmpty((String)userdocUrl)) {
                    return;
                }
                new BrowserUtility().checkedCreateExternalBrowser(userdocUrl, "org.jboss.tools.openshift.ui", OpenShiftCommonUIActivator.getDefault().getLog());
            }
        };
    }

    @Override
    protected void onPageActivated(DataBindingContext dbc) {
        super.onPageActivated(dbc);
    }

    @Override
    protected void onPageDeactivated(DataBindingContext dbc) {
        this.pageModel.saveRecentConnection();
    }

    @Override
    protected void onPageWillGetDeactivated(AbstractOpenShiftWizardPage.Direction direction, PageChangingEvent event, DataBindingContext dbc) {
        if (direction == AbstractOpenShiftWizardPage.Direction.BACKWARDS) {
            return;
        }
        if (!this.isConnected()) {
            event.doit = this.connect();
        }
        boolean cfr_ignored_0 = event.doit;
    }

    public boolean isConnected() {
        return this.getModel().isConnected();
    }

    public boolean connect() {
        try {
            ConnectJob connectJob = new ConnectJob();
            WizardUtils.runInWizard((Job)connectJob, (DelegatingProgressMonitor)new DelegatingProgressMonitor(), (IWizardContainer)this.getContainer(), (DataBindingContext)this.getDatabindingContext());
            boolean connected = JobUtils.isOk((IStatus)connectJob.getConnectionStatus());
            if (connected) {
                return this.pageModel.saveConnection();
            }
            return false;
        }
        catch (InterruptedException e) {
            OpenShiftCommonUIActivator.log(NLS.bind((String)"Failed to authenticate user on server at {1}", (Object)this.pageModel.getHost()), e);
            return false;
        }
        catch (InvocationTargetException e) {
            OpenShiftCommonUIActivator.log(NLS.bind((String)"Failed to authenticate user on server at {1}", (Object)this.pageModel.getHost()), e);
            return false;
        }
    }

    public IConnection getConnection() {
        return this.pageModel.getConnection();
    }

    @Override
    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)12, (WizardPage)this, (DataBindingContext)dbc);
    }

    public void dispose() {
        this.pageModel.dispose();
    }

    public ConnectionWizardPageModel getModel() {
        return this.pageModel;
    }

    private class ConnectJob
    extends AbstractDelegatingMonitorJob {
        private IStatus connectionStatus;

        private ConnectJob() {
            super("Verifying user credentials...");
        }

        protected IStatus doRun(IProgressMonitor monitor) {
            this.connectionStatus = ConnectionWizardPage.this.pageModel.connect();
            monitor.done();
            return Status.OK_STATUS;
        }

        public IStatus getConnectionStatus() {
            return this.connectionStatus;
        }
    }
}

