/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class SelectProjectDialog
extends ElementListSelectionDialog {
    public SelectProjectDialog(Shell shell) {
        super(shell, (ILabelProvider)new ProjectLabelProvider());
        this.setTitle("Select Existing Project");
        this.setMessage("Select an existing project.");
        this.setMultipleSelection(false);
        this.setAllowDuplicates(false);
        this.setElements(this.getProjects());
    }

    protected Object[] getProjects() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.isValid(project)) {
                projects.add(project);
            }
            ++n2;
        }
        return projects.toArray();
    }

    protected boolean isValid(IProject project) {
        return true;
    }

    public IProject getSelectedProject() {
        Object[] results = this.getResult();
        if (results == null || results.length < 1) {
            return null;
        }
        return (IProject)results[0];
    }

    private static class ProjectLabelProvider
    extends LabelProvider {
        private ProjectLabelProvider() {
        }

        public Image getImage(Object element) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }

        public String getText(Object element) {
            if (!(element instanceof IProject)) {
                return null;
            }
            return ((IProject)element).getName();
        }
    }
}

