/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.server.core.internal.RuntimeClasspathContainerInitializer;
import org.jboss.ide.eclipse.as.classpath.core.ClasspathCorePlugin;
import org.jboss.ide.eclipse.as.classpath.core.runtime.internal.ProjectRuntimeClasspathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.modules.manifest.ModuleSlotManifestUtil;

public class ManifestChangeListener
implements IResourceChangeListener {
    private static ManifestChangeListener listener;

    public static void register() {
        try {
            listener = new ManifestChangeListener();
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            ws.addResourceChangeListener((IResourceChangeListener)listener, 9);
        }
        catch (Exception e) {
            ClasspathCorePlugin.log("Unable to add manifest change listener", e);
        }
    }

    public static void deregister() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.removeResourceChangeListener((IResourceChangeListener)listener);
    }

    protected String getFileName() {
        return "manifest.mf";
    }

    protected void ensureInCache(IFile f) {
        new ModuleSlotManifestUtil().ensureInCache(f);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        final ArrayList changedManifests = new ArrayList();
        final ArrayList changedProjects = new ArrayList();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    String name = delta.getResource().getName();
                    if (name.toLowerCase().equals(ManifestChangeListener.this.getFileName())) {
                        if (delta.getResource() instanceof IFile) {
                            changedManifests.add((IFile)delta.getResource());
                        }
                        if (!changedProjects.contains(delta.getResource().getProject())) {
                            changedProjects.add(delta.getResource().getProject());
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {}
        IFile[] asArr = changedManifests.toArray(new IFile[changedManifests.size()]);
        int i = 0;
        while (i < asArr.length) {
            this.ensureInCache(asArr[i]);
            ++i;
        }
        IProject[] asArr2 = changedProjects.toArray(new IProject[changedProjects.size()]);
        int i2 = 0;
        while (i2 < asArr2.length) {
            this.resetContainer(asArr2[i2]);
            ++i2;
        }
    }

    private void resetContainer(IProject p) {
        if (ManifestChangeListener.isJavaProject(p.getProject())) {
            IJavaProject jp = JavaCore.create((IProject)p.getProject());
            try {
                IClasspathEntry[] raw = jp.getRawClasspath();
                int i = 0;
                while (i < raw.length) {
                    if (ProjectRuntimeClasspathProvider.CONTAINER_PATH.isPrefixOf(raw[i].getPath())) {
                        try {
                            new RuntimeClasspathContainerInitializer().initialize(raw[i].getPath(), jp);
                        }
                        catch (CoreException coreException) {}
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private static boolean isJavaProject(IProject pj) {
        try {
            return pj.getNature("org.eclipse.jdt.core.javanature") != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

