/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.internal;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.wst.server.core.IRuntimeType;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.RuntimeJarUtility;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.InternalRuntimeClasspathModel;
import org.jboss.ide.eclipse.as.classpath.core.runtime.jbossmodules.internal.JBossModulesDefaultClasspathModel;
import org.jboss.ide.eclipse.as.classpath.core.runtime.path.internal.RuntimePathProviderFileset;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.IJBossRuntimeResourceConstants;
import org.jboss.ide.eclipse.as.core.util.IJBossToolingConstants;

public class DefaultClasspathModelLoader
implements IJBossToolingConstants,
IJBossRuntimeResourceConstants {
    private static final String SEP = "/";
    private static final String EMPTY = "";
    private static final String CONFIG_DIR = RuntimeJarUtility.CONFIG_DIR_VAR_PATTERN;

    public InternalRuntimeClasspathModel getDefaultRuntimeClasspathModel(IRuntimeType type) {
        IRuntimePathProvider[] providers = null;
        String rtID = type.getId();
        if ("org.jboss.ide.eclipse.as.runtime.32".equals(rtID)) {
            providers = this.getDefaultAS3Entries();
        }
        if ("org.jboss.ide.eclipse.as.runtime.40".equals(rtID)) {
            providers = this.getDefaultAS40Entries();
        }
        if ("org.jboss.ide.eclipse.as.runtime.42".equals(rtID)) {
            providers = this.getDefaultAS40Entries();
        }
        if ("org.jboss.ide.eclipse.as.runtime.50".equals(rtID)) {
            providers = this.getDefaultAS50Entries();
        }
        if ("org.jboss.ide.eclipse.as.runtime.eap.43".equals(rtID)) {
            providers = this.getDefaultEAP43Entries();
        }
        if ("org.jboss.ide.eclipse.as.runtime.51".equals(rtID)) {
            providers = this.getDefaultAS50Entries();
        }
        if ("org.jboss.ide.eclipse.as.runtime.60".equals(rtID)) {
            providers = this.getDefaultAS60Entries();
        }
        if ("org.jboss.ide.eclipse.as.runtime.eap.50".equals(rtID)) {
            providers = this.getDefaultAS50Entries();
        }
        if (providers != null) {
            InternalRuntimeClasspathModel model = new InternalRuntimeClasspathModel();
            model.addProviders(providers);
            return model;
        }
        if (this.jbossModulesStyle(type)) {
            return new JBossModulesDefaultClasspathModel(type);
        }
        return new InternalRuntimeClasspathModel();
    }

    private boolean jbossModulesStyle(IRuntimeType rtt) {
        ServerExtendedProperties props = new ExtendedServerPropertiesAdapterFactory().getExtendedProperties((Object)rtt);
        return props != null && props.getFileStructure() == 2;
    }

    private IRuntimePathProvider[] getDefaultAS3Entries() {
        ArrayList<RuntimePathProviderFileset> sets = new ArrayList<RuntimePathProviderFileset>();
        sets.add(new RuntimePathProviderFileset("lib"));
        sets.add(new RuntimePathProviderFileset(String.valueOf(CONFIG_DIR) + SEP + "lib"));
        sets.add(new RuntimePathProviderFileset("client"));
        return sets.toArray(new RuntimePathProviderFileset[sets.size()]);
    }

    private IRuntimePathProvider[] getDefaultAS40Entries() {
        ArrayList<RuntimePathProviderFileset> sets = new ArrayList<RuntimePathProviderFileset>();
        String deployPath = String.valueOf(CONFIG_DIR) + SEP + "deploy";
        sets.add(new RuntimePathProviderFileset("lib"));
        sets.add(new RuntimePathProviderFileset(String.valueOf(CONFIG_DIR) + SEP + "lib"));
        sets.add(new RuntimePathProviderFileset(String.valueOf(deployPath) + SEP + "jboss-web.deployer" + SEP + "jsf-libs"));
        sets.add(new RuntimePathProviderFileset(String.valueOf(deployPath) + SEP + "jboss-aop-jdk50.deployer"));
        sets.add(new RuntimePathProviderFileset(String.valueOf(deployPath) + SEP + "ejb3.deployer"));
        sets.add(new RuntimePathProviderFileset("client"));
        return sets.toArray(new RuntimePathProviderFileset[sets.size()]);
    }

    private IRuntimePathProvider[] getDefaultEAP43Entries() {
        return this.getDefaultAS40Entries();
    }

    private IRuntimePathProvider[] getDefaultAS50Entries() {
        ArrayList<RuntimePathProviderFileset> sets = new ArrayList<RuntimePathProviderFileset>();
        String deployerPath = String.valueOf(CONFIG_DIR) + SEP + "deployers";
        String deployPath = String.valueOf(CONFIG_DIR) + SEP + "deploy";
        sets.add(new RuntimePathProviderFileset("common/lib"));
        sets.add(new RuntimePathProviderFileset("lib"));
        sets.add(new RuntimePathProviderFileset(String.valueOf(CONFIG_DIR) + SEP + "lib"));
        sets.add(new RuntimePathProviderFileset(String.valueOf(deployPath) + SEP + "jbossweb.sar" + SEP + "jsf-libs"));
        sets.add(new RuntimePathProviderFileset(EMPTY, String.valueOf(deployPath) + SEP + "jbossweb.sar", "jboss-web-service.jar", EMPTY));
        sets.add(new RuntimePathProviderFileset(EMPTY, String.valueOf(deployPath) + SEP + "jbossweb.sar", "jstl.jar", EMPTY));
        sets.add(new RuntimePathProviderFileset(String.valueOf(deployerPath) + SEP + "jboss-aop-jboss5.deployer"));
        sets.add(new RuntimePathProviderFileset(String.valueOf(deployerPath) + SEP + "ejb3.deployer"));
        sets.add(new RuntimePathProviderFileset(EMPTY, String.valueOf(deployerPath) + SEP + "webbeans.deployer", "jsr299-api.jar", EMPTY));
        sets.add(new RuntimePathProviderFileset("client"));
        return sets.toArray(new RuntimePathProviderFileset[sets.size()]);
    }

    private IRuntimePathProvider[] getDefaultAS60Entries() {
        ArrayList<IRuntimePathProvider> sets = new ArrayList<IRuntimePathProvider>();
        sets.addAll(Arrays.asList(this.getDefaultAS50Entries()));
        sets.add(new RuntimePathProviderFileset(String.valueOf(CONFIG_DIR) + SEP + "deployers" + SEP + "resteasy.deployer"));
        sets.add(new RuntimePathProviderFileset(String.valueOf(CONFIG_DIR) + SEP + "deployers" + SEP + "jsf.deployer" + SEP + "Mojarra-2.0" + SEP + "jsf-libs"));
        return sets.toArray(new RuntimePathProviderFileset[sets.size()]);
    }
}

