/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.internal.InvalidRuntimeDetector;
import org.jboss.tools.runtime.core.internal.RuntimeCorePreferences;
import org.jboss.tools.runtime.core.internal.RuntimeDetector;
import org.jboss.tools.runtime.core.model.DownloadRuntime;
import org.jboss.tools.runtime.core.model.IDownloadRuntimesProvider;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.jboss.tools.runtime.core.model.IRuntimeDetectorDelegate;
import org.jboss.tools.runtime.core.model.IRuntimeInstaller;

public class RuntimeExtensionManager {
    private static final String RUNTIME_DETECTOR_EXTENSION_ID = "org.jboss.tools.runtime.core.runtimeDetectors";
    public static final String DOWNLOAD_RUNTIMES_PROVIDER_EXTENSION_ID = "org.jboss.tools.runtime.core.downloadRuntimeProvider";
    private static final String RUNTIME_INSTALLER_EXTENSION_ID = "org.jboss.tools.runtime.core.runtimeInstaller";
    private IDownloadRuntimesProvider[] downloadRuntimeProviders = null;
    private Set<IRuntimeDetector> runtimeDetectors;
    private static final String NAME = "name";
    private static final String CLAZZ = "class";
    private static final String PREFERENCE_ID = "preferenceId";
    private static final String ID = "id";
    private static final String ENABLED = "enabled";
    private static final String PRIORITY = "priority";
    private static RuntimeExtensionManager manager = null;
    private Map<String, DownloadRuntime> cachedDownloadRuntimes = null;
    private ArrayList<RuntimeInstallerWrapper> installers;

    public static RuntimeExtensionManager getDefault() {
        if (manager == null) {
            manager = new RuntimeExtensionManager();
        }
        return manager;
    }

    protected Set<IRuntimeDetector> loadInitializedRuntimeDetectors() {
        Set<IRuntimeDetector> tmp = this.loadDeclaredRuntimeDetectors();
        this.initializeRuntimeDetectorEnablement(tmp);
        return tmp;
    }

    public synchronized Set<IRuntimeDetector> getRuntimeDetectors() {
        if (this.runtimeDetectors == null) {
            this.runtimeDetectors = RuntimeExtensionManager.getDefault().loadInitializedRuntimeDetectors();
        }
        return this.runtimeDetectors;
    }

    public IRuntimeDetector findRuntimeDetector(String id) {
        for (IRuntimeDetector detector : this.getRuntimeDetectors()) {
            if (!id.equals(detector.getId())) continue;
            return detector;
        }
        return null;
    }

    private void initializeRuntimeDetectorEnablement(Set<IRuntimeDetector> set) {
        String[] enabledDetectors = RuntimeCorePreferences.getDefault().getEnabledRuntimeDetectors();
        String[] disabledDetectors = RuntimeCorePreferences.getDefault().getDisabledRuntimeDetectors();
        boolean allEnabled = false;
        if (enabledDetectors == null) {
            allEnabled = true;
        }
        enabledDetectors = enabledDetectors == null ? new String[]{} : enabledDetectors;
        disabledDetectors = disabledDetectors == null ? new String[]{} : disabledDetectors;
        List<String> enabled = Arrays.asList(enabledDetectors);
        List<String> disabled = Arrays.asList(disabledDetectors);
        for (IRuntimeDetector detector : set) {
            if (allEnabled || enabled.contains(detector.getId())) {
                ((RuntimeDetector)detector).setEnabled(true);
                continue;
            }
            if (!disabled.contains(detector.getId())) continue;
            ((RuntimeDetector)detector).setEnabled(false);
        }
    }

    public Set<IRuntimeDetector> loadDeclaredRuntimeDetectors() {
        TreeSet<IRuntimeDetector> declared = new TreeSet<IRuntimeDetector>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(RUNTIME_DETECTOR_EXTENSION_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                IRuntimeDetector dec = this.loadOneDeclaredRuntimeDetector(configurationElements[j]);
                if (!declared.contains(dec)) {
                    declared.add(dec);
                }
                ++j;
            }
            ++i;
        }
        return declared;
    }

    private IRuntimeDetector loadOneDeclaredRuntimeDetector(IConfigurationElement configurationElement) {
        int priority;
        String name = configurationElement.getAttribute(NAME);
        String preferenceId = configurationElement.getAttribute(PREFERENCE_ID);
        String id = configurationElement.getAttribute(ID);
        String priorityString = configurationElement.getAttribute(PRIORITY);
        String enabled = configurationElement.getAttribute(ENABLED);
        try {
            priority = Integer.parseInt(priorityString);
        }
        catch (Exception exception) {
            priority = Integer.MAX_VALUE;
        }
        IRuntimeDetectorDelegate delegate = null;
        try {
            delegate = (IRuntimeDetectorDelegate)configurationElement.createExecutableExtension(CLAZZ);
            RuntimeDetector detector = new RuntimeDetector(name, id, preferenceId, priority, delegate);
            detector.setEnabled(Boolean.parseBoolean(enabled));
            return detector;
        }
        catch (CoreException e) {
            RuntimeCoreActivator.pluginLog().logError((Throwable)e);
            return new InvalidRuntimeDetector(name, id, preferenceId, priority);
        }
    }

    public Map<String, DownloadRuntime> getDownloadRuntimes() {
        return this.getDownloadRuntimes((IProgressMonitor)new NullProgressMonitor());
    }

    public Map<String, DownloadRuntime> getDownloadRuntimes(IProgressMonitor monitor) {
        if (this.cachedDownloadRuntimes == null) {
            Map<String, DownloadRuntime> tmp = this.loadDownloadRuntimes(monitor);
            if (monitor.isCanceled()) {
                return tmp;
            }
            this.cachedDownloadRuntimes = tmp;
        }
        return this.cachedDownloadRuntimes;
    }

    public DownloadRuntime findDownloadRuntime(String id) {
        this.getDownloadRuntimes();
        return this.findDownloadRuntime(id, (IProgressMonitor)new NullProgressMonitor());
    }

    public DownloadRuntime findDownloadRuntime(String id, IProgressMonitor monitor) {
        Map<String, DownloadRuntime> runtimes = this.getDownloadRuntimes(monitor);
        return this.findDownloadRuntime(id, runtimes);
    }

    private DownloadRuntime findDownloadRuntime(String id, Map<String, DownloadRuntime> runtimes) {
        if (id == null) {
            return null;
        }
        DownloadRuntime rt = runtimes.get(id);
        if (rt != null) {
            return rt;
        }
        Collection<DownloadRuntime> rts = runtimes.values();
        for (DownloadRuntime i1 : rts) {
            Object propVal = i1.getProperty("PROPERTY_ALTERNATE_ID");
            if (propVal == null) continue;
            if (propVal instanceof String[]) {
                String[] propVal2 = (String[])propVal;
                int it = 0;
                while (it < propVal2.length) {
                    if (id.equals(propVal2[it])) {
                        return i1;
                    }
                    ++it;
                }
                continue;
            }
            if (!(propVal instanceof String) || !id.equals(propVal)) continue;
            return i1;
        }
        return null;
    }

    private Map<String, DownloadRuntime> loadDownloadRuntimes(IProgressMonitor monitor) {
        HashMap<String, DownloadRuntime> tmp = new HashMap<String, DownloadRuntime>();
        monitor.beginTask("Loading Downloadable Runtimes", 300);
        this.loadDownloadableRuntimesFromProviders(tmp, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
        return tmp;
    }

    public void loadDownloadableRuntimesFromProviders(Map<String, DownloadRuntime> map, IProgressMonitor monitor) {
        IDownloadRuntimesProvider[] providers = this.getDownloadRuntimeProviders();
        monitor.beginTask("Loading Download Runtime Providers", providers.length * 100);
        int i = 0;
        while (i < providers.length && !monitor.isCanceled()) {
            SubProgressMonitor inner = new SubProgressMonitor(monitor, 100);
            DownloadRuntime[] runtimes = providers[i].getDownloadableRuntimes(null, (IProgressMonitor)inner);
            if (runtimes != null) {
                int j = 0;
                while (j < runtimes.length) {
                    if (runtimes[j] != null) {
                        map.put(runtimes[j].getId(), runtimes[j]);
                    }
                    ++j;
                }
            }
            inner.done();
            ++i;
        }
    }

    private IDownloadRuntimesProvider[] getDownloadRuntimeProviders() {
        if (this.downloadRuntimeProviders == null) {
            this.downloadRuntimeProviders = this.loadDownloadRuntimeProviders();
        }
        return this.downloadRuntimeProviders;
    }

    private IDownloadRuntimesProvider[] loadDownloadRuntimeProviders() {
        ArrayList<IDownloadRuntimesProvider> list = new ArrayList<IDownloadRuntimesProvider>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(DOWNLOAD_RUNTIMES_PROVIDER_EXTENSION_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                IConfigurationElement configurationElement = configurationElements[j];
                try {
                    IDownloadRuntimesProvider provider = (IDownloadRuntimesProvider)configurationElement.createExecutableExtension(CLAZZ);
                    list.add(provider);
                }
                catch (CoreException ce) {
                    RuntimeCoreActivator.pluginLog().logError("Error loading download runtime provider", (Throwable)ce);
                }
                ++j;
            }
            ++i;
        }
        return list.toArray(new IDownloadRuntimesProvider[list.size()]);
    }

    private ArrayList<RuntimeInstallerWrapper> loadInstallers() {
        ArrayList<RuntimeInstallerWrapper> list = new ArrayList<RuntimeInstallerWrapper>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(RUNTIME_INSTALLER_EXTENSION_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                IConfigurationElement configurationElement = configurationElements[j];
                try {
                    IRuntimeInstaller installer = (IRuntimeInstaller)configurationElement.createExecutableExtension(CLAZZ);
                    String id = configurationElement.getAttribute(ID);
                    list.add(new RuntimeInstallerWrapper(id, installer));
                }
                catch (CoreException ce) {
                    RuntimeCoreActivator.pluginLog().logError("Error loading runtime installer", (Throwable)ce);
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public IRuntimeInstaller getRuntimeInstaller(String id) {
        if (this.installers == null) {
            this.installers = this.loadInstallers();
        }
        for (RuntimeInstallerWrapper w : this.installers) {
            if (!id.equals(w.getId())) continue;
            return w.getInstaller();
        }
        return null;
    }

    private static class RuntimeInstallerWrapper {
        private String id;
        private IRuntimeInstaller installer;

        public RuntimeInstallerWrapper(String id, IRuntimeInstaller installer) {
            this.id = id;
            this.installer = installer;
        }

        public String getId() {
            return this.id;
        }

        public IRuntimeInstaller getInstaller() {
            return this.installer;
        }
    }
}

