/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceModel;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceUniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.BaseTableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceBaseTableAnnotation
extends SourceAnnotation
implements BaseTableAnnotation {
    DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    AnnotationElementAdapter<String> nameAdapter;
    String name;
    TextRange nameTextRange;
    TextRange nameValidationTextRange;
    DeclarationAnnotationElementAdapter<String> schemaDeclarationAdapter;
    AnnotationElementAdapter<String> schemaAdapter;
    String schema;
    TextRange schemaTextRange;
    TextRange schemaValidationTextRange;
    DeclarationAnnotationElementAdapter<String> catalogDeclarationAdapter;
    AnnotationElementAdapter<String> catalogAdapter;
    String catalog;
    TextRange catalogTextRange;
    TextRange catalogValidationTextRange;
    final UniqueConstraintsAnnotationContainer uniqueConstraintsContainer = new UniqueConstraintsAnnotationContainer();

    protected SourceBaseTableAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        this(parent, element, daa, (AnnotationAdapter)new ElementAnnotationAdapter(element, daa));
    }

    protected SourceBaseTableAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameDeclarationAdapter();
        this.nameAdapter = this.buildNameAdapter();
        this.schemaDeclarationAdapter = this.buildSchemaDeclarationAdapter();
        this.schemaAdapter = this.buildSchemaAdapter();
        this.catalogDeclarationAdapter = this.buildCatalogDeclarationAdapter();
        this.catalogAdapter = this.buildCatalogAdapter();
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.name = this.buildName(astAnnotation);
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.nameValidationTextRange = this.buildNameValidationTextRange(astAnnotation);
        this.schema = this.buildSchema(astAnnotation);
        this.schemaTextRange = this.buildSchemaTextRange(astAnnotation);
        this.schemaValidationTextRange = this.buildSchemaValidationTextRange(astAnnotation);
        this.catalog = this.buildCatalog(astAnnotation);
        this.catalogTextRange = this.buildCatalogTextRange(astAnnotation);
        this.catalogValidationTextRange = this.buildCatalogValidationTextRange(astAnnotation);
        this.uniqueConstraintsContainer.initializeFromContainerAnnotation(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncName(this.buildName(astAnnotation));
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.nameValidationTextRange = this.buildNameValidationTextRange(astAnnotation);
        this.syncSchema(this.buildSchema(astAnnotation));
        this.schemaTextRange = this.buildSchemaTextRange(astAnnotation);
        this.schemaValidationTextRange = this.buildSchemaValidationTextRange(astAnnotation);
        this.syncCatalog(this.buildCatalog(astAnnotation));
        this.catalogTextRange = this.buildCatalogTextRange(astAnnotation);
        this.catalogValidationTextRange = this.buildCatalogValidationTextRange(astAnnotation);
        this.uniqueConstraintsContainer.synchronize(astAnnotation);
    }

    protected abstract String getUniqueConstraintsElementName();

    @Override
    public boolean isSpecified() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (ObjectTools.notEquals((Object)this.name, (Object)name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(Annotation astAnnotation) {
        return (String)this.nameAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.nameTextRange;
    }

    @Override
    public TextRange getNameValidationTextRange() {
        return this.nameValidationTextRange;
    }

    private TextRange buildNameTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(this.nameDeclarationAdapter, astAnnotation);
    }

    private TextRange buildNameValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astAnnotation);
    }

    @Override
    public boolean nameTouches(int pos) {
        return this.textRangeTouches(this.nameTextRange, pos);
    }

    @Override
    public boolean nameValidationTouches(int pos) {
        return this.textRangeTouches(this.nameValidationTextRange, pos);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter();

    private AnnotationElementAdapter<String> buildNameAdapter() {
        return this.buildAnnotationElementAdapter(this.nameDeclarationAdapter);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String schema) {
        if (ObjectTools.notEquals((Object)this.schema, (Object)schema)) {
            this.schema = schema;
            this.schemaAdapter.setValue((Object)schema);
        }
    }

    private void syncSchema(String astSchema) {
        String old = this.schema;
        this.schema = astSchema;
        this.firePropertyChanged("schema", old, astSchema);
    }

    private String buildSchema(Annotation astAnnotation) {
        return (String)this.schemaAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getSchemaTextRange() {
        return this.schemaTextRange;
    }

    @Override
    public TextRange getSchemaValidationTextRange() {
        return this.schemaValidationTextRange;
    }

    private TextRange buildSchemaTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(this.schemaDeclarationAdapter, astAnnotation);
    }

    private TextRange buildSchemaValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.schemaDeclarationAdapter, astAnnotation);
    }

    @Override
    public boolean schemaTouches(int pos) {
        return this.textRangeTouches(this.schemaTextRange, pos);
    }

    @Override
    public boolean schemaValidationTouches(int pos) {
        return this.textRangeTouches(this.schemaValidationTextRange, pos);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> buildSchemaDeclarationAdapter();

    private AnnotationElementAdapter<String> buildSchemaAdapter() {
        return this.buildAnnotationElementAdapter(this.schemaDeclarationAdapter);
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(String catalog) {
        if (ObjectTools.notEquals((Object)this.catalog, (Object)catalog)) {
            this.catalog = catalog;
            this.catalogAdapter.setValue((Object)catalog);
        }
    }

    private void syncCatalog(String astCatalog) {
        String old = this.catalog;
        this.catalog = astCatalog;
        this.firePropertyChanged("catalog", old, astCatalog);
    }

    private String buildCatalog(Annotation astAnnotation) {
        return (String)this.catalogAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getCatalogTextRange() {
        return this.catalogTextRange;
    }

    @Override
    public TextRange getCatalogValidationTextRange() {
        return this.catalogValidationTextRange;
    }

    private TextRange buildCatalogTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(this.catalogDeclarationAdapter, astAnnotation);
    }

    private TextRange buildCatalogValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.catalogDeclarationAdapter, astAnnotation);
    }

    @Override
    public boolean catalogTouches(int pos) {
        return this.textRangeTouches(this.catalogTextRange, pos);
    }

    @Override
    public boolean catalogValidationTouches(int pos) {
        return this.textRangeTouches(this.catalogValidationTextRange, pos);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> buildCatalogDeclarationAdapter();

    private AnnotationElementAdapter<String> buildCatalogAdapter() {
        return this.buildAnnotationElementAdapter(this.catalogDeclarationAdapter);
    }

    @Override
    public ListIterable<UniqueConstraintAnnotation> getUniqueConstraints() {
        return this.uniqueConstraintsContainer.getNestedAnnotations();
    }

    @Override
    public int getUniqueConstraintsSize() {
        return this.uniqueConstraintsContainer.getNestedAnnotationsSize();
    }

    @Override
    public UniqueConstraintAnnotation uniqueConstraintAt(int index) {
        return (UniqueConstraintAnnotation)this.uniqueConstraintsContainer.getNestedAnnotation(index);
    }

    @Override
    public UniqueConstraintAnnotation addUniqueConstraint(int index) {
        return (UniqueConstraintAnnotation)this.uniqueConstraintsContainer.addNestedAnnotation(index);
    }

    UniqueConstraintAnnotation buildUniqueConstraint(int index) {
        return new SourceUniqueConstraintAnnotation((JavaResourceModel)this, this.annotatedElement, this.buildUniqueConstraintIndexedDeclarationAnnotationAdapter(index));
    }

    private IndexedDeclarationAnnotationAdapter buildUniqueConstraintIndexedDeclarationAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(this.daa, this.getUniqueConstraintsElementName(), index, "javax.persistence.UniqueConstraint");
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        this.uniqueConstraintsContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeUniqueConstraint(int index) {
        this.uniqueConstraintsContainer.removeNestedAnnotation(index);
    }

    public boolean isUnset() {
        return super.isUnset() && this.name == null && this.schema == null && this.catalog == null && this.uniqueConstraintsContainer.isEmpty();
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UniqueConstraintsAnnotationContainer
    extends SourceModel.AnnotationContainer<UniqueConstraintAnnotation> {
        UniqueConstraintsAnnotationContainer() {
            super((SourceModel)SourceBaseTableAnnotation.this);
        }

        protected String getNestedAnnotationsListName() {
            return "uniqueConstraints";
        }

        protected String getElementName() {
            return SourceBaseTableAnnotation.this.getUniqueConstraintsElementName();
        }

        protected String getNestedAnnotationName() {
            return "javax.persistence.UniqueConstraint";
        }

        protected UniqueConstraintAnnotation buildNestedAnnotation(int index) {
            return SourceBaseTableAnnotation.this.buildUniqueConstraint(index);
        }
    }
}

