/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.platform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jpt.common.core.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.internal.utility.ExtensionPointTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SuperIterableWrapper;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.core.JptJpaCoreMessages;
import org.eclipse.jpt.jpa.core.internal.InternalJpaWorkspace;
import org.eclipse.jpt.jpa.core.internal.platform.InternalJpaPlatformConfig;
import org.eclipse.jpt.jpa.core.internal.platform.InternalJpaPlatformGroupConfig;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformManager;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalJpaPlatformManager
implements JpaPlatformManager {
    private final InternalJpaWorkspace jpaWorkspace;
    private final HashMap<String, InternalJpaPlatformGroupConfig> jpaPlatformGroupConfigs = new HashMap();
    private final HashMap<String, InternalJpaPlatformConfig> jpaPlatformConfigs = new HashMap();
    private static final String SIMPLE_EXTENSION_POINT_NAME = "jpaPlatforms";
    private static final String JPA_PLATFORM_GROUP_ELEMENT = "jpaPlatformGroup";
    private static final String JPA_PLATFORM_ELEMENT = "jpaPlatform";
    private static final String ID_ATTRIBUTE = "id";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String FACTORY_CLASS_ATTRIBUTE = "factoryClass";
    private static final String JPA_FACET_VERSION_ATTRIBUTE = "jpaFacetVersion";
    private static final String DEFAULT_ATTRIBUTE = "default";
    private static final String GROUP_ATTRIBUTE = "group";
    private static final String DEFAULT_JPA_PLATFORM_PREF_KEY_BASE = "defaultJpaPlatform_";

    public InternalJpaPlatformManager(InternalJpaWorkspace jpaWorkspace) {
        this.jpaWorkspace = jpaWorkspace;
        this.initialize();
    }

    private void initialize() {
        IExtensionPoint extensionPoint = this.getExtensionPoint();
        if (extensionPoint == null) {
            throw new IllegalStateException("missing extension point: " + this.getExtensionPointName());
        }
        ArrayList<IConfigurationElement> jpaPlatformGroupElements = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> jpaPlatformElements = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String elementName = element.getName();
                if (elementName.equals(JPA_PLATFORM_GROUP_ELEMENT)) {
                    jpaPlatformGroupElements.add(element);
                } else if (elementName.equals(JPA_PLATFORM_ELEMENT)) {
                    jpaPlatformElements.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        for (IConfigurationElement element : jpaPlatformGroupElements) {
            InternalJpaPlatformGroupConfig config = this.buildPlatformGroupConfig(element);
            if (config == null) continue;
            this.jpaPlatformGroupConfigs.put(config.getId(), config);
        }
        for (IConfigurationElement element : jpaPlatformElements) {
            InternalJpaPlatformConfig config = this.buildPlatformConfig(element);
            if (config == null) continue;
            this.jpaPlatformConfigs.put(config.getId(), config);
        }
    }

    private InternalJpaPlatformGroupConfig buildPlatformGroupConfig(IConfigurationElement element) {
        String contributor = element.getContributor().getName();
        String id = element.getAttribute(ID_ATTRIBUTE);
        if (id == null) {
            this.logMissingAttribute(element, ID_ATTRIBUTE);
            return null;
        }
        if (this.jpaPlatformGroupConfigs.containsKey(id)) {
            this.logError(JptCommonCoreMessages.REGISTRY_DUPLICATE, this.getExtensionPointName(), contributor, ID_ATTRIBUTE, id);
            return null;
        }
        String label = element.getAttribute(LABEL_ATTRIBUTE);
        if (label == null) {
            this.logMissingAttribute(element, LABEL_ATTRIBUTE);
            return null;
        }
        InternalJpaPlatformGroupConfig config = new InternalJpaPlatformGroupConfig(this, id, label);
        config.setPluginId(contributor);
        return config;
    }

    private InternalJpaPlatformConfig buildPlatformConfig(IConfigurationElement element) {
        String groupID;
        String defaultString;
        String contributor = element.getContributor().getName();
        String id = element.getAttribute(ID_ATTRIBUTE);
        if (id == null) {
            this.logMissingAttribute(element, ID_ATTRIBUTE);
            return null;
        }
        if (this.jpaPlatformConfigs.containsKey(id)) {
            this.logError(JptCommonCoreMessages.REGISTRY_DUPLICATE, this.getExtensionPointName(), contributor, ID_ATTRIBUTE, id);
            return null;
        }
        String label = element.getAttribute(LABEL_ATTRIBUTE);
        if (label == null) {
            this.logMissingAttribute(element, LABEL_ATTRIBUTE);
            return null;
        }
        String factoryClassName = element.getAttribute(FACTORY_CLASS_ATTRIBUTE);
        if (factoryClassName == null) {
            this.logMissingAttribute(element, FACTORY_CLASS_ATTRIBUTE);
            return null;
        }
        InternalJpaPlatformConfig config = new InternalJpaPlatformConfig(this, id, label, factoryClassName);
        String jpaFacetVersionString = element.getAttribute(JPA_FACET_VERSION_ATTRIBUTE);
        if (jpaFacetVersionString != null) {
            IProjectFacetVersion jpaFacetVersion = JpaProject.FACET.getVersion(jpaFacetVersionString);
            if (jpaFacetVersion == null) {
                this.logInvalidValue(element, JPA_FACET_VERSION_ATTRIBUTE, jpaFacetVersionString);
                return null;
            }
            config.setJpaFacetVersion(jpaFacetVersion);
        }
        if ((defaultString = element.getAttribute(DEFAULT_ATTRIBUTE)) != null) {
            Boolean default_;
            Boolean bl = defaultString.equals("true") ? Boolean.TRUE : (default_ = defaultString.equals("false") ? Boolean.FALSE : null);
            if (default_ == null) {
                this.logInvalidValue(element, DEFAULT_ATTRIBUTE, defaultString);
                return null;
            }
            config.setDefault(default_);
        }
        if ((groupID = element.getAttribute(GROUP_ATTRIBUTE)) != null) {
            InternalJpaPlatformGroupConfig groupConfig = this.jpaPlatformGroupConfigs.get(groupID);
            if (groupConfig == null) {
                this.logInvalidValue(element, GROUP_ATTRIBUTE, groupID);
                return null;
            }
            config.setGroup(groupConfig);
            groupConfig.addPlatform(config);
        }
        config.setPluginId(contributor);
        return config;
    }

    public void initializeDefaultPreferences() {
        for (IProjectFacetVersion jpaFacetVersion : this.getJpaFacetVersions()) {
            this.initializeDefaultPreference(jpaFacetVersion);
        }
    }

    private Set<IProjectFacetVersion> getJpaFacetVersions() {
        return JpaProject.FACET.getVersions();
    }

    private void initializeDefaultPreference(IProjectFacetVersion jpaFacetVersion) {
        JpaPlatform.Config config = this.buildDefaultJpaPlatformConfig(jpaFacetVersion);
        if (config != null) {
            this.getPlugin().setDefaultPreference(this.buildDefaultJpaPlatformPreferenceKey(jpaFacetVersion), config.getId());
        }
    }

    private JpaPlatform.Config buildDefaultJpaPlatformConfig(IProjectFacetVersion jpaFacetVersion) {
        InternalJpaPlatformConfig config = this.selectJpaPlatformConfig(this.getDefaultJpaPlatformConfigs(), jpaFacetVersion);
        if (config != null) {
            return config;
        }
        config = this.selectJpaPlatformConfig(this.getDaliJpaPlatformConfigs(), jpaFacetVersion);
        if (config != null) {
            return config;
        }
        this.logError(JptJpaCoreMessages.INVALID_FACET, jpaFacetVersion);
        return null;
    }

    private String buildDefaultJpaPlatformPreferenceKey(IProjectFacetVersion jpaFacetVersion) {
        return DEFAULT_JPA_PLATFORM_PREF_KEY_BASE + jpaFacetVersion.getVersionString();
    }

    @Override
    public JpaPlatform getJpaPlatform(String jpaPlatformID) {
        InternalJpaPlatformConfig config = this.jpaPlatformConfigs.get(jpaPlatformID);
        return config == null ? null : config.getJpaPlatform();
    }

    @Override
    public Iterable<JpaPlatform.GroupConfig> getJpaPlatformGroupConfigs() {
        return new SuperIterableWrapper(this.jpaPlatformGroupConfigs.values());
    }

    @Override
    public JpaPlatform.GroupConfig getJpaPlatformGroupConfig(String groupID) {
        return this.jpaPlatformGroupConfigs.get(groupID);
    }

    @Override
    public Iterable<JpaPlatform.Config> getJpaPlatformConfigs() {
        return new SuperIterableWrapper(this.getInternalJpaPlatformConfigs());
    }

    private Iterable<InternalJpaPlatformConfig> getInternalJpaPlatformConfigs() {
        return this.jpaPlatformConfigs.values();
    }

    @Override
    public JpaPlatform.Config getJpaPlatformConfig(String jpaPlatformID) {
        return this.jpaPlatformConfigs.get(jpaPlatformID);
    }

    @Override
    public Iterable<JpaPlatform.Config> getJpaPlatformConfigs(IProjectFacetVersion jpaFacetVersion) {
        return new SuperIterableWrapper(this.getInternalJpaPlatformConfigs(jpaFacetVersion));
    }

    private Iterable<InternalJpaPlatformConfig> getInternalJpaPlatformConfigs(IProjectFacetVersion jpaFacetVersion) {
        return this.selectJpaPlatformConfigs(this.getInternalJpaPlatformConfigs(), jpaFacetVersion);
    }

    private InternalJpaPlatformConfig selectJpaPlatformConfig(Iterable<InternalJpaPlatformConfig> configs, IProjectFacetVersion jpaFacetVersion) {
        Iterator<InternalJpaPlatformConfig> stream = this.selectJpaPlatformConfigs(configs, jpaFacetVersion).iterator();
        return stream.hasNext() ? stream.next() : null;
    }

    private Iterable<InternalJpaPlatformConfig> selectJpaPlatformConfigs(Iterable<InternalJpaPlatformConfig> configs, IProjectFacetVersion jpaFacetVersion) {
        return IterableTools.filter(configs, this.buildConfigSupportsJpaFacetVersion(jpaFacetVersion));
    }

    private Predicate<InternalJpaPlatformConfig> buildConfigSupportsJpaFacetVersion(IProjectFacetVersion jpaFacetVersion) {
        return new InternalJpaPlatformConfig.SupportsJpaFacetVersion(jpaFacetVersion);
    }

    private Iterable<InternalJpaPlatformConfig> getDefaultJpaPlatformConfigs() {
        return IterableTools.filter(this.getInternalJpaPlatformConfigs(), JpaPlatform.Config.IS_DEFAULT);
    }

    private Iterable<InternalJpaPlatformConfig> getDaliJpaPlatformConfigs() {
        return IterableTools.filter(this.getInternalJpaPlatformConfigs(), this.buildIsDaliJpaPlatformConfig());
    }

    private Predicate<InternalJpaPlatformConfig> buildIsDaliJpaPlatformConfig() {
        return new FactoryClassNameStartsWith(this.getPluginID());
    }

    @Override
    public JpaPlatform.Config getDefaultJpaPlatformConfig(IProjectFacetVersion jpaFacetVersion) {
        String key = this.buildDefaultJpaPlatformPreferenceKey(jpaFacetVersion);
        String id = this.getPlugin().getPreference(key);
        return id == null ? null : this.getJpaPlatformConfig(id);
    }

    @Override
    public void setDefaultJpaPlatformConfig(IProjectFacetVersion jpaFacetVersion, JpaPlatform.Config config) {
        String key = this.buildDefaultJpaPlatformPreferenceKey(jpaFacetVersion);
        this.getPlugin().setPreference(key, config.getId());
    }

    private void logError(String msg, Object ... args) {
        this.getPlugin().logError(msg, args);
    }

    private void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.getPlugin().logError(ExtensionPointTools.buildMissingAttributeMessage((IConfigurationElement)element, (String)attributeName));
    }

    private void logInvalidValue(IConfigurationElement element, String nodeName, String invalidValue) {
        this.getPlugin().logError(ExtensionPointTools.buildInvalidValueMessage((IConfigurationElement)element, (String)nodeName, (String)invalidValue));
    }

    @Override
    public JpaWorkspace getJpaWorkspace() {
        return this.jpaWorkspace;
    }

    String getExtensionPointName() {
        return String.valueOf(this.getPluginID()) + '.' + SIMPLE_EXTENSION_POINT_NAME;
    }

    private IExtensionPoint getExtensionPoint() {
        return this.getExtensionRegistry().getExtensionPoint(this.getPluginID(), SIMPLE_EXTENSION_POINT_NAME);
    }

    private IExtensionRegistry getExtensionRegistry() {
        return RegistryFactory.getRegistry();
    }

    private String getPluginID() {
        return this.getPlugin().getPluginID();
    }

    private JptJpaCorePlugin getPlugin() {
        return JptJpaCorePlugin.instance();
    }

    public String toString() {
        return ObjectTools.toString((Object)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FactoryClassNameStartsWith
    extends CriterionPredicate<InternalJpaPlatformConfig, String> {
        FactoryClassNameStartsWith(String prefix) {
            super((Object)prefix);
        }

        public boolean evaluate(InternalJpaPlatformConfig config) {
            return config.getFactoryClassName().startsWith((String)this.criterion);
        }
    }
}

