/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.IdTypeMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaIdClassReference;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaIdClassReference
extends AbstractJavaContextModel<JavaTypeMapping>
implements JavaIdClassReference,
PersistentType.Parent {
    protected String specifiedIdClassName = this.buildSpecifiedIdClassName();
    protected String defaultIdClassName;
    protected String idClassName;
    protected String fullyQualifiedIdClassName;
    protected JavaPersistentType idClass;

    public GenericJavaIdClassReference(JavaTypeMapping parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedIdClassName_(this.buildSpecifiedIdClassName());
        if (this.idClass != null) {
            this.idClass.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultIdClassName_(this.buildDefaultIdClassName());
        this.setIdClassName_(this.buildIdClassName());
        this.setFullyQualifiedIdClassName(this.buildFullyQualifiedIdClassName());
        this.updateIdClass();
    }

    @Override
    public String getIdClassName() {
        return this.getSpecifiedIdClassName();
    }

    protected void setIdClassName_(String name) {
        String old = this.idClassName;
        this.idClassName = name;
        this.firePropertyChanged("idClassName", old, name);
    }

    protected String buildIdClassName() {
        return this.specifiedIdClassName != null ? this.specifiedIdClassName : this.defaultIdClassName;
    }

    @Override
    public String getSpecifiedIdClassName() {
        return this.specifiedIdClassName;
    }

    @Override
    public void setSpecifiedIdClassName(String name) {
        if (ObjectTools.notEquals((Object)name, (Object)this.specifiedIdClassName)) {
            this.getIdClassAnnotationForUpdate().setValue(name);
            this.removeIdClassAnnotationIfUnset();
            this.setSpecifiedIdClassName_(name);
        }
    }

    protected void setSpecifiedIdClassName_(String name) {
        String old = this.specifiedIdClassName;
        this.specifiedIdClassName = name;
        this.firePropertyChanged("specifiedIdClassName", old, name);
    }

    protected String buildSpecifiedIdClassName() {
        IdClassAnnotation annotation = this.getIdClassAnnotation();
        return annotation == null ? null : annotation.getValue();
    }

    @Override
    public String getDefaultIdClassName() {
        return this.defaultIdClassName;
    }

    protected void setDefaultIdClassName_(String name) {
        String old = this.defaultIdClassName;
        this.defaultIdClassName = name;
        this.firePropertyChanged("defaultIdClassName", old, name);
    }

    protected String buildDefaultIdClassName() {
        IdTypeMapping superType = ((JavaTypeMapping)this.getParent()).getSuperTypeMapping();
        return superType == null ? null : superType.getIdClassReference().getFullyQualifiedIdClassName();
    }

    @Override
    public boolean isSpecified() {
        return this.specifiedIdClassName != null;
    }

    protected IdClassAnnotation getIdClassAnnotation() {
        return (IdClassAnnotation)this.getJavaResourceType().getAnnotation(this.getIdClassAnnotationName());
    }

    protected IdClassAnnotation getIdClassAnnotationForUpdate() {
        IdClassAnnotation annotation = this.getIdClassAnnotation();
        return annotation != null ? annotation : this.buildIdClassAnnotation();
    }

    protected IdClassAnnotation buildIdClassAnnotation() {
        return (IdClassAnnotation)this.getJavaResourceType().addAnnotation(this.getIdClassAnnotationName());
    }

    protected void removeIdClassAnnotationIfUnset() {
        if (this.getIdClassAnnotation().isUnset()) {
            this.removeIdClassAnnotation();
        }
    }

    protected void removeIdClassAnnotation() {
        this.getJavaResourceType().removeAnnotation(this.getIdClassAnnotationName());
    }

    protected String getIdClassAnnotationName() {
        return "javax.persistence.IdClass";
    }

    @Override
    public String getFullyQualifiedIdClassName() {
        return this.fullyQualifiedIdClassName;
    }

    protected void setFullyQualifiedIdClassName(String name) {
        String old = this.fullyQualifiedIdClassName;
        this.fullyQualifiedIdClassName = name;
        this.firePropertyChanged("fullyQualifiedIdClass", old, name);
    }

    protected String buildFullyQualifiedIdClassName() {
        IdClassAnnotation annotation = this.getIdClassAnnotation();
        return annotation == null ? null : annotation.getFullyQualifiedClassName();
    }

    @Override
    public JavaPersistentType getIdClass() {
        return this.idClass;
    }

    protected void setIdClass(JavaPersistentType idClass) {
        JavaPersistentType old = this.idClass;
        this.idClass = idClass;
        this.firePropertyChanged("idClass", old, idClass);
    }

    protected void updateIdClass() {
        JavaResourceType resourceIdClass = this.resolveResourceIdClass();
        if (resourceIdClass == null) {
            if (this.idClass != null) {
                this.setIdClass(null);
            }
        } else if (this.idClass == null) {
            this.setIdClass(this.buildIdClass(resourceIdClass));
        } else if (this.idClass.getJavaResourceType() == resourceIdClass) {
            this.idClass.update();
        } else {
            this.setIdClass(this.buildIdClass(resourceIdClass));
        }
    }

    protected JavaResourceType resolveResourceIdClass() {
        if (this.fullyQualifiedIdClassName == null) {
            return null;
        }
        JavaResourceType jrt = this.getIdClassJavaResourceType();
        return jrt == null ? null : (jrt.isAnnotatedWithAnyOf(this.getJpaProject().getTypeMappingAnnotationNames()) ? null : jrt);
    }

    protected JavaResourceType getIdClassJavaResourceType() {
        if (this.fullyQualifiedIdClassName == null) {
            return null;
        }
        return (JavaResourceType)this.getJpaProject().getJavaResourceType(this.fullyQualifiedIdClassName, JavaResourceAnnotatedElement.AstNodeType.TYPE);
    }

    protected JavaPersistentType buildIdClass(JavaResourceType resourceClass) {
        return this.getJpaFactory().buildJavaPersistentType(this, resourceClass);
    }

    @Override
    public char getIdClassEnclosingTypeSeparator() {
        return '.';
    }

    protected JavaTypeMapping getTypeMapping() {
        return (JavaTypeMapping)this.parent;
    }

    protected JavaPersistentType getPersistentType() {
        return this.getTypeMapping().getPersistentType();
    }

    protected JavaResourceType getJavaResourceType() {
        return this.getPersistentType().getJavaResourceType();
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return this.getPersistentType().getAccess();
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistentType().getAccess();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateIdClass(messages, reporter);
    }

    protected void validateIdClass(List<IMessage> messages, IReporter reporter) {
        JavaResourceType jrt;
        if (this.isSpecified() && (jrt = this.getIdClassJavaResourceType()) != null) {
            if (!jrt.isPublic()) {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_NOT_PUBLIC, jrt.getTypeBinding().getQualifiedName()));
            }
            if (!TypeTools.isSerializable((String)jrt.getTypeBinding().getQualifiedName(), (IJavaProject)this.getJpaProject().getJavaProject())) {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_NOT_IMPLEMENT_SERIALIZABLE, jrt.getTypeBinding().getQualifiedName()));
            }
            if (!jrt.hasEqualsMethod()) {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_MISSING_EQUALS_METHOD, jrt.getTypeBinding().getQualifiedName()));
            }
            if (!jrt.hasHashCodeMethod()) {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.TYPE_MAPPING_ID_CLASS_MISSING_HASHCODE_METHOD, jrt.getTypeBinding().getQualifiedName()));
            }
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getAnnotationTextRange();
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange();
    }

    protected TextRange getAnnotationTextRange() {
        IdClassAnnotation annotation = this.getIdClassAnnotation();
        return annotation == null ? null : annotation.getTextRange();
    }
}

