/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.seam;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Parent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.project.ResolverConfigurationIO;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.model.edit.pom.Configuration;
import org.eclipse.m2e.model.edit.pom.Dependency;
import org.eclipse.m2e.model.edit.pom.Model;
import org.eclipse.m2e.model.edit.pom.Plugin;
import org.eclipse.m2e.model.edit.pom.PluginExecution;
import org.eclipse.m2e.model.edit.pom.PomFactory;
import org.eclipse.m2e.model.edit.pom.Resource;
import org.eclipse.m2e.model.edit.pom.util.PomResourceImpl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.jboss.tools.maven.core.MavenCoreActivator;
import org.jboss.tools.maven.core.ProjectUtil;
import org.jboss.tools.maven.core.xpl.ProjectUpdater;
import org.jboss.tools.maven.seam.Messages;
import org.jboss.tools.maven.seam.ParentAdder;
import org.jboss.tools.maven.seam.utils.SeamUtils;
import org.jboss.tools.seam.core.SeamUtil;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetAbstractInstallDelegate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MavenSeamActivator
extends AbstractUIPlugin {
    private static final String ORG_CODEHAUS_MOJO = "org.codehaus.mojo";
    private static final String PARENT_SUFFIX = "-parent";
    public static final String PLUGIN_ID = "org.jboss.tools.maven.seam";
    private static MavenSeamActivator plugin;
    private String webProjectName;
    private String artifactId;
    private String parentProjectName;
    private String parentArtifactId;
    private String earProjectName;
    private String earArtifactId;
    private String ejbProjectName;
    private String ejbArtifactId;
    private String testProjectName;
    private String testArtifactId;
    private String groupId;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static MavenSeamActivator getDefault() {
        return plugin;
    }

    public void configureSeamProject(IDataModel seamFacetModel, IDataModel m2FacetModel) {
        Assert.isNotNull((Object)seamFacetModel);
        Assert.isNotNull((Object)m2FacetModel);
        String seamVersion = m2FacetModel.getStringProperty("seamMavenVersion");
        if (!SeamUtils.isSeamConversionSupported(seamVersion)) {
            return;
        }
        this.webProjectName = seamFacetModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        this.artifactId = m2FacetModel.getStringProperty("artifactId");
        this.groupId = m2FacetModel.getStringProperty("groupId");
        this.parentProjectName = String.valueOf(this.webProjectName) + PARENT_SUFFIX;
        this.parentArtifactId = String.valueOf(this.artifactId) + PARENT_SUFFIX;
        this.testArtifactId = this.testProjectName = seamFacetModel.getStringProperty("seam.test.project");
        this.earArtifactId = this.earProjectName = seamFacetModel.getStringProperty("seam.ear.project");
        this.ejbArtifactId = this.ejbProjectName = seamFacetModel.getStringProperty("seam.ejb.project");
        this.configureParentProject(m2FacetModel, seamFacetModel);
        this.configureWarProject(m2FacetModel, seamFacetModel);
        this.configureTestProject(m2FacetModel, seamFacetModel);
        if (!SeamFacetAbstractInstallDelegate.isWarConfiguration((IDataModel)seamFacetModel)) {
            this.configureEjbProject(m2FacetModel, seamFacetModel);
            this.configureEarProject(m2FacetModel, seamFacetModel);
        }
    }

    private void configureTestProject(IDataModel m2FacetModel, IDataModel seamFacetModel) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.testProjectName);
        if (project == null || !project.exists()) {
            return;
        }
        IFile pom = project.getFile("pom.xml");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (!pom.exists()) {
            org.apache.maven.model.Model model = new org.apache.maven.model.Model();
            model.setModelVersion("4.0.0");
            model.setArtifactId(this.testArtifactId);
            model.setName(String.valueOf(m2FacetModel.getStringProperty("name")) + " - test");
            model.setPackaging("jar");
            model.setDescription(m2FacetModel.getStringProperty("description"));
            Parent parent = new Parent();
            parent.setArtifactId(this.parentArtifactId);
            parent.setGroupId(m2FacetModel.getStringProperty("groupId"));
            parent.setVersion(m2FacetModel.getStringProperty("version"));
            parent.setRelativePath("../" + this.parentProjectName);
            model.setParent(parent);
            List dependencies = model.getDependencies();
            org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.jboss.seam.embedded");
            dependency.setArtifactId("hibernate-all");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.jboss.seam.embedded");
            dependency.setArtifactId("jboss-embedded-all");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.jboss.seam.embedded");
            dependency.setArtifactId("thirdparty-all");
            dependencies.add(dependency);
            dependency = this.getSeamDependency();
            dependency.setScope("compile");
            dependencies.add(dependency);
            dependency = this.getJSFApi();
            dependency.setScope("test");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("javax.activation");
            dependency.setArtifactId("activation");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.testng");
            dependency.setArtifactId("testng");
            dependency.setClassifier("jdk15");
            dependency.setScope("compile");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.slf4j");
            dependency.setArtifactId("slf4j-api");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.slf4j");
            dependency.setArtifactId("slf4j-nop");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("javax.el");
            dependency.setArtifactId("el-api");
            dependency.setScope("test");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId(this.groupId);
            dependency.setArtifactId(this.artifactId);
            dependency.setType("war");
            dependency.setScope("test");
            dependencies.add(dependency);
            if (!SeamFacetAbstractInstallDelegate.isWarConfiguration((IDataModel)seamFacetModel)) {
                dependency = new org.apache.maven.model.Dependency();
                dependency.setGroupId(this.groupId);
                dependency.setArtifactId(this.ejbArtifactId);
                dependency.setType("ejb");
                dependency.setScope("test");
                dependencies.add(dependency);
            }
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.drools");
            dependency.setArtifactId("drools-compiler");
            dependency.setScope("test");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.jbpm");
            dependency.setArtifactId("jbpm-jpdl");
            dependency.setScope("test");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.eclipse.jdt");
            dependency.setArtifactId("core");
            dependency.setVersion("3.4.2.v_883_R34x");
            dependency.setScope("test");
            dependencies.add(dependency);
            Build build = new Build();
            try {
                String sourceDirectory = MavenCoreActivator.getSourceDirectory((IJavaProject)javaProject);
                if (sourceDirectory != null) {
                    build.setTestSourceDirectory(sourceDirectory);
                }
                MavenCoreActivator.addResource((Build)build, (IProject)project, (String)sourceDirectory);
                org.apache.maven.model.Resource resource = new org.apache.maven.model.Resource();
                resource.setDirectory("${basedir}/bootstrap");
                ArrayList<String> excludes = new ArrayList<String>();
                excludes.add("**/*.java");
                resource.setExcludes(excludes);
                build.getResources().add(resource);
                resource = new org.apache.maven.model.Resource();
                IProject webProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.webProjectName);
                if (project == null || !project.exists()) {
                    return;
                }
                String webContent = MavenSeamActivator.getRootComponent(webProject);
                resource.setDirectory("${basedir}/../" + this.webProjectName + "/" + webContent);
                excludes = new ArrayList();
                excludes.add("**/*.java");
                resource.setExcludes(excludes);
                build.getResources().add(resource);
                model.setBuild(build);
                MavenCoreActivator.createMavenProject((String)this.testProjectName, null, (org.apache.maven.model.Model)model, (boolean)true);
            }
            catch (Exception e) {
                MavenSeamActivator.log(e);
            }
        }
    }

    private void configureEarProject(IDataModel m2FacetModel, IDataModel seamFacetModel) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.earProjectName);
        IFile pom = project.getFile("pom.xml");
        if (!pom.exists()) {
            String fullVersion;
            SeamVersion seamVersion;
            org.apache.maven.model.Model model = new org.apache.maven.model.Model();
            model.setModelVersion("4.0.0");
            model.setArtifactId(this.earArtifactId);
            model.setName(String.valueOf(m2FacetModel.getStringProperty("name")) + " - EAR");
            model.setPackaging("ear");
            model.setDescription(m2FacetModel.getStringProperty("description"));
            Parent parent = new Parent();
            parent.setArtifactId(this.parentArtifactId);
            parent.setGroupId(m2FacetModel.getStringProperty("groupId"));
            parent.setVersion(m2FacetModel.getStringProperty("version"));
            parent.setRelativePath("../" + this.parentProjectName);
            model.setParent(parent);
            List dependencies = model.getDependencies();
            org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId(m2FacetModel.getStringProperty("groupId"));
            dependency.setArtifactId(this.ejbProjectName);
            dependency.setType("ejb");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId(m2FacetModel.getStringProperty("groupId"));
            dependency.setArtifactId(this.webProjectName);
            dependency.setType("war");
            dependencies.add(dependency);
            dependency = this.getSeamDependency();
            dependency.setType("ejb");
            dependency.setScope("compile");
            List exclusions = dependency.getExclusions();
            Exclusion exclusion = new Exclusion();
            exclusion.setGroupId("javassist");
            exclusion.setArtifactId("javassist");
            exclusions.add(exclusion);
            exclusion = new Exclusion();
            exclusion.setGroupId("javax.el");
            exclusion.setArtifactId("el-api");
            exclusions.add(exclusion);
            exclusion = new Exclusion();
            exclusion.setGroupId("dom4j");
            exclusion.setArtifactId("dom4j");
            exclusions.add(exclusion);
            exclusion = new Exclusion();
            exclusion.setGroupId("xstream");
            exclusion.setArtifactId("xstream");
            exclusions.add(exclusion);
            exclusion = new Exclusion();
            exclusion.setGroupId("xpp3");
            exclusion.setArtifactId("xpp3_min");
            exclusions.add(exclusion);
            dependencies.add(dependency);
            dependency = this.getRichFacesApi();
            dependency.setType("jar");
            dependency.setScope("compile");
            exclusions = dependency.getExclusions();
            exclusion = new Exclusion();
            exclusion.setGroupId("commons-collections");
            exclusion.setArtifactId("commons-collections");
            exclusions.add(exclusion);
            exclusion = new Exclusion();
            exclusion.setGroupId("commons-logging");
            exclusion.setArtifactId("commons-logging");
            exclusions.add(exclusion);
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.drools");
            dependency.setArtifactId("drools-compiler");
            dependency.setType("jar");
            dependency.setScope("compile");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            String jbpmGroupId = "org.jbpm";
            SeamRuntime seamRuntime = SeamRuntimeManager.getInstance().findRuntimeByName(seamFacetModel.getProperty("seam.runtime.name").toString());
            if (seamRuntime != null && SeamVersion.SEAM_2_2.equals((Object)(seamVersion = seamRuntime.getVersion())) && (fullVersion = SeamUtil.getSeamVersionFromManifest((SeamRuntime)seamRuntime)) != null && fullVersion.contains("EAP")) {
                jbpmGroupId = "org.jbpm.jbpm3";
            }
            dependency.setGroupId(jbpmGroupId);
            dependency.setArtifactId("jbpm-jpdl");
            dependency.setType("jar");
            dependency.setScope("compile");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("commons-digester");
            dependency.setArtifactId("commons-digester");
            dependencies.add(dependency);
            Build build = new Build();
            try {
                build.setFinalName(this.earProjectName);
                MavenCoreActivator.addMavenEarPlugin((Build)build, (IProject)project, (IDataModel)m2FacetModel, (String)this.ejbArtifactId, (IProjectFacetVersion)JavaEEProjectUtilities.ENTERPRISE_APPLICATION_50, (boolean)true);
                model.setBuild(build);
                MavenCoreActivator.createMavenProject((String)this.earProjectName, null, (org.apache.maven.model.Model)model, (boolean)true);
            }
            catch (Exception e) {
                MavenSeamActivator.log(e);
            }
        }
    }

    private void configureEjbProject(IDataModel m2FacetModel, IDataModel seamFacetModel) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.ejbProjectName);
        IFile pom = project.getFile("pom.xml");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (!pom.exists()) {
            org.apache.maven.model.Model model = new org.apache.maven.model.Model();
            model.setModelVersion("4.0.0");
            model.setArtifactId(this.ejbArtifactId);
            model.setName(String.valueOf(m2FacetModel.getStringProperty("name")) + " - EJB");
            model.setPackaging("ejb");
            model.setDescription(m2FacetModel.getStringProperty("description"));
            Parent parent = new Parent();
            parent.setArtifactId(this.parentArtifactId);
            parent.setGroupId(m2FacetModel.getStringProperty("groupId"));
            parent.setVersion(m2FacetModel.getStringProperty("version"));
            parent.setRelativePath("../" + this.parentProjectName);
            model.setParent(parent);
            List dependencies = model.getDependencies();
            org.apache.maven.model.Dependency dependency = this.getSeamDependency();
            dependency.setScope("provided");
            dependencies.add(dependency);
            dependencies.add(this.getJSFApi());
            dependencies.add(this.getRichFacesApi());
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("javax.ejb");
            dependency.setArtifactId("ejb-api");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("javax.annotation");
            dependency.setArtifactId("jsr250-api");
            dependencies.add(dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("javax.persistence");
            dependency.setArtifactId("persistence-api");
            dependencies.add(dependency);
            dependencies.add(this.getHibernateAnnotations());
            dependencies.add(this.getHibernateCommonAnnotations());
            dependencies.add(this.getHibernateValidator());
            Build build = new Build();
            try {
                String sourceDirectory = MavenCoreActivator.getSourceDirectory((IJavaProject)javaProject);
                if (sourceDirectory != null) {
                    build.setSourceDirectory(sourceDirectory);
                }
                MavenCoreActivator.addMavenEjbPlugin((Build)build, (IProject)project, (IProjectFacetVersion)JavaEEProjectUtilities.EJB_30);
                model.setBuild(build);
                MavenCoreActivator.createMavenProject((String)this.ejbProjectName, null, (org.apache.maven.model.Model)model, (boolean)true);
                ProjectUtil.removeWTPContainers((IDataModel)m2FacetModel, (IProject)project);
            }
            catch (Exception e) {
                MavenSeamActivator.log(e);
            }
        }
    }

    public void updateProject(IFile pomFile, ProjectUpdater updater) {
        File pom = pomFile.getLocation().toFile();
        PomResourceImpl resource = null;
        try {
            try {
                resource = MavenCoreActivator.loadResource((IFile)pomFile);
                updater.update(resource.getModel());
                resource.save(Collections.EMPTY_MAP);
            }
            catch (Exception ex) {
                String msg = "Unable to update " + pom;
                MavenSeamActivator.log(ex, msg);
                if (resource != null) {
                    resource.unload();
                }
            }
        }
        finally {
            if (resource != null) {
                resource.unload();
            }
        }
    }

    public void addDependency(IFile pomFile, org.apache.maven.model.Dependency dependency) {
        this.updateProject(pomFile, new DependencyAdder(dependency));
    }

    private void configureWarProject(IDataModel m2FacetModel, IDataModel seamFacetModel) {
        try {
            IProject webProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.webProjectName);
            IFile pomFile = webProject.getFile("pom.xml");
            String artifactId = this.parentProjectName;
            String groupId = m2FacetModel.getStringProperty("groupId");
            String version = m2FacetModel.getStringProperty("version");
            String relativePath = "../" + this.parentProjectName;
            ParentAdder parentAdder = new ParentAdder(groupId, artifactId, version, relativePath);
            this.updateProject(pomFile, parentAdder);
            org.apache.maven.model.Dependency dependency = this.getHibernateValidator();
            this.addDependency(pomFile, dependency);
            dependency = this.getHibernateAnnotations();
            this.addDependency(pomFile, dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.hibernate");
            dependency.setArtifactId("hibernate-entitymanager");
            this.addDependency(pomFile, dependency);
            dependency = this.getSeamDependency();
            if (!SeamFacetAbstractInstallDelegate.isWarConfiguration((IDataModel)seamFacetModel)) {
                dependency.setScope("provided");
            }
            this.addDependency(pomFile, dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.jboss.seam");
            dependency.setArtifactId("jboss-seam-ui");
            List exclusions = dependency.getExclusions();
            Exclusion exclusion = new Exclusion();
            exclusion.setGroupId("org.jboss.seam");
            exclusion.setArtifactId("jboss-seam");
            exclusions.add(exclusion);
            this.addDependency(pomFile, dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.jboss.seam");
            dependency.setArtifactId("jboss-seam-ioc");
            exclusions = dependency.getExclusions();
            exclusion = new Exclusion();
            exclusion.setGroupId("org.jboss.seam");
            exclusion.setArtifactId("jboss-seam");
            exclusions.add(exclusion);
            this.addDependency(pomFile, dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.jboss.seam");
            dependency.setArtifactId("jboss-seam-debug");
            this.addDependency(pomFile, dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.jboss.seam");
            dependency.setArtifactId("jboss-seam-mail");
            this.addDependency(pomFile, dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.jboss.seam");
            dependency.setArtifactId("jboss-seam-pdf");
            this.addDependency(pomFile, dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.jboss.seam");
            dependency.setArtifactId("jboss-seam-remoting");
            this.addDependency(pomFile, dependency);
            if (FacetedProjectFramework.hasProjectFacet((IProject)webProject, (String)"jst.seam", (String)"2.1")) {
                dependency = new org.apache.maven.model.Dependency();
                dependency.setGroupId("org.jboss.seam");
                dependency.setArtifactId("jboss-seam-excel");
                this.addDependency(pomFile, dependency);
            }
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("javax.servlet");
            dependency.setArtifactId("servlet-api");
            this.addDependency(pomFile, dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.richfaces.ui");
            dependency.setArtifactId("richfaces-ui");
            this.addDependency(pomFile, dependency);
            dependency = this.getRichFacesApi();
            if (!SeamFacetAbstractInstallDelegate.isWarConfiguration((IDataModel)seamFacetModel)) {
                dependency.setScope("provided");
            }
            this.addDependency(pomFile, dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("org.richfaces.framework");
            dependency.setArtifactId("richfaces-impl");
            this.addDependency(pomFile, dependency);
            dependency = this.getJSFApi();
            this.addDependency(pomFile, dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("javax.faces");
            dependency.setArtifactId("jsf-impl");
            this.addDependency(pomFile, dependency);
            dependency = new org.apache.maven.model.Dependency();
            dependency.setGroupId("javax.el");
            dependency.setArtifactId("el-api");
            this.addDependency(pomFile, dependency);
            if (SeamFacetAbstractInstallDelegate.isWarConfiguration((IDataModel)seamFacetModel)) {
                dependency = new org.apache.maven.model.Dependency();
                dependency.setGroupId("org.drools");
                dependency.setArtifactId("drools-compiler");
                dependency.setType("jar");
                dependency.setScope("compile");
                this.addDependency(pomFile, dependency);
                dependency = new org.apache.maven.model.Dependency();
                dependency.setGroupId("org.jbpm");
                dependency.setArtifactId("jbpm-jpdl");
                dependency.setType("jar");
                dependency.setScope("compile");
                this.addDependency(pomFile, dependency);
                dependency = new org.apache.maven.model.Dependency();
                dependency.setGroupId("commons-digester");
                dependency.setArtifactId("commons-digester");
                this.addDependency(pomFile, dependency);
                this.updateProject(pomFile, new WarProjectUpdater(webProject));
            }
            if (!SeamFacetAbstractInstallDelegate.isWarConfiguration((IDataModel)seamFacetModel)) {
                dependency = new org.apache.maven.model.Dependency();
                dependency.setGroupId(m2FacetModel.getStringProperty("groupId"));
                dependency.setArtifactId(this.ejbProjectName);
                dependency.setType("ejb");
                dependency.setScope("provided");
                this.addDependency(pomFile, dependency);
            }
            this.updateProject(pomFile, new WarProjectUpdater(webProject));
            ProjectUtil.removeWTPContainers((IDataModel)m2FacetModel, (IProject)webProject);
        }
        catch (Exception e) {
            MavenSeamActivator.log(e);
        }
    }

    private static String getRootComponent(IProject webProject) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)webProject);
        IVirtualFolder rootFolder = component.getRootFolder();
        IContainer root = rootFolder.getUnderlyingFolder();
        String webContentRoot = root.getProjectRelativePath().toString();
        return webContentRoot;
    }

    private static Plugin getPlugin(org.eclipse.m2e.model.edit.pom.Build build, String groupId, String artifactId) {
        EList plugins = build.getPlugins();
        for (Plugin plugin : plugins) {
            String group = plugin.getGroupId();
            if (group == null) {
                group = ORG_CODEHAUS_MOJO;
            }
            String artifact = plugin.getArtifactId();
            if (!group.equals(groupId) || !artifactId.equals(artifact)) continue;
            return plugin;
        }
        Plugin newPlugin = PomFactory.eINSTANCE.createPlugin();
        newPlugin.setGroupId(groupId);
        newPlugin.setArtifactId(artifactId);
        build.getPlugins().add((Object)newPlugin);
        return newPlugin;
    }

    private org.apache.maven.model.Dependency getHibernateValidator() {
        org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
        dependency.setGroupId("org.hibernate");
        dependency.setArtifactId("hibernate-validator");
        return dependency;
    }

    private org.apache.maven.model.Dependency getHibernateAnnotations() {
        org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
        dependency.setGroupId("org.hibernate");
        dependency.setArtifactId("hibernate-annotations");
        return dependency;
    }

    private org.apache.maven.model.Dependency getHibernateCommonAnnotations() {
        org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
        dependency.setGroupId("org.hibernate");
        dependency.setArtifactId("hibernate-commons-annotations");
        return dependency;
    }

    private org.apache.maven.model.Dependency getRichFacesApi() {
        org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
        dependency.setGroupId("org.richfaces.framework");
        dependency.setArtifactId("richfaces-api");
        return dependency;
    }

    private org.apache.maven.model.Dependency getJSFApi() {
        org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
        dependency.setGroupId("javax.faces");
        dependency.setArtifactId("jsf-api");
        return dependency;
    }

    private org.apache.maven.model.Dependency getSeamDependency() {
        org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
        dependency.setGroupId("org.jboss.seam");
        dependency.setArtifactId("jboss-seam");
        dependency.setType("ejb");
        return dependency;
    }

    private void configureParentProject(IDataModel m2FacetModel, IDataModel seamFacetModel) {
        block29: {
            Bundle bundle = MavenSeamActivator.getDefault().getBundle();
            URL parentPomEntryURL = bundle.getEntry("/poms/parent-pom.xml");
            InputStream inputStream = null;
            try {
                try {
                    String seamHomePath;
                    File seamHomeDir;
                    String seamVersion;
                    String description;
                    URL resolvedURL = FileLocator.resolve((URL)parentPomEntryURL);
                    MavenModelManager modelManager = MavenPlugin.getMavenModelManager();
                    inputStream = resolvedURL.openStream();
                    org.apache.maven.model.Model model = modelManager.readMavenModel(inputStream);
                    model.setArtifactId(this.parentArtifactId);
                    model.setGroupId(m2FacetModel.getStringProperty("groupId"));
                    String projectVersion = m2FacetModel.getStringProperty("version");
                    String name = m2FacetModel.getStringProperty("name");
                    if (name != null && name.trim().length() > 0) {
                        model.setName(String.valueOf(name) + " - parent");
                    }
                    if ((description = m2FacetModel.getStringProperty("description")) != null && description.trim().length() > 0) {
                        model.setDescription(String.valueOf(description) + " - parent");
                    }
                    model.setVersion(projectVersion);
                    Properties properties = model.getProperties();
                    properties.put("project.version", projectVersion);
                    SeamRuntime seamRuntime = SeamRuntimeManager.getInstance().findRuntimeByName(seamFacetModel.getProperty("seam.runtime.name").toString());
                    if (seamRuntime == null) {
                        MavenSeamActivator.getDefault();
                        MavenSeamActivator.log(String.valueOf(Messages.MavenSeamActivator_Cannot_get_seam_runtime) + seamFacetModel.getProperty("seam.runtime.name").toString());
                    }
                    if ((seamVersion = m2FacetModel.getStringProperty("seamMavenVersion")) != null && seamVersion.trim().length() > 0) {
                        properties.put("seam.version", seamVersion);
                    }
                    if ((seamHomeDir = new File(seamHomePath = seamRuntime.getHomeDir())).exists()) {
                        File buildDir = new File(seamHomeDir, "build");
                        File rootPom = new File(buildDir, "root.pom.xml");
                        if (!rootPom.exists()) {
                            MavenSeamActivator.log(NLS.bind((String)Messages.MavenSeamActivator_The_file_does_not_exist, (Object)rootPom.getAbsolutePath()));
                        } else {
                            try {
                                String jbpmVersion;
                                Properties seamProperties;
                                Properties seamProperties2;
                                org.apache.maven.model.Model rootPomModel = modelManager.readMavenModel(rootPom);
                                List seamDependencies = rootPomModel.getDependencyManagement().getDependencies();
                                this.setArtifactVersion("jsf.version", properties, "javax.faces", "jsf-api", seamDependencies);
                                String richfacesVersion = this.setArtifactVersion("richfaces.version", properties, "org.richfaces.framework", "richfaces-impl", seamDependencies);
                                if (richfacesVersion == null && (richfacesVersion = (seamProperties2 = rootPomModel.getProperties()).getProperty("version.richfaces")) != null) {
                                    properties.put("richfaces.version", richfacesVersion);
                                }
                                this.setArtifactVersion("hibernate-validator.version", properties, "org.hibernate", "hibernate-validator", seamDependencies);
                                this.setArtifactVersion("hibernate-annotations.version", properties, "org.hibernate", "hibernate-annotations", seamDependencies);
                                this.setArtifactVersion("hibernate-entitymanager.version", properties, "org.hibernate", "hibernate-entitymanager", seamDependencies);
                                this.setArtifactVersion("jboss.embedded.version", properties, "org.jboss.seam.embedded", "jboss-embedded-api", seamDependencies);
                                this.setArtifactVersion("slf4j.version", properties, "org.slf4j", "slf4j-api", seamDependencies);
                                this.setArtifactVersion("ejb.api.version", properties, "javax.ejb", "ejb-api", seamDependencies);
                                this.setArtifactVersion("jsr250-api.version", properties, "javax.annotation", "jsr250-api", seamDependencies);
                                this.setArtifactVersion("persistence-api.version", properties, "javax.persistence", "persistence-api", seamDependencies);
                                this.setArtifactVersion("servlet.version", properties, "javax.servlet", "servlet-api", seamDependencies);
                                this.setArtifactVersion("javax.el.version", properties, "javax.el", "el-api", seamDependencies);
                                String droolsVersion = this.setArtifactVersion("drools.version", properties, "org.drools", "drools-core", seamDependencies);
                                if (droolsVersion == null && (droolsVersion = (seamProperties = rootPomModel.getProperties()).getProperty("version.drools")) != null) {
                                    properties.put("drools.version", droolsVersion);
                                }
                                if ((jbpmVersion = this.setArtifactVersion("jbpm.version", properties, "org.jbpm", "jbpm-jpdl", seamDependencies)) == null) {
                                    this.setArtifactVersion("jbpm3.version", properties, "org.jbpm.jbpm3", "jbpm-jpdl", seamDependencies);
                                }
                            }
                            catch (Exception e) {
                                MavenSeamActivator.getDefault();
                                MavenSeamActivator.log(e);
                            }
                        }
                    } else {
                        MavenSeamActivator.log(NLS.bind((String)Messages.MavenSeamActivator_The_folder_does_not_exist, (Object)seamHomePath));
                    }
                    org.apache.maven.model.Dependency dependency = new org.apache.maven.model.Dependency();
                    dependency.setGroupId(model.getGroupId());
                    dependency.setArtifactId(this.webProjectName);
                    dependency.setType("war");
                    dependency.setVersion(projectVersion);
                    model.getDependencyManagement().getDependencies().add(0, dependency);
                    List modules = model.getModules();
                    modules.add("../" + this.artifactId);
                    if (!SeamFacetAbstractInstallDelegate.isWarConfiguration((IDataModel)seamFacetModel)) {
                        modules.add("../" + this.ejbArtifactId);
                        modules.add("../" + this.earArtifactId);
                        dependency = new org.apache.maven.model.Dependency();
                        dependency.setGroupId(model.getGroupId());
                        dependency.setArtifactId(this.ejbProjectName);
                        dependency.setType("ejb");
                        dependency.setVersion(projectVersion);
                        model.getDependencyManagement().getDependencies().add(0, dependency);
                    }
                    this.webProjectName = seamFacetModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
                    IProject seamWebProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.webProjectName);
                    MavenCoreActivator.addCompilerPlugin((List)model.getBuild().getPluginManagement().getPlugins(), (IProject)seamWebProject);
                    IPath location = seamWebProject.getLocation().removeLastSegments(1);
                    location = location.append(this.parentProjectName);
                    MavenCoreActivator.createMavenProject((String)this.parentProjectName, null, (org.apache.maven.model.Model)model, (boolean)false, (IPath)location);
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.parentProjectName);
                    ResolverConfiguration configuration = ResolverConfigurationIO.readResolverConfiguration((IProject)project);
                    configuration.setResolveWorkspaceProjects(false);
                    ResolverConfigurationIO.saveResolverConfiguration((IProject)project, (ResolverConfiguration)configuration);
                }
                catch (Exception e) {
                    MavenSeamActivator.log(e);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block29;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String setArtifactVersion(String property, Properties properties, String groupId, String artifactId, List<org.apache.maven.model.Dependency> seamDependencies) {
        for (org.apache.maven.model.Dependency dependency : seamDependencies) {
            String version;
            if (!groupId.equals(dependency.getGroupId()) || !artifactId.equals(dependency.getArtifactId()) || (version = dependency.getVersion()) == null || version.startsWith("${")) continue;
            properties.put(property, version);
            return version;
        }
        return null;
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e);
        MavenSeamActivator.getDefault().getLog().log((IStatus)status);
    }

    public static void log(Throwable e, String message) {
        Status status = new Status(4, PLUGIN_ID, message, e);
        MavenSeamActivator.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message) {
        Status status = new Status(2, PLUGIN_ID, message, null);
        MavenSeamActivator.getDefault().getLog().log((IStatus)status);
    }

    public static class DependencyAdder
    extends ProjectUpdater {
        private final org.apache.maven.model.Dependency dependency;

        public DependencyAdder(org.apache.maven.model.Dependency dependency) {
            this.dependency = dependency;
        }

        public void update(Model model) {
            Dependency dependency = PomFactory.eINSTANCE.createDependency();
            dependency.setGroupId(this.dependency.getGroupId());
            dependency.setArtifactId(this.dependency.getArtifactId());
            if (this.dependency.getVersion() != null) {
                dependency.setVersion(this.dependency.getVersion());
            }
            if (this.dependency.getClassifier() != null) {
                dependency.setClassifier(this.dependency.getClassifier());
            }
            if (this.dependency.getType() != null && !"jar".equals(this.dependency.getType()) && !"null".equals(this.dependency.getType())) {
                dependency.setType(this.dependency.getType());
            }
            if (this.dependency.getScope() != null && !"compile".equals(this.dependency.getScope())) {
                dependency.setScope(this.dependency.getScope());
            }
            if (this.dependency.getSystemPath() != null) {
                dependency.setSystemPath(this.dependency.getSystemPath());
            }
            if (this.dependency.isOptional()) {
                dependency.setOptional("true");
            }
            if (!this.dependency.getExclusions().isEmpty()) {
                for (Exclusion e : this.dependency.getExclusions()) {
                    org.eclipse.m2e.model.edit.pom.Exclusion exclusion = PomFactory.eINSTANCE.createExclusion();
                    exclusion.setGroupId(e.getGroupId());
                    exclusion.setArtifactId(e.getArtifactId());
                    dependency.getExclusions().add((Object)exclusion);
                }
            }
            Iterator it = model.getDependencies().iterator();
            boolean mergeScope = false;
            String oldScope = "compile";
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                if (!dep.getGroupId().equals(dependency.getGroupId()) || !dep.getArtifactId().equals(dependency.getArtifactId()) || !this.compareNulls(dep.getClassifier(), dependency.getClassifier())) continue;
                oldScope = dep.getScope();
                it.remove();
                mergeScope = true;
            }
            if (mergeScope) {
                String newScope;
                if (oldScope == null) {
                    oldScope = "compile";
                }
                if ((newScope = this.dependency.getScope()) == null) {
                    newScope = "compile";
                }
                if (!oldScope.equals(newScope)) {
                    boolean systemScope = false;
                    boolean providedScope = false;
                    boolean compileScope = false;
                    boolean runtimeScope = false;
                    boolean testScope = false;
                    if ("compile".equals(oldScope)) {
                        systemScope = true;
                        providedScope = true;
                        compileScope = true;
                        runtimeScope = false;
                        testScope = false;
                    } else if ("runtime".equals(oldScope)) {
                        systemScope = false;
                        providedScope = false;
                        compileScope = true;
                        runtimeScope = true;
                        testScope = false;
                    } else if ("test".equals(oldScope)) {
                        systemScope = true;
                        providedScope = true;
                        compileScope = true;
                        runtimeScope = true;
                        testScope = true;
                    }
                    if ("compile".equals(newScope)) {
                        systemScope = true;
                        providedScope = true;
                        compileScope = true;
                    } else if ("runtime".equals(newScope)) {
                        compileScope = true;
                        runtimeScope = true;
                    } else if ("test".equals(newScope)) {
                        systemScope = true;
                        providedScope = true;
                        compileScope = true;
                        runtimeScope = true;
                        testScope = true;
                    }
                    if (testScope) {
                        newScope = "test";
                    } else if (runtimeScope) {
                        newScope = "runtime";
                    } else if (compileScope) {
                        newScope = "compile";
                    }
                    dependency.setScope(newScope);
                }
            }
            model.getDependencies().add((Object)dependency);
        }

        private boolean compareNulls(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return true;
            }
            if (s1 == null && s2 != null || s2 == null && s1 != null) {
                return false;
            }
            return s1.equals(s2);
        }
    }

    public static class WarProjectUpdater
    extends ProjectUpdater {
        private static final String WAR_SOURCE_DIRECTORY = "warSourceDirectory";
        private static final String WAR_SOURCE_EXCLUDES = "warSourceExcludes";
        private IProject webProject;

        public WarProjectUpdater(IProject project) {
            this.webProject = project;
        }

        public void update(Model projectModel) {
            Plugin plugin;
            IPath path;
            IClasspathEntry[] entries;
            IPath projectOutput;
            org.eclipse.m2e.model.edit.pom.Build build = projectModel.getBuild();
            if (build == null) {
                return;
            }
            IJavaProject javaProject = JavaCore.create((IProject)this.webProject);
            if (javaProject == null) {
                return;
            }
            if (!javaProject.isOpen()) {
                try {
                    javaProject.open((IProgressMonitor)new NullProgressMonitor());
                }
                catch (JavaModelException e) {
                    MavenSeamActivator.log(e);
                    return;
                }
            }
            try {
                projectOutput = javaProject.getOutputLocation();
                entries = javaProject.getRawClasspath();
            }
            catch (JavaModelException e) {
                MavenSeamActivator.log(e);
                return;
            }
            ArrayList<IPath> sources = new ArrayList<IPath>();
            ArrayList<IPath> outputs = new ArrayList<IPath>();
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getEntryKind() == 3) {
                    path = entries[i].getPath();
                    sources.add(path);
                    IPath output = entries[i].getOutputLocation();
                    if (output != null && !output.equals((Object)projectOutput)) {
                        outputs.add(output);
                    }
                }
                ++i;
            }
            int indexSource = 0;
            for (IPath source : sources) {
                if (source == null || !source.toString().contains("main")) continue;
                indexSource = sources.indexOf(source);
            }
            if (sources.size() > 0) {
                path = (IPath)sources.get(indexSource);
                String value = (path = path.makeRelativeTo(javaProject.getPath())).toString();
                value = value.startsWith("/") ? "${basedir}" + value : "${basedir}/" + value;
                build.setSourceDirectory(value);
            }
            if (projectOutput != null) {
                String value = projectOutput.toString();
                value = value.startsWith("/") ? "${basedir}" + value : "${basedir}/" + value;
                build.setOutputDirectory(value);
            }
            EList resources = build.getResources();
            resources.clear();
            for (IPath source : sources) {
                Resource resource = PomFactory.eINSTANCE.createResource();
                String value = source.makeRelativeTo(javaProject.getPath()).toString();
                value = value.startsWith("/") ? "${basedir}" + value : "${basedir}/" + value;
                resource.setDirectory(value);
                resource.getExcludes().add((Object)"**/*.java");
                resources.add((Object)resource);
            }
            if (outputs.size() > 0) {
                plugin = MavenSeamActivator.getPlugin(build, MavenSeamActivator.ORG_CODEHAUS_MOJO, "maven-war-plugin");
                Configuration configuration = plugin.getConfiguration();
                if (configuration == null) {
                    configuration = PomFactory.eINSTANCE.createConfiguration();
                    plugin.setConfiguration(configuration);
                    configuration.createNode(WAR_SOURCE_DIRECTORY);
                    String value = MavenSeamActivator.getRootComponent(this.webProject);
                    value = value.startsWith("/") ? "${basedir}" + value : "${basedir}/" + value;
                    configuration.setStringValue(WAR_SOURCE_DIRECTORY, value);
                }
                StringBuilder buffer = new StringBuilder();
                boolean first = true;
                for (IPath output : outputs) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(",");
                    }
                    String root = MavenSeamActivator.getRootComponent(this.webProject);
                    output = output.makeRelativeTo(javaProject.getPath());
                    String outputString = output.toString();
                    if (outputString.startsWith(root)) {
                        outputString = outputString.substring(root.length());
                    }
                    outputString = outputString.trim();
                    buffer.append(outputString);
                    buffer.append("/**");
                }
                String excludeString = buffer.toString().trim();
                if (excludeString.startsWith("/")) {
                    excludeString = excludeString.substring(1);
                }
                configuration.setStringValue(WAR_SOURCE_EXCLUDES, excludeString);
            }
            sources.remove(indexSource);
            if (sources.size() > 0) {
                plugin = MavenSeamActivator.getPlugin(build, MavenSeamActivator.ORG_CODEHAUS_MOJO, "build-helper-maven-plugin");
                plugin.setVersion("1.7");
                plugin.getExecutions().clear();
                PluginExecution execution = PomFactory.eINSTANCE.createPluginExecution();
                execution.setId("add-source");
                execution.setPhase("generate-sources");
                execution.getGoals().add((Object)"add-source");
                plugin.getExecutions().add((Object)execution);
                Configuration configuration = PomFactory.eINSTANCE.createConfiguration();
                execution.setConfiguration(configuration);
                Node n = configuration.createNode("sources");
                for (IPath source : sources) {
                    Element node = n.getOwnerDocument().createElement("source");
                    n.appendChild(node);
                    source = source.makeRelativeTo(javaProject.getPath());
                    String value = source.toString();
                    value = value.startsWith("/") ? "${basedir}" + value : "${basedir}/" + value;
                    node.appendChild(node.getOwnerDocument().createTextNode(value));
                }
            }
        }
    }
}

