/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value.swing;

import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.value.FilteringModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ToggleButtonModelAdapter;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioButtonModelAdapter
extends ToggleButtonModelAdapter {
    private static final long serialVersionUID = 1L;

    public RadioButtonModelAdapter(ModifiablePropertyValueModel<Object> valueHolder, Object buttonValue, boolean defaultValue) {
        super(RadioButtonModelAdapter.buildBooleanHolder(valueHolder, buttonValue), defaultValue);
    }

    public RadioButtonModelAdapter(ModifiablePropertyValueModel<Object> valueHolder, Object buttonValue) {
        super(RadioButtonModelAdapter.buildBooleanHolder(valueHolder, buttonValue));
    }

    public static ModifiablePropertyValueModel<Boolean> buildBooleanHolder(ModifiablePropertyValueModel<Object> valueHolder, Object buttonValue) {
        FilteringModifiablePropertyValueModel<Object> filteringPVM = new FilteringModifiablePropertyValueModel<Object>(valueHolder, PredicateTools.true_(), new SetRadioButtonPredicate(buttonValue));
        return new TransformationModifiablePropertyValueModel<Object, Boolean>(filteringPVM, new RadioButtonTransformer(buttonValue), new ReverseRadioButtonTransformer(buttonValue));
    }

    @Override
    public void setSelected(boolean b) {
        if (!b && this.isArmed()) {
            return;
        }
        super.setSelected(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RadioButtonTransformer
    implements Transformer<Object, Boolean> {
        private Object buttonValue;

        public RadioButtonTransformer(Object buttonValue) {
            this.buttonValue = buttonValue;
        }

        @Override
        public Boolean transform(Object value) {
            return value == null ? null : Boolean.valueOf(value.equals(this.buttonValue));
        }

        public String toString() {
            return ObjectTools.toString((Object)this, this.buttonValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReverseRadioButtonTransformer
    implements Transformer<Boolean, Object> {
        private Object buttonValue;

        public ReverseRadioButtonTransformer(Object buttonValue) {
            this.buttonValue = buttonValue;
        }

        @Override
        public Object transform(Boolean value) {
            return value != false ? this.buttonValue : null;
        }

        public String toString() {
            return ObjectTools.toString((Object)this, this.buttonValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetRadioButtonPredicate
    extends CriterionPredicate<Object, Object> {
        public SetRadioButtonPredicate(Object buttonValue) {
            super(buttonValue);
        }

        @Override
        public boolean evaluate(Object value) {
            return value != null && value.equals(this.criterion);
        }
    }
}

