/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationListValueModel<E1, E2>
extends ListValueModelWrapper<E1>
implements ListValueModel<E2> {
    protected Transformer<E1, E2> transformer;
    protected final List<E2> transformedList;

    public TransformationListValueModel(ListValueModel<? extends E1> listHolder, Transformer<E1, E2> transformer) {
        super(listHolder);
        if (transformer == null) {
            throw new NullPointerException();
        }
        this.transformer = transformer;
        this.transformedList = new ArrayList<E2>();
    }

    public TransformationListValueModel(ListValueModel<? extends E1> listHolder) {
        super(listHolder);
        this.transformer = this.buildTransformer();
        this.transformedList = new ArrayList<E2>();
    }

    public TransformationListValueModel(CollectionValueModel<? extends E1> collectionHolder, Transformer<E1, E2> transformer) {
        this(new CollectionListValueModelAdapter<E1>(collectionHolder), transformer);
    }

    public TransformationListValueModel(CollectionValueModel<? extends E1> collectionHolder) {
        this((ListValueModel<? extends E1>)new CollectionListValueModelAdapter<E1>(collectionHolder));
    }

    protected Transformer<E1, E2> buildTransformer() {
        return new DefaultTransformer();
    }

    @Override
    public Iterator<E2> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E2> listIterator() {
        return IteratorTools.readOnly(this.transformedList.listIterator());
    }

    @Override
    public E2 get(int index) {
        return this.transformedList.get(index);
    }

    @Override
    public int size() {
        return this.transformedList.size();
    }

    @Override
    public Object[] toArray() {
        return this.transformedList.toArray();
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.transformedList.addAll(this.transformItems(this.listModel));
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        this.transformedList.clear();
    }

    protected List<E2> transformItems(ListValueModel<? extends E1> lvm) {
        return this.transformItems(lvm, lvm.size());
    }

    protected List<E2> transformItems(ListAddEvent event) {
        return this.transformItems(this.getItems(event), event.getItemsSize());
    }

    protected List<E2> transformItems(ListRemoveEvent event) {
        return this.transformItems(this.getItems(event), event.getItemsSize());
    }

    protected List<E2> transformNewItems(ListReplaceEvent event) {
        return this.transformItems(this.getNewItems(event), event.getItemsSize());
    }

    protected List<E2> transformOldItems(ListReplaceEvent event) {
        return this.transformItems(this.getOldItems(event), event.getItemsSize());
    }

    protected List<E2> transformItems(Iterable<? extends E1> items, int size) {
        ArrayList<E2> result = new ArrayList<E2>(size);
        for (E1 item : items) {
            result.add(this.transformItem(item));
        }
        return result;
    }

    protected E2 transformItem(E1 item) {
        return this.transformer.transform(item);
    }

    protected E2 transformItem_(E1 item) {
        throw new RuntimeException("This method was not overridden.");
    }

    public void setTransformer(Transformer<E1, E2> transformer) {
        if (transformer == null) {
            throw new NullPointerException();
        }
        this.transformer = transformer;
        this.rebuildTransformedList();
    }

    protected void rebuildTransformedList() {
        this.synchronizeList(this.transformItems(this.listModel), this.transformedList, "list values");
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.transformedList);
    }

    @Override
    protected void itemsAdded(ListAddEvent event) {
        this.addItemsToList(event.getIndex(), this.transformItems(event), this.transformedList, "list values");
    }

    @Override
    protected void itemsRemoved(ListRemoveEvent event) {
        this.removeItemsFromList(event.getIndex(), event.getItemsSize(), this.transformedList, "list values");
    }

    @Override
    protected void itemsReplaced(ListReplaceEvent event) {
        this.setItemsInList(event.getIndex(), this.transformNewItems(event), this.transformedList, "list values");
    }

    @Override
    protected void itemsMoved(ListMoveEvent event) {
        this.moveItemsInList(event.getTargetIndex(), event.getSourceIndex(), event.getLength(), this.transformedList, "list values");
    }

    @Override
    protected void listCleared(ListClearEvent event) {
        this.clearList(this.transformedList, "list values");
    }

    @Override
    protected void listChanged(ListChangeEvent event) {
        this.rebuildTransformedList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultTransformer
    extends AbstractTransformer<E1, E2> {
        protected DefaultTransformer() {
        }

        @Override
        public E2 transform_(E1 item) {
            return TransformationListValueModel.this.transformItem_(item);
        }
    }
}

