/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.AbstractSimultaneousIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimultaneousListIterator<E>
extends AbstractSimultaneousIterator<E, ListIterator<E>>
implements ListIterator<List<E>> {
    public <I extends ListIterator<E>> SimultaneousListIterator(Iterable<I> iterators) {
        super(iterators);
    }

    public <I extends ListIterator<E>> SimultaneousListIterator(Iterable<I> iterators, int iteratorsSize) {
        super(iterators, iteratorsSize);
    }

    @Override
    public int nextIndex() {
        return this.iteratorsIsEmpty() ? 0 : ((ListIterator)this.iterators.iterator().next()).nextIndex();
    }

    @Override
    public boolean hasPrevious() {
        if (this.iteratorsIsEmpty()) {
            return false;
        }
        for (ListIterator iterator : this.iterators) {
            if (iterator.hasPrevious()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<E> previous() {
        if (this.iteratorsIsEmpty()) {
            throw new NoSuchElementException();
        }
        ArrayList result = this.buildList();
        for (ListIterator iterator : this.iterators) {
            result.add(iterator.next());
        }
        return result;
    }

    @Override
    public int previousIndex() {
        return this.iteratorsIsEmpty() ? -1 : ((ListIterator)this.iterators.iterator().next()).previousIndex();
    }

    @Override
    public void add(List<E> elements) {
        this.checkElements(elements);
        Iterator<E> addElements = elements.iterator();
        for (ListIterator iterator : this.iterators) {
            iterator.add(addElements.next());
        }
    }

    @Override
    public void set(List<E> elements) {
        this.checkElements(elements);
        Iterator<E> setElements = elements.iterator();
        for (ListIterator iterator : this.iterators) {
            iterator.set(setElements.next());
        }
    }

    private void checkElements(List<E> elements) {
        if (elements.size() != this.iteratorsSize()) {
            throw new IllegalArgumentException("invalid elements: " + elements);
        }
    }

    private int iteratorsSize() {
        return IterableTools.size(this.iterators);
    }
}

