/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.closure.InterruptibleClosure;
import org.eclipse.jpt.common.utility.collection.Queue;
import org.eclipse.jpt.common.utility.collection.Stack;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.closure.DisabledClosure;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterable.ArrayListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.ChainIterable;
import org.eclipse.jpt.common.utility.internal.iterable.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterable.CompositeListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterable.GraphIterable;
import org.eclipse.jpt.common.utility.internal.iterable.LateralIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.LateralListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.ListListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterable.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.PeekableIterable;
import org.eclipse.jpt.common.utility.internal.iterable.QueueIterable;
import org.eclipse.jpt.common.utility.internal.iterable.ReadOnlyCompositeListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.ReadOnlyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.ReadOnlyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SimultaneousIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SimultaneousListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SnapshotCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SnapshotCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.StackIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.SubListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.SuperIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.TreeIterable;
import org.eclipse.jpt.common.utility.internal.iterator.CloneListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IterableTools {
    public static final Transformer ITERATOR_TRANSFORMER = new IteratorTransformer();
    public static final Transformer READ_ONLY_LIST_ITERATOR_TRANSFORMER = new ReadOnlyListIteratorTransformer();

    public static <E> HashBag<E> bag(Iterable<? extends E> iterable) {
        return CollectionTools.bag(iterable);
    }

    public static <E> HashBag<E> bag(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.bag(iterable, iterableSize);
    }

    public static <E> HashBag<E> collection(Iterable<? extends E> iterable) {
        return CollectionTools.collection(iterable);
    }

    public static <E> HashBag<E> collection(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.collection(iterable, iterableSize);
    }

    public static boolean isOrContainsNull(Iterable<?> iterable) {
        return iterable == null || IterableTools.contains(iterable, null);
    }

    public static boolean containsNull(Iterable<?> iterable) {
        return IteratorTools.containsNull(iterable.iterator());
    }

    public static boolean contains(Iterable<?> iterable, Object value) {
        return IteratorTools.contains(iterable.iterator(), value);
    }

    public static int count(Iterable<?> iterable, Object value) {
        return IteratorTools.count(iterable.iterator(), value);
    }

    public static <E> int countFalse(Iterable<? extends E> iterable, Predicate<? super E> predicate) {
        return IteratorTools.countFalse(iterable.iterator(), predicate);
    }

    public static <E> int countTrue(Iterable<? extends E> iterable, Predicate<? super E> predicate) {
        return IteratorTools.countTrue(iterable.iterator(), predicate);
    }

    public static boolean containsAll(Iterable<?> iterable, Collection<?> collection) {
        return IteratorTools.containsAll(iterable.iterator(), collection);
    }

    public static boolean containsAll(Iterable<?> iterable, int iterableSize, Collection<?> collection) {
        return IteratorTools.containsAll(iterable.iterator(), iterableSize, collection);
    }

    public static boolean containsAll(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.containsAll(iterable1.iterator(), iterable2);
    }

    public static boolean containsAll(Iterable<?> iterable1, int iterable1Size, Iterable<?> iterable2) {
        return IteratorTools.containsAll(iterable1.iterator(), iterable1Size, iterable2);
    }

    public static boolean containsAll(Iterable<?> iterable, Iterator<?> iterator) {
        return IteratorTools.containsAll(iterable.iterator(), iterator);
    }

    public static boolean containsAll(Iterable<?> iterable, int iterableSize, Iterator<?> iterator) {
        return IteratorTools.containsAll(iterable.iterator(), iterableSize, iterator);
    }

    public static boolean containsAll(Iterable<?> iterable, Object ... array) {
        return IteratorTools.containsAll(iterable.iterator(), array);
    }

    public static boolean containsAll(Iterable<?> iterable, int iterableSize, Object ... array) {
        return IteratorTools.containsAll(iterable.iterator(), iterableSize, array);
    }

    public static boolean elementsAreDifferent(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.elementsAreDifferent(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean elementsAreEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.elementsAreEqual(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean elementsAreIdentical(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.elementsAreIdentical(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean elementsAreNotIdentical(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.elementsAreNotIdentical(iterable1.iterator(), iterable2.iterator());
    }

    public static <E> void execute(Iterable<? extends E> iterable, Closure<E> closure) {
        IteratorTools.execute(iterable.iterator(), closure);
    }

    public static <E> void execute(Iterable<? extends E> iterable, Closure<E> closure, ExceptionHandler exceptionHandler) {
        IteratorTools.execute(iterable.iterator(), closure, exceptionHandler);
    }

    public static <E> void execute(Iterable<? extends E> iterable, InterruptibleClosure<E> closure) throws InterruptedException {
        IteratorTools.execute(iterable.iterator(), closure);
    }

    public static <E> void execute(Iterable<? extends E> iterable, InterruptibleClosure<E> closure, ExceptionHandler exceptionHandler) throws InterruptedException {
        IteratorTools.execute(iterable.iterator(), closure, exceptionHandler);
    }

    public static <E> E first(Iterable<E> iterable) {
        return IteratorTools.first(iterable.iterator());
    }

    public static <E> E get(Iterable<? extends E> iterable, int index) {
        return IteratorTools.get(iterable.iterator(), index);
    }

    public static int hashCode(Iterable<?> iterable) {
        return iterable == null ? 0 : IteratorTools.hashCode(iterable.iterator());
    }

    public static int indexOf(Iterable<?> iterable, Object value) {
        return IteratorTools.indexOf(iterable.iterator(), value);
    }

    public static int indexOf(Iterable<?> iterable, Object value, int startIndex) {
        return IteratorTools.indexOf(iterable.iterator(), value, startIndex);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return IteratorTools.isEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return IteratorTools.isNotEmpty(iterable.iterator());
    }

    public static <E> E last(Iterable<E> iterable) {
        return IteratorTools.last(iterable.iterator());
    }

    public static int lastIndexOf(Iterable<?> iterable, Object value) {
        return IteratorTools.lastIndexOf(iterable.iterator(), value);
    }

    public static int lastIndexOf(Iterable<?> iterable, Object value, int startIndex) {
        return IteratorTools.lastIndexOf(iterable.iterator(), value, startIndex);
    }

    public static <E> ArrayList<E> list(Iterable<? extends E> iterable) {
        return ListTools.list(iterable);
    }

    public static <E> ArrayList<E> list(Iterable<? extends E> iterable, int iterableSize) {
        return ListTools.list(iterable, iterableSize);
    }

    public static int size(Iterable<?> iterable) {
        return IteratorTools.size(iterable.iterator());
    }

    public static <E extends Comparable<? super E>> Iterable<E> sort(Iterable<? extends E> iterable) {
        return IterableTools.sort(iterable, null);
    }

    public static <E extends Comparable<? super E>> Iterable<E> sort(Iterable<? extends E> iterable, int iterableSize) {
        return IterableTools.sort(iterable, null, iterableSize);
    }

    public static <E> Iterable<E> sort(Iterable<? extends E> iterable, Comparator<? super E> comparator) {
        return ListTools.sort(ListTools.list(iterable), comparator);
    }

    public static <E> Iterable<E> sort(Iterable<? extends E> iterable, Comparator<? super E> comparator, int iterableSize) {
        return ListTools.sort(ListTools.list(iterable, iterableSize), comparator);
    }

    public static Object[] toArray(Iterable<?> iterable) {
        return IterableTools.list(iterable).toArray();
    }

    public static Object[] toArray(Iterable<?> iterable, int iterableSize) {
        return IterableTools.list(iterable, iterableSize).toArray();
    }

    public static <E> E[] toArray(Iterable<? extends E> iterable, E[] array) {
        return IterableTools.list(iterable).toArray(array);
    }

    public static <E> E[] toArray(Iterable<? extends E> iterable, int iterableSize, E[] array) {
        return IterableTools.list(iterable, iterableSize).toArray(array);
    }

    public static <E, I extends Iterable<? extends E>> SimultaneousIterable<E> align(I ... iterables) {
        return IterableTools.align(IterableTools.iterable(iterables), iterables.length);
    }

    public static <E, I extends Iterable<? extends E>> SimultaneousIterable<E> align(Iterable<I> iterables) {
        return new SimultaneousIterable(iterables);
    }

    public static <E, I extends Iterable<? extends E>> SimultaneousIterable<E> align(Iterable<I> iterables, int iterablesSize) {
        return new SimultaneousIterable(iterables, iterablesSize);
    }

    public static <E, I extends ListIterable<E>> SimultaneousListIterable<E> alignList(I ... iterables) {
        return IterableTools.alignList(IterableTools.iterable(iterables), iterables.length);
    }

    public static <E, I extends ListIterable<E>> SimultaneousListIterable<E> alignList(Iterable<I> iterables) {
        return new SimultaneousListIterable(iterables);
    }

    public static <E, I extends ListIterable<E>> SimultaneousListIterable<E> alignList(Iterable<I> iterables, int iterablesSize) {
        return new SimultaneousListIterable(iterables, iterablesSize);
    }

    public static <E1, E2> LateralIterableWrapper<E1, E2> cast(Iterable<E1> iterable) {
        return new LateralIterableWrapper(iterable);
    }

    public static <E1, E2> LateralListIterableWrapper<E1, E2> cast(ListIterable<E1> iterable) {
        return new LateralListIterableWrapper(iterable);
    }

    public static <E1, E2 extends E1> SubIterableWrapper<E1, E2> downCast(Iterable<E1> iterable) {
        return new SubIterableWrapper(iterable);
    }

    public static <E1, E2 extends E1> SubListIterableWrapper<E1, E2> downCast(ListIterable<E1> iterable) {
        return new SubListIterableWrapper(iterable);
    }

    public static <E> SuperIterableWrapper<E> upCast(Iterable<? extends E> iterable) {
        return new SuperIterableWrapper<E>(iterable);
    }

    public static <E> SuperListIterableWrapper<E> upCast(ListIterable<? extends E> iterable) {
        return new SuperListIterableWrapper<E>(iterable);
    }

    public static <E> ChainIterable<E> chainIterable(E first, Transformer<? super E, ? extends E> transformer) {
        return new ChainIterable<E>(first, transformer);
    }

    public static <E> LiveCloneIterable<E> cloneLive(Collection<? extends E> collection) {
        return IterableTools.cloneLive(collection, DisabledClosure.instance());
    }

    public static <E> LiveCloneIterable<E> cloneLive(Collection<? extends E> collection, Closure<? super E> removeClosure) {
        return new LiveCloneIterable<E>(collection, removeClosure);
    }

    public static <E> LiveCloneListIterable<E> cloneLive(List<? extends E> list) {
        return IterableTools.cloneLive(list, CloneListIterator.Adapter.ReadOnly.instance());
    }

    public static <E> LiveCloneListIterable<E> cloneLive(List<? extends E> list, CloneListIterator.Adapter<E> adapter) {
        return new LiveCloneListIterable<E>(list, adapter);
    }

    public static <E> SnapshotCloneIterable<E> cloneSnapshot(Collection<? extends E> collection) {
        return IterableTools.cloneSnapshot(collection, DisabledClosure.instance());
    }

    public static <E> SnapshotCloneIterable<E> cloneSnapshot(Collection<? extends E> collection, Closure<? super E> removeClosure) {
        return new SnapshotCloneIterable<E>(collection, removeClosure);
    }

    public static <E> SnapshotCloneListIterable<E> cloneSnapshot(List<? extends E> list) {
        return IterableTools.cloneSnapshot(list, CloneListIterator.Adapter.ReadOnly.instance());
    }

    public static <E> SnapshotCloneListIterable<E> cloneSnapshot(List<? extends E> list, CloneListIterator.Adapter<E> adapter) {
        return new SnapshotCloneListIterable<E>(list, adapter);
    }

    public static <E> CompositeIterable<E> add(Iterable<? extends E> iterable, E object) {
        return IterableTools.concatenate(iterable, IterableTools.singletonIterable(object));
    }

    public static <E> CompositeIterable<E> insert(E object, Iterable<? extends E> iterable) {
        return IterableTools.concatenate(IterableTools.singletonIterable(object), iterable);
    }

    public static <E> CompositeIterable<E> concatenate(Iterable<? extends E> ... iterables) {
        return IterableTools.concatenate(Arrays.asList(iterables));
    }

    public static <E> CompositeIterable<E> concatenate(Iterable<? extends Iterable<? extends E>> iterables) {
        return new CompositeIterable(iterables);
    }

    public static <P, E> CompositeIterable<E> children(Iterable<? extends P> parents, Transformer<? super P, ? extends Iterable<? extends E>> childrenTransformer) {
        return IterableTools.concatenate(IterableTools.transform(parents, childrenTransformer));
    }

    public static <E> CompositeListIterable<E> add(ListIterable<E> iterable, E object) {
        return IterableTools.concatenate(new ListIterable[]{iterable, IterableTools.singletonListIterable(object)});
    }

    public static <E> CompositeListIterable<E> insert(E object, ListIterable<E> iterable) {
        return IterableTools.concatenate(new ListIterable[]{IterableTools.singletonListIterable(object), iterable});
    }

    public static <E> CompositeListIterable<E> concatenate(ListIterable<E> ... iterables) {
        return IterableTools.concatenate(IterableTools.listIterable(iterables));
    }

    public static <E> CompositeListIterable<E> concatenate(ListIterable<? extends ListIterable<E>> iterables) {
        return new CompositeListIterable(iterables);
    }

    public static <P, E> CompositeListIterable<E> children(ListIterable<? extends P> parents, Transformer<? super P, ? extends ListIterable<E>> childrenTransformer) {
        return IterableTools.concatenate(IterableTools.transform(parents, childrenTransformer));
    }

    public static <E> ReadOnlyCompositeListIterable<E> addReadOnly(ListIterable<? extends E> iterable, E object) {
        return IterableTools.concatenateReadOnly(iterable, IterableTools.singletonListIterable(object));
    }

    public static <E> ReadOnlyCompositeListIterable<E> insertReadOnly(E object, ListIterable<? extends E> iterable) {
        return IterableTools.concatenateReadOnly(IterableTools.singletonListIterable(object), iterable);
    }

    public static <E> ReadOnlyCompositeListIterable<E> concatenateReadOnly(ListIterable<? extends E> ... iterables) {
        return IterableTools.concatenateReadOnly(IterableTools.listIterable(iterables));
    }

    public static <E> ReadOnlyCompositeListIterable<E> concatenateReadOnly(ListIterable<? extends ListIterable<? extends E>> iterables) {
        return new ReadOnlyCompositeListIterable(iterables);
    }

    public static <P, E> ReadOnlyCompositeListIterable<E> readOnlyChildren(ListIterable<? extends P> parents, Transformer<? super P, ? extends ListIterable<? extends E>> childrenTransformer) {
        return IterableTools.concatenateReadOnly(IterableTools.transform(parents, childrenTransformer));
    }

    public static <E> Iterable<E> emptyIterable() {
        return EmptyIterable.instance();
    }

    public static <E> ListIterable<E> emptyListIterable() {
        return EmptyListIterable.instance();
    }

    public static <E> FilteringIterable<E> filter(Iterable<? extends E> iterable, Predicate<? super E> predicate) {
        return new FilteringIterable<E>(iterable, predicate);
    }

    public static <E> FilteringIterable<E> removeNulls(Iterable<? extends E> iterable) {
        return IterableTools.filter(iterable, PredicateTools.isNotNull());
    }

    public static <E> GraphIterable<E> graphIterable(E root, Transformer<? super E, ? extends Iterable<? extends E>> transformer) {
        return IterableTools.graphIterable(IterableTools.singletonIterable(root), transformer);
    }

    public static <E> GraphIterable<E> graphIterable(E[] roots, Transformer<? super E, ? extends Iterable<? extends E>> transformer) {
        return IterableTools.graphIterable(Arrays.asList(roots), transformer);
    }

    public static <E> GraphIterable<E> graphIterable(Iterable<? extends E> roots, Transformer<? super E, ? extends Iterable<? extends E>> transformer) {
        return new GraphIterable<E>(roots, transformer);
    }

    public static <E> ArrayIterable<E> iterable(E ... array) {
        return IterableTools.iterable(array, 0);
    }

    public static <E> ArrayIterable<E> iterable(E[] array, int start) {
        return IterableTools.iterable(array, start, array.length);
    }

    public static <E> ArrayIterable<E> iterable(E[] array, int start, int end) {
        return new ArrayIterable<E>(array, start, end);
    }

    public static <E> QueueIterable<E> iterable(Queue<? extends E> queue) {
        return new QueueIterable<E>(queue);
    }

    public static <E> StackIterable<E> iterable(Stack<? extends E> stack) {
        return new StackIterable<E>(stack);
    }

    public static <E> ArrayListIterable<E> listIterable(E ... array) {
        return IterableTools.listIterable(array, 0);
    }

    public static <E> ArrayListIterable<E> listIterable(E[] array, int start) {
        return IterableTools.listIterable(array, start, array.length);
    }

    public static <E> ArrayListIterable<E> listIterable(E[] array, int start, int end) {
        return new ArrayListIterable<E>(array, start, end);
    }

    public static <E> ListListIterable<E> listIterable(List<E> list) {
        return new ListListIterable<E>(list);
    }

    public static <E> PeekableIterable<E> peekable(Iterable<? extends E> iterable) {
        return new PeekableIterable<E>(iterable);
    }

    public static <E> ReadOnlyIterable<E> readOnly(Iterable<? extends E> iterable) {
        return new ReadOnlyIterable<E>(iterable);
    }

    public static <E> ReadOnlyListIterable<E> readOnly(ListIterable<? extends E> iterable) {
        return new ReadOnlyListIterable<E>(iterable);
    }

    public static <E> SingleElementIterable<E> singletonIterable(E value) {
        return new SingleElementIterable<E>(value);
    }

    public static <E> SingleElementListIterable<E> singletonListIterable(E value) {
        return new SingleElementListIterable<E>(value);
    }

    public static <E1, E2> TransformationIterable<E1, E2> transform(Iterable<? extends E1> iterable, Transformer<? super E1, ? extends E2> transformer) {
        return new TransformationIterable<E1, E2>(iterable, transformer);
    }

    public static <E1, E2, T extends E1> TransformationListIterable<E1, E2> transform(ListIterable<T> iterable, Transformer<? super E1, ? extends E2> transformer) {
        return new TransformationListIterable<E1, E2>(iterable, transformer);
    }

    public static <E> TreeIterable<E> treeIterable(E root, Transformer<? super E, ? extends Iterable<? extends E>> transformer) {
        return IterableTools.treeIterable(IterableTools.singletonIterable(root), transformer);
    }

    public static <E> TreeIterable<E> treeIterable(E[] roots, Transformer<? super E, ? extends Iterable<? extends E>> transformer) {
        return IterableTools.treeIterable(IterableTools.iterable(roots), transformer);
    }

    public static <E> TreeIterable<E> treeIterable(Iterable<? extends E> roots, Transformer<? super E, ? extends Iterable<? extends E>> transformer) {
        return new TreeIterable<E>(roots, transformer);
    }

    public static <E> Transformer<Iterable<? extends E>, Iterator<E>> iteratorTransformer() {
        return ITERATOR_TRANSFORMER;
    }

    public static <E> Transformer<ListIterable<E>, ListIterator<E>> listIteratorTransformer() {
        return ListIterable.TRANSFORMER;
    }

    public static <E> Transformer<ListIterable<? extends E>, ListIterator<? extends E>> readOnlyListIteratorTransformer() {
        return READ_ONLY_LIST_ITERATOR_TRANSFORMER;
    }

    private IterableTools() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IteratorTransformer<E>
    implements Transformer<Iterable<? extends E>, Iterator<E>> {
        @Override
        public Iterator<E> transform(Iterable<? extends E> iterable) {
            return iterable.iterator();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReadOnlyListIteratorTransformer<E>
    implements Transformer<ListIterable<? extends E>, ListIterator<? extends E>> {
        @Override
        public ListIterator<? extends E> transform(ListIterable<? extends E> iterable) {
            return IteratorTools.readOnly(iterable.iterator());
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

