/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.collection;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.collection.Queue;
import org.eclipse.jpt.common.utility.collection.Stack;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.collection.LinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedQueue<E>
implements Queue<E>,
Serializable {
    private final Queue<E> queue;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedQueue(Queue<E> queue, Object mutex) {
        if (queue == null || mutex == null) {
            throw new NullPointerException();
        }
        this.queue = queue;
        this.mutex = mutex;
    }

    public SynchronizedQueue(Queue<E> queue) {
        if (queue == null) {
            throw new NullPointerException();
        }
        this.queue = queue;
        this.mutex = this;
    }

    public SynchronizedQueue(Object mutex) {
        this(new LinkedQueue(), mutex);
    }

    public SynchronizedQueue() {
        this(new LinkedQueue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(E element) {
        Object object = this.mutex;
        synchronized (object) {
            this.enqueue_(element);
        }
    }

    private void enqueue_(E element) {
        this.queue.enqueue(element);
        this.mutex.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E dequeue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.dequeue_();
        }
    }

    private E dequeue_() {
        E element = this.queue.dequeue();
        this.mutex.notifyAll();
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmptyIs(boolean empty) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(empty);
        }
    }

    private void waitUntilEmptyIs_(boolean empty) throws InterruptedException {
        while (this.queue.isEmpty() != empty) {
            this.mutex.wait();
        }
    }

    public void waitUntilEmpty() throws InterruptedException {
        this.waitUntilEmptyIs(true);
    }

    public void waitUntilNotEmpty() throws InterruptedException {
        this.waitUntilEmptyIs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToEnqueue(E element) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(true);
            this.enqueue_(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitToDequeue() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilEmptyIs_(false);
            return this.dequeue_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEmptyIs(boolean empty, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilEmptyIs_(empty, timeout);
        }
    }

    private boolean waitUntilEmptyIs_(boolean empty, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilEmptyIs_(empty);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (this.queue.isEmpty() != empty && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.queue.isEmpty() == empty;
    }

    public boolean waitUntilEmpty(long timeout) throws InterruptedException {
        return this.waitUntilEmptyIs(true, timeout);
    }

    public boolean waitUntilNotEmpty(long timeout) throws InterruptedException {
        return this.waitUntilEmptyIs(false, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToEnqueue(E element, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilEmptyIs_(true, timeout);
            if (success) {
                this.enqueue_(element);
            }
            return success;
        }
    }

    public Object waitToDequeue(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilEmptyIs_(false, timeout);
            if (success) {
                return this.dequeue_();
            }
            throw new NoSuchElementException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    public void enqueueAll(Iterable<? extends E> iterable) {
        this.enqueueAll(iterable.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueAll(Iterator<? extends E> iterator) {
        Object object = this.mutex;
        synchronized (object) {
            this.enqueueAll_(iterator);
        }
    }

    private void enqueueAll_(Iterator<? extends E> iterator) {
        while (iterator.hasNext()) {
            this.enqueue_(iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueAll(E ... array) {
        Object object = this.mutex;
        synchronized (object) {
            this.enqueueAll_(array);
        }
    }

    private void enqueueAll_(E[] array) {
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            this.enqueue_(element);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueAll(Stack<? extends E> stack) {
        Object object = this.mutex;
        synchronized (object) {
            this.enqueueAll_(stack);
        }
    }

    private void enqueueAll_(Stack<? extends E> stack) {
        while (!stack.isEmpty()) {
            this.enqueue_(stack.pop());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueAll(Queue<? extends E> q) {
        Object object = this.mutex;
        synchronized (object) {
            this.enqueueAll_(q);
        }
    }

    private void enqueueAll_(Queue<? extends E> q) {
        while (!q.isEmpty()) {
            this.enqueue_(q.dequeue());
        }
    }

    public Iterable<E> drain() {
        return this.drainTo((Queue)((Object)new ArrayList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends Collection<? super E>> C drainTo(C c) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTo_((Queue)((Object)c));
        }
    }

    private <C extends Collection<? super E>> C drainTo_(C c) {
        boolean changed = false;
        while (!this.queue.isEmpty()) {
            c.add(this.queue.dequeue());
            changed = true;
        }
        if (changed) {
            this.mutex.notifyAll();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends Stack<? super E>> S drainTo(S stack) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTo_((Queue)((Object)stack));
        }
    }

    private <S extends Stack<? super E>> S drainTo_(S stack) {
        boolean changed = false;
        while (!this.queue.isEmpty()) {
            stack.push(this.queue.dequeue());
            changed = true;
        }
        if (changed) {
            this.mutex.notifyAll();
        }
        return stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Q extends Queue<? super E>> Q drainTo(Q q) {
        Object object = this.mutex;
        synchronized (object) {
            return this.drainTo_(q);
        }
    }

    private <Q extends Queue<? super E>> Q drainTo_(Q q) {
        boolean changed = false;
        while (!this.queue.isEmpty()) {
            q.enqueue(this.queue.dequeue());
            changed = true;
        }
        if (changed) {
            this.mutex.notifyAll();
        }
        return q;
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            s.defaultWriteObject();
        }
    }
}

