/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashSet<E>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    private transient IdentityHashMap<E, Object> map;
    private static final Object PRESENT = new Object();
    static final long serialVersionUID = 1L;

    public IdentityHashSet() {
        this.map = new IdentityHashMap();
    }

    public IdentityHashSet(int expectedMaxSize) {
        this.map = new IdentityHashMap(expectedMaxSize);
    }

    public IdentityHashSet(Collection<? extends E> c) {
        this.map = new IdentityHashMap((int)((double)(1 + c.size()) * 1.1));
        this.addAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object e : c) {
            modified |= this.remove(e);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (!(c instanceof IdentityHashSet)) {
            c = new IdentityHashSet(c);
        }
        return super.retainAll(c);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public IdentityHashSet<E> clone() {
        try {
            IdentityHashSet clone = (IdentityHashSet)super.clone();
            clone.map = (IdentityHashMap)this.map.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IdentityHashSet) {
            IdentityHashSet s = (IdentityHashSet)o;
            return s.map.equals(this.map);
        }
        return this.equals_(o);
    }

    private boolean equals_(Object o) {
        return o instanceof Set && new HashSet(this).equals(o);
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (E o : this) {
            h += System.identityHashCode(o);
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.map.size());
        for (E e : this.map.keySet()) {
            s.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.map = new IdentityHashMap(size);
        int i = 0;
        while (i < size) {
            Object element = s.readObject();
            this.map.put(element, PRESENT);
            ++i;
        }
    }
}

