/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.quickaccess;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jboss.tools.forge.ui.internal.ext.quickaccess.QuickAccessElement;

public abstract class QuickAccessProvider {
    private List<QuickAccessElement> sortedElements;

    public abstract String getId();

    public abstract String getName();

    public abstract ImageDescriptor getImageDescriptor();

    public abstract List<QuickAccessElement> getElements();

    public List<QuickAccessElement> getElementsSorted() {
        if (this.sortedElements == null) {
            this.sortedElements = this.getElements();
            Collections.sort(this.sortedElements, new Comparator<QuickAccessElement>(){

                @Override
                public int compare(QuickAccessElement e1, QuickAccessElement e2) {
                    return e1.getLabel().compareToIgnoreCase(e2.getLabel());
                }
            });
        }
        return this.sortedElements;
    }

    public abstract QuickAccessElement getElementForId(String var1);

    public boolean isAlwaysPresent() {
        return false;
    }

    public void reset() {
        this.sortedElements = null;
        this.doReset();
    }

    protected abstract void doReset();
}

