/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.provider;

import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.jboss.forge.addon.ui.UIDesktop;
import org.jboss.forge.addon.ui.UIProvider;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.tools.forge.core.furnace.FurnaceRuntime;
import org.jboss.tools.forge.ui.internal.ext.provider.ForgeUIDesktop;

public class ForgeUIProvider
implements UIProvider,
UIOutput {
    private MessageConsole forgeConsole;
    private PrintStream forgeConsoleOutputStream;
    private PrintStream forgeConsoleErrorStream;
    private Color red;

    private MessageConsole getForgeConsole() {
        if (this.forgeConsole == null) {
            this.forgeConsole = this.findForgeConsole();
        }
        return this.forgeConsole;
    }

    public String getName() {
        return "Forge " + FurnaceRuntime.INSTANCE.getVersion() + " Console";
    }

    public boolean isEmbedded() {
        return true;
    }

    private MessageConsole findForgeConsole() {
        ConsolePlugin consolePlugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = consolePlugin.getConsoleManager();
        IConsole[] allConsoles = consoleManager.getConsoles();
        int i = 0;
        while (i < allConsoles.length) {
            if (this.getName().equals(allConsoles[i].getName())) {
                return (MessageConsole)allConsoles[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(this.getName(), null);
        consoleManager.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public boolean isGUI() {
        return true;
    }

    public UIOutput getOutput() {
        return this;
    }

    public PrintStream out() {
        if (this.forgeConsoleOutputStream == null) {
            this.forgeConsoleOutputStream = new PrintStream((OutputStream)this.getForgeConsole().newMessageStream(), true);
        }
        return this.forgeConsoleOutputStream;
    }

    public PrintStream err() {
        if (this.forgeConsoleErrorStream == null) {
            MessageConsoleStream messageConsoleStream = this.getForgeConsole().newMessageStream();
            messageConsoleStream.setColor(this.getRed());
            this.forgeConsoleErrorStream = new PrintStream((OutputStream)messageConsoleStream, true);
        }
        return this.forgeConsoleErrorStream;
    }

    private Color getRed() {
        if (this.red == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ForgeUIProvider.this.red = Display.getDefault().getSystemColor(3);
                }
            });
        }
        return this.red;
    }

    public void error(PrintStream writer, String message) {
        writer.print("[ERROR] ");
        writer.println(message);
    }

    public void success(PrintStream writer, String message) {
        writer.print("[SUCCESS] ");
        writer.println(message);
    }

    public void info(PrintStream writer, String message) {
        writer.print("[INFO] ");
        writer.println(message);
    }

    public void warn(PrintStream writer, String message) {
        writer.print("[WARNING] ");
        writer.println(message);
    }

    public UIDesktop getDesktop() {
        return new ForgeUIDesktop();
    }
}

