/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.control;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.ext.control.ControlBuilder;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizardPage;

public class SpinnerControlBuilder
extends ControlBuilder<Spinner> {
    @Override
    public Spinner build(final ForgeWizardPage page, InputComponent<?, ?> input, final String inputName, Composite container) {
        Label label = new Label(container, 0);
        label.setText(this.getMnemonicLabel(input, true));
        final Spinner txt = new Spinner(container, 2048);
        txt.setMinimum(Integer.MIN_VALUE);
        txt.setMaximum(Integer.MAX_VALUE);
        txt.setLayoutData((Object)new GridData(768));
        txt.setToolTipText(input.getDescription());
        ConverterFactory converterFactory = FurnaceService.INSTANCE.getConverterFactory();
        if (converterFactory != null) {
            Converter converter = converterFactory.getConverter(input.getValueType(), Integer.class);
            Integer value = (Integer)converter.convert(InputComponents.getValueFor(input));
            txt.setSelection(value == null ? 0 : value);
        }
        txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = txt.getText();
                CommandController controller = page.getController();
                try {
                    int value = Integer.parseInt(text);
                    try {
                        controller.setValueFor(inputName, (Object)value);
                    }
                    catch (Exception ex) {
                        ForgeUIPlugin.log(ex);
                        controller.setValueFor(inputName, null);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        Label dummy = new Label(container, 0);
        dummy.setText("");
        return txt;
    }

    @Override
    public void setEnabled(Spinner control, boolean enabled) {
        control.setEnabled(enabled);
    }

    @Override
    protected Class<?> getProducedType() {
        return Integer.class;
    }

    @Override
    protected String getSupportedInputType() {
        return "org.jboss.forge.inputType.DEFAULT";
    }

    @Override
    protected Class<?>[] getSupportedInputComponentTypes() {
        return new Class[]{UIInput.class};
    }

    @Override
    public Control[] getModifiableControlsFor(Spinner control) {
        return new Control[]{control};
    }
}

