/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.context;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.ui.UIProvider;
import org.jboss.forge.addon.ui.context.AbstractUIContext;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextListener;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.ext.context.UISelectionImpl;

public class UIContextImpl
extends AbstractUIContext {
    private final UISelectionImpl<?> currentSelection;
    private final UIProvider provider;

    public UIContextImpl(UIProvider provider, IStructuredSelection selection) {
        this.provider = provider;
        List selectedElements = selection == null ? Collections.EMPTY_LIST : selection.toList();
        LinkedList<Object> result = new LinkedList<Object>();
        ConverterFactory converterFactory = FurnaceService.INSTANCE.getConverterFactory();
        Converter converter = converterFactory.getConverter(File.class, Resource.class);
        if (selectedElements.isEmpty()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            File workspaceDirectory = workspace.getRoot().getLocation().toFile();
            Object convertedObj = converter.convert((Object)workspaceDirectory);
            result.add(Proxies.unwrap((Object)convertedObj));
        } else {
            for (Object object : selectedElements) {
                if (object instanceof Resource) {
                    result.add((Resource)object);
                    continue;
                }
                if (object instanceof File) {
                    File file = (File)object;
                    result.add(Proxies.unwrap((Object)converter.convert((Object)file)));
                    continue;
                }
                if (object instanceof IResource) {
                    IPath location = ((IResource)object).getLocation();
                    if (location == null) continue;
                    File file = location.toFile();
                    result.add(Proxies.unwrap((Object)converter.convert((Object)file)));
                    continue;
                }
                if (!(object instanceof IJavaElement)) continue;
                try {
                    IPath location;
                    IJavaElement javaElem = (IJavaElement)object;
                    IResource correspondingResource = javaElem.getCorrespondingResource();
                    if (correspondingResource == null || (location = correspondingResource.getLocation()) == null) continue;
                    File file = location.toFile();
                    result.add(Proxies.unwrap((Object)converter.convert((Object)file)));
                }
                catch (JavaModelException e) {
                    ForgeUIPlugin.log(e);
                }
            }
        }
        this.currentSelection = new UISelectionImpl(result, selection);
        this.initialize();
    }

    public UISelectionImpl<?> getInitialSelection() {
        return this.currentSelection;
    }

    public void initialize() {
        Imported services = FurnaceService.INSTANCE.lookupImported(UIContextListener.class);
        if (services != null) {
            for (UIContextListener listener : services) {
                try {
                    listener.contextInitialized((UIContext)this);
                }
                catch (Exception e) {
                    ForgeUIPlugin.log(e);
                }
            }
        }
    }

    public void close() {
        super.close();
        Imported services = FurnaceService.INSTANCE.lookupImported(UIContextListener.class);
        if (services != null) {
            for (UIContextListener listener : services) {
                try {
                    listener.contextDestroyed((UIContext)this);
                }
                catch (Exception e) {
                    ForgeUIPlugin.log(e);
                }
            }
        }
    }

    public UIProvider getProvider() {
        return this.provider;
    }
}

