/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.commands;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.commands.ForgeCommandPostProcessor;
import org.jboss.tools.forge.ui.internal.commands.ForgeCommandPostProcessorHelper;

public class PersistencePostProcessor
implements ForgeCommandPostProcessor {
    @Override
    public void postProcess(Map<String, String> commandDetails) {
        String command = commandDetails.get("ec");
        if (command.indexOf("setup") != -1) {
            this.postProcessPersistenceSetup(commandDetails);
        }
    }

    private void postProcessPersistenceSetup(Map<String, String> commandDetails) {
        IProject project = ForgeCommandPostProcessorHelper.getProject(commandDetails.get("cpn"));
        if (project == null) {
            return;
        }
        try {
            IViewPart packageExplorer;
            IFile file = project.getFile("/src/main/resources/META-INF/persistence.xml");
            if (file == null) {
                return;
            }
            IFile objectToSelect = file;
            IWorkbenchPage workbenchPage = ForgeCommandPostProcessorHelper.getActiveWorkbenchPage();
            IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)file, (boolean)false);
            IViewPart projectExplorer = workbenchPage.findView("org.eclipse.ui.navigator.ProjectExplorer");
            if (projectExplorer != null && projectExplorer instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)projectExplorer).selectReveal((ISelection)new StructuredSelection((Object)objectToSelect));
            }
            if ((packageExplorer = workbenchPage.findView("org.eclipse.jdt.ui.PackageExplorer")) == null && projectExplorer == null) {
                packageExplorer = workbenchPage.showView("org.eclipse.jdt.ui.PackageExplorer");
            }
            if (packageExplorer != null && packageExplorer instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)packageExplorer).selectReveal((ISelection)new StructuredSelection((Object)objectToSelect));
            }
        }
        catch (PartInitException e) {
            ForgeUIPlugin.log(e);
        }
    }
}

