/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaWorkbenchAdapter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.ui.JavaScriptElementImageDescriptor;

public class JavaElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private ImageDescriptorRegistry fRegistry;

    public JavaElementImageProvider() {
        ISharedImages images = JavaScriptPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = images.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
        this.fRegistry = null;
    }

    public Image getImageLabel(Object element, int flags) {
        return this.getImageLabel(this.computeDescriptor(element, flags));
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = JavaScriptPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private ImageDescriptor computeDescriptor(Object element, int flags) {
        if (element instanceof IJavaScriptElement) {
            return this.getJavaImageDescriptor((IJavaScriptElement)element, flags);
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            if (JavaScriptCore.isJavaScriptLikeFileName((String)file.getName())) {
                return this.getCUResourceImageDescriptor(file, flags);
            }
            return this.getWorkbenchImageDescriptor((IAdaptable)file, flags);
        }
        if (element instanceof IAdaptable) {
            return this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        return null;
    }

    private static boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    private static boolean useLightIcons(int flags) {
        return (flags & 4) != 0;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile file, int flags) {
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new JavaScriptElementImageDescriptor(JavaPluginImages.DESC_OBJS_CUNIT_RESOURCE, 0, size);
    }

    public ImageDescriptor getJavaImageDescriptor(IJavaScriptElement element, int flags) {
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        ImageDescriptor baseDesc = this.getBaseImageDescriptor(element, flags);
        if (baseDesc != null) {
            int adornmentFlags = this.computeJavaAdornmentFlags(element, flags);
            return new JavaScriptElementImageDescriptor(baseDesc, adornmentFlags, size);
        }
        return new JavaScriptElementImageDescriptor(JavaPluginImages.DESC_OBJS_GHOST, 0, size);
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new JavaScriptElementImageDescriptor(descriptor, 0, size);
    }

    public ImageDescriptor getBaseImageDescriptor(IJavaScriptElement element, int renderFlags) {
        try {
            ImageDescriptor imageDescriptor;
            switch (element.getElementType()) {
                case 10: {
                    return JavaPluginImages.DESC_MISC_PRIVATE;
                }
                case 9: {
                    IFunction method = (IFunction)element;
                    method.getDeclaringType();
                    int flags = method.getFlags();
                    return JavaElementImageProvider.getMethodImageDescriptor(false, flags);
                }
                case 8: {
                    IMember member = (IMember)element;
                    member.getDeclaringType();
                    return JavaElementImageProvider.getFieldImageDescriptor(false, member.getFlags());
                }
                case 14: {
                    return JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE;
                }
                case 13: {
                    return JavaPluginImages.DESC_OBJS_IMPDECL;
                }
                case 12: {
                    return JavaPluginImages.DESC_OBJS_IMPCONT;
                }
                case 7: {
                    IType type = (IType)element;
                    IType declType = type.getDeclaringType();
                    boolean isInner = declType != null;
                    return JavaElementImageProvider.getTypeImageDescriptor(isInner, false, type.getFlags(), JavaElementImageProvider.useLightIcons(renderFlags));
                }
                case 3: {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    if (root.isArchive()) {
                        IPath attach = root.getSourceAttachmentPath();
                        if (root.isExternal()) {
                            if (attach == null) {
                                return JavaPluginImages.DESC_OBJS_EXTJAR;
                            }
                            return JavaPluginImages.DESC_OBJS_EXTJAR_WSRC;
                        }
                        if (attach == null) {
                            return JavaPluginImages.DESC_OBJS_JAR;
                        }
                        return JavaPluginImages.DESC_OBJS_JAR_WSRC;
                    }
                    return JavaPluginImages.DESC_OBJS_PACKFRAG_ROOT;
                }
                case 4: {
                    return this.getPackageFragmentIcon(element, renderFlags);
                }
                case 5: {
                    return JavaPluginImages.DESC_OBJS_CUNIT;
                }
                case 6: {
                    return JavaPluginImages.DESC_OBJS_CFILE;
                }
                case 2: {
                    IJavaScriptProject jp = (IJavaScriptProject)element;
                    if (jp.getProject().isOpen()) {
                        ImageDescriptor result;
                        IProject project = jp.getProject();
                        IWorkbenchAdapter adapter = (IWorkbenchAdapter)project.getAdapter(IWorkbenchAdapter.class);
                        if (adapter != null && (result = adapter.getImageDescriptor((Object)project)) != null) {
                            return result;
                        }
                        return DESC_OBJ_PROJECT;
                    }
                    return DESC_OBJ_PROJECT_CLOSED;
                }
                case 1: {
                    return JavaPluginImages.DESC_OBJS_JAVA_MODEL;
                }
            }
            IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)element.getAdapter(IWorkbenchAdapter.class);
            if (wbAdapter != null && !(wbAdapter instanceof JavaWorkbenchAdapter) && (imageDescriptor = wbAdapter.getImageDescriptor((Object)element)) != null) {
                return imageDescriptor;
            }
            return JavaPluginImages.DESC_OBJS_GHOST;
        }
        catch (JavaScriptModelException e) {
            if (e.isDoesNotExist()) {
                return JavaPluginImages.DESC_OBJS_UNKNOWN;
            }
            JavaScriptPlugin.log(e);
            return JavaPluginImages.DESC_OBJS_GHOST;
        }
    }

    protected ImageDescriptor getPackageFragmentIcon(IJavaScriptElement element, int renderFlags) throws JavaScriptModelException {
        return JavaPluginImages.DESC_OBJS_PACKAGE;
    }

    public void dispose() {
    }

    private int computeJavaAdornmentFlags(IJavaScriptElement element, int renderFlags) {
        int flags = 0;
        if (JavaElementImageProvider.showOverlayIcons(renderFlags) && element instanceof IMember) {
            try {
                int modifiers;
                IMember member = (IMember)element;
                if (element.getElementType() == 9 && ((IFunction)element).isConstructor()) {
                    flags |= 0x200;
                }
                if (Flags.isAbstract((int)(modifiers = member.getFlags())) && JavaElementImageProvider.confirmAbstract(member)) {
                    flags |= 1;
                }
                if (Flags.isStatic((int)modifiers)) {
                    flags |= 8;
                }
                if (Flags.isDeprecated((int)modifiers)) {
                    flags |= 0x400;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        return flags;
    }

    private static boolean confirmAbstract(IMember element) throws JavaScriptModelException {
        if (element.getElementType() == 7) {
            return true;
        }
        return true;
    }

    public static ImageDescriptor getMethodImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaPluginImages.DESC_MISC_PUBLIC;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_MISC_PROTECTED;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_MISC_PRIVATE;
        }
        return JavaPluginImages.DESC_MISC_PUBLIC;
    }

    public static ImageDescriptor getFieldImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaPluginImages.DESC_FIELD_PUBLIC;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_FIELD_PROTECTED;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_FIELD_PRIVATE;
        }
        return JavaPluginImages.DESC_FIELD_PUBLIC;
    }

    public static ImageDescriptor getTypeImageDescriptor(boolean isInner, boolean isInInterfaceOrAnnotation, int flags, boolean useLightIcons) {
        if (useLightIcons) {
            return JavaPluginImages.DESC_OBJS_CLASSALT;
        }
        if (isInner) {
            return JavaElementImageProvider.getInnerClassImageDescriptor(isInInterfaceOrAnnotation, flags);
        }
        return JavaElementImageProvider.getClassImageDescriptor(flags);
    }

    public static Image getDecoratedImage(ImageDescriptor baseImage, int adornments, Point size) {
        return JavaScriptPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new JavaScriptElementImageDescriptor(baseImage, adornments, size));
    }

    private static ImageDescriptor getClassImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_CLASS;
        }
        return JavaPluginImages.DESC_OBJS_CLASS_DEFAULT;
    }

    private static ImageDescriptor getInnerClassImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PUBLIC;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PRIVATE;
        }
        return JavaPluginImages.DESC_OBJS_INNER_CLASS_DEFAULT;
    }
}

