/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.local;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ProcessInformationStore {
    private static ProcessInformationStore singleton;
    protected Map<Integer, String> processInformationStore = new HashMap<Integer, String>();

    public static synchronized ProcessInformationStore getDefault() {
        if (singleton == null) {
            singleton = new ProcessInformationStore();
        }
        return singleton;
    }

    public synchronized String queryProcessInformation(int pid) {
        if (!this.processInformationStore.containsKey(pid)) {
            this.refreshProcessInformationStoreAsync();
        }
        return this.processInformationStore.get(pid);
    }

    public void refreshProcessInformationStore() {
        this.refreshProcessInformationStore((IProgressMonitor)new NullProgressMonitor());
    }

    public void refreshProcessInformationStore(IProgressMonitor monitor) {
        this.setProcessStore(this.loadProcessStore(monitor));
    }

    private synchronized void setProcessStore(Map<Integer, String> store) {
        if (store != null) {
            this.processInformationStore = store;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<Integer, String> loadProcessStore(IProgressMonitor monitor) {
        HashMap<Integer, String> tmp = new HashMap<Integer, String>();
        String javaHome = System.getProperty("java.home");
        Path jHomePath = new Path(javaHome);
        File jHome = jHomePath.toFile();
        File jps = null;
        if (jHome.getName().equalsIgnoreCase("jre")) {
            jps = jHomePath.removeLastSegments(1).append("bin").append("jps").toFile();
        }
        if (jps == null || !jps.exists()) {
            jps = jHomePath.append("bin").append("jps").toFile();
        }
        BufferedReader br = null;
        String[] cmd = new String[]{jps.getAbsolutePath(), "-v"};
        Process p = Runtime.getRuntime().exec(cmd);
        br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = "";
        while (!monitor.isCanceled() && (line = br.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, " ");
            int pid = -1;
            if (st.hasMoreElements()) {
                String sVal = st.nextToken();
                try {
                    pid = Integer.parseInt(sVal);
                }
                catch (NumberFormatException numberFormatException) {
                    pid = -1;
                }
            }
            if (pid == -1) continue;
            tmp.put(pid, line);
        }
        HashMap<Integer, String> hashMap = tmp;
        if (br == null) return hashMap;
        try {
            br.close();
            return hashMap;
        }
        catch (Exception exception) {}
        return hashMap;
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                if (br == null) return null;
            }
            catch (Throwable throwable) {
                if (br == null) throw throwable;
                try {
                    br.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                br.close();
                return null;
            }
            catch (Exception exception) {}
            return null;
        }
    }

    public void refreshProcessInformationStoreAsync() {
        new Job("Refreshing Process Information"){

            protected IStatus run(IProgressMonitor monitor) {
                ProcessInformationStore.this.refreshProcessInformationStore(monitor);
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

