/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import com.uwyn.jhighlight.renderer.Renderer;
import com.uwyn.jhighlight.renderer.XhtmlRendererFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.jboss.tools.jsf.vpe.richfaces.RichFacesTemplatesActivator;
import org.jboss.tools.vpe.editor.VpeSourceDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeCreatorUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class RichFacesInsertTemplate
extends VpeAbstractTemplate {
    private static String RESOURCE_NOT_FOUND_MESSAGE = "Resource was not found.";
    private static String RESOURCE_READING_ERROR_MESSAGE = "Resource reading error.";
    private static String HIGHLIGHT_ERROR_MESSAGE = "Error occured during highlight.";
    private static String ERROR_MESSAGE_STYLE = "color: red; font-weight: bold;";
    private static String SRC_ATTR_NAME = "src";
    private static String HIGHTLIGHT_ATTR_NAME = "highlight";
    private static String CODE_TAG = "code>";
    private static String CLASS = "class=";
    private static String STYLE = "style=";
    private static String OPEN_BRACKET = "{";
    private static String CLOSE_BRACKET = "}";
    private static String SPACE = "&nbsp;";
    private static String SPAN_TAG = "<span style=\"color: rgb(255,255,255)\">_</span>";
    private static String EMPTY_STRING = "";
    private static String UTF8 = "utf-8";
    private static String HTML = "html";
    private static String XHTML = "xhtml";
    private static String XML = "xml";
    private static String JAVA = "java";
    private static String CPP = "cpp";
    private static String CPLUSPLUS = "c++";
    private static String GROOVY = "groovy";
    private static String LZX = "lzx";
    private nsIDOMDocument visualDocument;

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        this.visualDocument = visualDocument;
        nsIDOMElement div = visualDocument.createElement("DIV");
        VpeCreationData vpeCreationData = new VpeCreationData((nsIDOMNode)div);
        Element sourceElement = (Element)sourceNode;
        String srcValue = sourceElement.getAttribute(SRC_ATTR_NAME);
        String finalStr = "";
        String buf = "";
        if (!sourceElement.hasAttribute(SRC_ATTR_NAME) || "".equalsIgnoreCase(srcValue)) {
            div.setAttribute("style", ERROR_MESSAGE_STYLE);
            nsIDOMText text = visualDocument.createTextNode(RESOURCE_NOT_FOUND_MESSAGE);
            div.appendChild((nsIDOMNode)text);
            return vpeCreationData;
        }
        BufferedReader br = null;
        try {
            IFile iFile = VpeCreatorUtil.getFile((String)srcValue, (VpePageContext)pageContext);
            if (iFile == null || !iFile.isAccessible()) {
                div.setAttribute("style", ERROR_MESSAGE_STYLE);
                nsIDOMText text = visualDocument.createTextNode(RESOURCE_READING_ERROR_MESSAGE);
                div.appendChild((nsIDOMNode)text);
                VpeCreationData vpeCreationData2 = vpeCreationData;
                return vpeCreationData2;
            }
            try {
                File file = new File(iFile.getLocation().toOSString());
                br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                while ((buf = br.readLine()) != null) {
                    finalStr = String.valueOf(finalStr) + buf + "\n";
                }
            }
            catch (IOException iOException) {
                div.setAttribute("style", ERROR_MESSAGE_STYLE);
                nsIDOMText text = visualDocument.createTextNode(RESOURCE_READING_ERROR_MESSAGE);
                div.appendChild((nsIDOMNode)text);
                VpeCreationData vpeCreationData3 = vpeCreationData;
                return vpeCreationData3;
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                RichFacesTemplatesActivator.getPluginLog().logError((Throwable)e);
            }
        }
        String highlightValue = sourceElement.getAttribute(HIGHTLIGHT_ATTR_NAME);
        if (!sourceElement.hasAttribute(HIGHTLIGHT_ATTR_NAME) || !this.searchInSupportedTypes(highlightValue)) {
            nsIDOMText text = visualDocument.createTextNode(finalStr);
            div.appendChild((nsIDOMNode)text);
            return vpeCreationData;
        }
        Renderer renderer = XhtmlRendererFactory.getRenderer((String)highlightValue);
        String transformStr = null;
        try {
            transformStr = renderer.highlight("", finalStr, UTF8, false);
            transformStr = this.convertString(transformStr, highlightValue);
            Node node = this.parseTransformString(transformStr);
            this.buildVisualNode(node, div);
        }
        catch (IOException iOException) {
            div.setAttribute("style", ERROR_MESSAGE_STYLE);
            nsIDOMText text = visualDocument.createTextNode(HIGHLIGHT_ERROR_MESSAGE);
            div.appendChild((nsIDOMNode)text);
            return vpeCreationData;
        }
        return vpeCreationData;
    }

    private String convertString(String str, String highlightValue) {
        String value;
        HashMap<String, String> map = new HashMap<String, String>();
        if (highlightValue.equalsIgnoreCase(HTML) || highlightValue.equalsIgnoreCase(XHTML) || highlightValue.equalsIgnoreCase(LZX)) {
            highlightValue = XML;
        }
        if (highlightValue.equalsIgnoreCase(GROOVY)) {
            highlightValue = JAVA;
        }
        if (highlightValue.equalsIgnoreCase(CPLUSPLUS)) {
            highlightValue = CPP;
        }
        String sym = "." + highlightValue + "_";
        int i = 0;
        while (i < str.length()) {
            int start = str.indexOf(sym, i);
            if (start == -1) break;
            int startBracket = str.indexOf(OPEN_BRACKET, start);
            String key = str.substring(start + 1, startBracket - 1);
            int endBracket = str.indexOf(CLOSE_BRACKET, startBracket);
            value = str.substring(startBracket + 2, endBracket - 2);
            i = endBracket;
            map.put(key, value);
        }
        int start = str.indexOf(CODE_TAG);
        int end = str.indexOf(CODE_TAG, start + 1);
        str = str.substring(start - 1, end + 5);
        str = str.replaceAll(CLASS, STYLE);
        Set set = map.keySet();
        for (String key : set) {
            value = (String)map.get(key);
            str = str.replaceAll(key, value);
        }
        str = str.replace(SPACE, SPAN_TAG);
        return str;
    }

    public Node parseTransformString(String transformString) {
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document doc = null;
        Node node = null;
        try {
            builder = fact.newDocumentBuilder();
            doc = builder.parse(new StringBufferInputStream(transformString));
            node = doc.getElementsByTagName("code").item(0);
        }
        catch (IOException iOException) {
            return node;
        }
        catch (SAXException sAXException) {
            return node;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return node;
        }
        return node;
    }

    private boolean searchInSupportedTypes(String highlightValue) {
        if (highlightValue == null) {
            return true;
        }
        if (highlightValue.trim().equals(EMPTY_STRING)) {
            return false;
        }
        Set set = XhtmlRendererFactory.getSupportedTypes();
        for (Object object : set) {
            if (!highlightValue.equalsIgnoreCase((String)object)) continue;
            return true;
        }
        return false;
    }

    private void buildVisualNode(Node node, nsIDOMElement el) {
        if (node instanceof Text) {
            nsIDOMText text = this.visualDocument.createTextNode(node.getTextContent());
            el.appendChild((nsIDOMNode)text);
        } else {
            nsIDOMElement elem = this.visualDocument.createElement(node.getNodeName());
            el.appendChild((nsIDOMNode)elem);
            int i = 0;
            while (i < node.getAttributes().getLength()) {
                elem.setAttribute(node.getAttributes().item(i).getNodeName(), node.getAttributes().item(i).getNodeValue());
                ++i;
            }
            i = 0;
            while (i < node.getChildNodes().getLength()) {
                this.buildVisualNode(node.getChildNodes().item(i), elem);
                ++i;
            }
        }
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    public void setSourceAttributeSelection(VpePageContext pageContext, Element sourceElement, int offset, int length, Object data) {
        VpeSourceDomBuilder sourceBuilder = pageContext.getSourceBuilder();
        sourceBuilder.setSelection((Node)sourceElement, 0, 0);
    }
}

