/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.server.nodejs.internal.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.console.ITernConsole;
import tern.eclipse.ide.ui.console.LineType;
import tern.server.LoggingInterceptor;
import tern.server.nodejs.process.INodejsProcess;
import tern.server.nodejs.process.INodejsProcessListener;
import tern.utils.IOUtils;

public class TernNodejsInterceptor
extends LoggingInterceptor
implements INodejsProcessListener {
    private final IIDETernProject project;

    public TernNodejsInterceptor(IIDETernProject project) {
        this.project = project;
    }

    protected void outPrintln(String line) {
        ITernConsole console = this.getConsole();
        if (console != null) {
            console.doAppendLine(LineType.DATA, line);
        }
    }

    protected void outProcessPrintln(String line) {
        ITernConsole console = this.getConsole();
        if (console != null) {
            console.doAppendLine(LineType.PROCESS_INFO, line);
        }
    }

    protected void errPrintln(String line) {
        ITernConsole console = this.getConsole();
        if (console != null) {
            console.doAppendLine(LineType.PROCESS_ERROR, line);
        }
    }

    protected void printStackTrace(Throwable error) {
        ITernConsole console = this.getConsole();
        if (console != null) {
            StringWriter s = new StringWriter();
            PrintWriter writer = new PrintWriter(s);
            error.printStackTrace(writer);
            console.doAppendLine(LineType.PROCESS_ERROR, s.toString());
        }
    }

    public void onCreate(final INodejsProcess process, final List<String> commands, final File projectDir) {
        if (Display.getDefault().getThread() != Thread.currentThread()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TernNodejsInterceptor.this.onCreate(process, commands, projectDir);
                }
            });
            return;
        }
        ITernConsole console = this.getConsole();
        if (console != null) {
            StringBuilder commandsAsString = new StringBuilder();
            int i = 0;
            for (String cmd : commands) {
                if (i > 0) {
                    commandsAsString.append(" ");
                }
                if (i <= 1) {
                    commandsAsString.append("\"");
                }
                commandsAsString.append(cmd);
                if (i <= 1) {
                    commandsAsString.append("\"");
                }
                ++i;
            }
            this.outProcessPrintln("Nodejs Commnand: " + commandsAsString.toString());
            String path = projectDir.getPath();
            try {
                path = projectDir.getCanonicalPath();
            }
            catch (IOException iOException) {}
            this.outProcessPrintln("Project dir: " + path);
            String json = "";
            try {
                File ternProject = new File(projectDir, ".tern-project");
                json = IOUtils.toString((InputStream)new FileInputStream(ternProject));
            }
            catch (Throwable e) {
                this.errPrintln(e.getMessage());
            }
            this.outProcessPrintln(".tern-project: " + json);
        }
    }

    public void onStart(INodejsProcess process) {
        this.outProcessPrintln("Server started at " + process.getPort() + " in " + process.getElapsedStartTime() + "ms");
    }

    public void onData(INodejsProcess process, String line) {
        this.outProcessPrintln(line);
    }

    public void onStop(INodejsProcess process) {
        this.outProcessPrintln("Server stopped at " + process.getPort());
    }

    public void onError(INodejsProcess process, String line) {
        this.errPrintln(line);
    }

    private ITernConsole getConsole() {
        if (TernUIPlugin.getDefault() != null) {
            return TernUIPlugin.getDefault().getConsole(this.project);
        }
        return null;
    }
}

