/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core.util;

import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.ITags;
import com.openshift.restclient.model.IResource;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class ResourceUtils {
    public static boolean isMatching(String filterText, IResource template) {
        if (StringUtils.isBlank((String)filterText)) {
            return true;
        }
        final HashSet<String> items = new HashSet<String>(Arrays.asList(filterText.replaceAll(",", " ").toLowerCase().split(" ")));
        if (ResourceUtils.containsAll(template.getName(), items)) {
            return true;
        }
        return (Boolean)template.accept((CapabilityVisitor)new CapabilityVisitor<ITags, Boolean>(){

            public Boolean visit(ITags capability) {
                for (String item : items) {
                    if (ResourceUtils.inCollection(item, capability.getTags())) continue;
                    return false;
                }
                return true;
            }
        }, (Object)Boolean.FALSE);
    }

    private static boolean containsAll(String text, Collection<String> items) {
        String _text = text.toLowerCase();
        return items.stream().allMatch(it -> _text.contains((CharSequence)it));
    }

    private static boolean inCollection(String item, Collection<String> texts) {
        String _item = item.toLowerCase();
        return texts.stream().anyMatch(txt -> txt.toLowerCase().contains(_item));
    }
}

