/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.core;

import java.util.Collection;
import org.jboss.tools.foundation.core.plugin.BaseCorePlugin;
import org.jboss.tools.foundation.core.plugin.log.IPluginLog;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistryAdapter;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionsRegistryListener;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionPersistency;
import org.jboss.tools.openshift.core.preferences.OpenShiftCorePreferences;
import org.jboss.tools.openshift.internal.core.Trace;
import org.osgi.framework.BundleContext;

public class OpenShiftCoreActivator
extends BaseCorePlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.openshift.core";
    private static OpenShiftCoreActivator instance;
    private static BundleContext context;

    public OpenShiftCoreActivator() {
        instance = this;
    }

    public static OpenShiftCoreActivator getDefault() {
        return instance;
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        OpenShiftCoreActivator.context = context;
        this.registerDebugOptionsListener(PLUGIN_ID, new Trace(this), context);
        Collection connections = new ConnectionPersistency().load();
        ConnectionsRegistrySingleton.getInstance().addAll(connections);
        ConnectionsRegistrySingleton.getInstance().addListener((IConnectionsRegistryListener)new ConnectionsRegistryAdapter(){

            public void connectionRemoved(IConnection connection) {
                if (!(connection instanceof Connection)) {
                    return;
                }
                ConnectionURL url = ConnectionURL.safeForConnection((IConnection)connection);
                if (url != null) {
                    OpenShiftCorePreferences.INSTANCE.removeAuthScheme(url.toString());
                }
                OpenShiftCoreActivator.this.saveAllConnections();
            }

            public void connectionAdded(IConnection connection) {
                if (connection instanceof Connection) {
                    OpenShiftCoreActivator.this.saveAllConnections();
                }
            }

            public void connectionChanged(IConnection connection, String property, Object oldValue, Object newValue) {
                if (connection instanceof Connection && (oldValue instanceof Connection || newValue instanceof Connection)) {
                    OpenShiftCoreActivator.this.saveAllConnections();
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        this.saveAllConnections();
        super.stop(context);
    }

    public static IPluginLog pluginLog() {
        return OpenShiftCoreActivator.getDefault().pluginLogInternal();
    }

    public static void logError(String message, Throwable t) {
        OpenShiftCoreActivator.pluginLog().logError(message, t);
    }

    public static void logWarning(String message, Throwable t) {
        OpenShiftCoreActivator.pluginLog().logWarning(message, t);
    }

    public static StatusFactory statusFactory() {
        return OpenShiftCoreActivator.getDefault().statusFactoryInternal();
    }

    protected void saveAllConnections() {
        Collection connections = ConnectionsRegistrySingleton.getInstance().getAll(Connection.class);
        new ConnectionPersistency().save(connections);
    }
}

