/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server;

import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.server.ServerUtils;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.util.OpenShiftResourceUniqueId;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;
import org.osgi.service.prefs.BackingStoreException;

public class OpenShiftServerUtils {
    public static final String SERVER_PROJECT_QUALIFIER = "org.jboss.tools.openshift.core";
    public static final String ATTR_SERVICE = "org.jboss.tools.openshift.Service";
    public static final String ATTR_DEPLOYPROJECT = "org.jboss.tools.openshift.DeployProject";
    public static final String ATTR_SOURCE_PATH = "org.jboss.tools.openshift.SourcePath";
    public static final String ATTR_POD_PATH = "org.jboss.tools.openshift.PodPath";
    public static final String ATTR_IGNORE_CONTEXT_ROOT = "org.jboss.tools.openshift.IgnoreContextRoot";
    public static final String ATTR_OVERRIDE_PROJECT_SETTINGS = "org.jboss.tools.openshift.project.Override";
    public static final String ATTR_CONNECTIONURL = "org.jboss.tools.openshift.Connection";
    public static final String OPENSHIFT_SERVER_TYPE = "org.jboss.tools.openshift.openshift.server.type";

    public static String getServerName(IService service, Connection connection) {
        if (service == null) {
            return null;
        }
        return service.getName() + " OpenShift 3 " + UrlUtils.cutPort((String)UrlUtils.cutScheme((String)connection.getHost()));
    }

    public static void updateServer(String serverName, String connectionUrl, IService service, String podPath, String sourcePath, IProject deployProject, IServerWorkingCopy server) {
        String host = OpenShiftServerUtils.getHost(service);
        String deployProjectName = ProjectUtils.getName((IProject)deployProject);
        OpenShiftServerUtils.updateServer(serverName, host, connectionUrl, deployProjectName, OpenShiftResourceUniqueId.get((IResource)service), sourcePath, podPath, server);
    }

    private static String getHost(IService service) {
        String host = null;
        if (service != null) {
            host = service.getPortalIP();
        }
        return host;
    }

    public static void updateServer(String serverName, String host, String connectionUrl, String deployProjectName, String serviceId, String sourcePath, String podPath, IServerWorkingCopy server) {
        OpenShiftServerUtils.updateServer(server);
        server.setName(serverName);
        server.setHost(UrlUtils.getHost((String)host));
        server.setAttribute(ATTR_CONNECTIONURL, connectionUrl);
        server.setAttribute(ATTR_DEPLOYPROJECT, deployProjectName);
        server.setAttribute(ATTR_SOURCE_PATH, sourcePath);
        server.setAttribute(ATTR_POD_PATH, podPath);
        server.setAttribute(ATTR_SERVICE, serviceId);
    }

    private static void updateServer(IServerWorkingCopy server) {
        server.setAttribute("org.jboss.ide.eclipse.as.core.server.serverMode", "openshift3");
        ((ServerWorkingCopy)server).setAutoPublishSetting(1);
        server.setAttribute("org.jboss.ide.eclipse.as.core.server.IGNORE_LAUNCH_COMMANDS", String.valueOf(Boolean.TRUE));
        server.setAttribute("org.jboss.ide.eclipse.as.core.server.webPort", 80);
        server.setAttribute("org.jboss.ide.eclipse.as.core.server.webPortAutoDetect", Boolean.FALSE.toString());
        server.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", "custom");
        server.setAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", true);
    }

    public static void updateServerProject(String connectionUrl, IService service, String sourcePath, String podPath, IProject project) {
        OpenShiftServerUtils.updateServerProject(connectionUrl, OpenShiftResourceUniqueId.get((IResource)service), sourcePath, podPath, project);
    }

    public static void updateServerProject(String connectionUrl, String serviceId, String sourcePath, String podPath, IProject project) {
        IEclipsePreferences node = ServerUtils.getProjectNode((String)SERVER_PROJECT_QUALIFIER, (IProject)project);
        node.put(ATTR_CONNECTIONURL, connectionUrl);
        node.put(ATTR_DEPLOYPROJECT, project.getName());
        node.put(ATTR_SOURCE_PATH, sourcePath);
        node.put(ATTR_POD_PATH, podPath);
        node.put(ATTR_SERVICE, serviceId);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            OpenShiftCoreActivator.pluginLog().logError((Throwable)e);
        }
    }

    public static IProject getDeployProject(IServerAttributes attributes) {
        return ProjectUtils.getProject((String)OpenShiftServerUtils.getDeployProjectName(attributes));
    }

    public static String getDeployProjectName(IServerAttributes attributes) {
        if (attributes == null) {
            return null;
        }
        return attributes.getAttribute(ATTR_DEPLOYPROJECT, null);
    }

    public static boolean isIgnoresContextRoot(IServerAttributes server) {
        return server.getAttribute(ATTR_IGNORE_CONTEXT_ROOT, true);
    }

    public static boolean isOpenShiftRuntime(IServerAttributes server) {
        return OPENSHIFT_SERVER_TYPE.equals(server.getServerType().getId());
    }

    public static Connection getConnection(IServerAttributes attributes) {
        try {
            String url = OpenShiftServerUtils.getProjectAttribute(ATTR_CONNECTIONURL, null, OpenShiftServerUtils.getDeployProject(attributes));
            if (!StringUtils.isEmpty((String)url)) {
                ConnectionURL connectionUrl = ConnectionURL.forURL((String)url);
                return (Connection)ConnectionsRegistrySingleton.getInstance().getByUrl(connectionUrl, Connection.class);
            }
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            OpenShiftCoreActivator.pluginLog().logError(NLS.bind((String)"Could not get connection url for user {0}", (Object)attributes.getName()), (Throwable)e);
        }
        return null;
    }

    public static IService getService(IServerAttributes attributes) {
        return OpenShiftServerUtils.getService(attributes, OpenShiftServerUtils.getConnection(attributes));
    }

    public static IService getService(IServerAttributes attributes, Connection connection) {
        String uniqueId = OpenShiftServerUtils.getProjectAttribute(ATTR_SERVICE, null, OpenShiftServerUtils.getDeployProject(attributes));
        if (StringUtils.isEmpty((String)uniqueId)) {
            return null;
        }
        return (IService)OpenShiftResourceUniqueId.getByUniqueId(uniqueId, connection.getResources("Service", OpenShiftResourceUniqueId.getProject(uniqueId)));
    }

    public static String getPodPath(IServerAttributes attributes) {
        return OpenShiftServerUtils.getProjectAttribute(ATTR_POD_PATH, null, OpenShiftServerUtils.getDeployProject(attributes));
    }

    public static String getSourcePath(IServerAttributes attributes) {
        return OpenShiftServerUtils.getProjectAttribute(ATTR_SOURCE_PATH, null, OpenShiftServerUtils.getDeployProject(attributes));
    }

    public static boolean isOverridesProject(IServerAttributes server) {
        return server.getAttribute(ATTR_OVERRIDE_PROJECT_SETTINGS, false);
    }

    public static String getProjectAttribute(String name, String defaultValue, IServerAttributes attributes) {
        return OpenShiftServerUtils.getProjectAttribute(name, defaultValue, OpenShiftServerUtils.getDeployProject(attributes));
    }

    public static String getProjectAttribute(String name, String defaultValue, IProject project) {
        return ServerUtils.getProjectAttribute((String)name, (String)defaultValue, (String)SERVER_PROJECT_QUALIFIER, (IProject)project);
    }
}

