/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.server;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IRSyncable;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IService;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;
import org.jboss.tools.common.util.FileUtils;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.server.OCBinaryOperation;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.core.OpenShiftCoreActivator;

public class OpenShiftServerPublishMethod {
    public void publishStart(IServer server, IProgressMonitor monitor) throws CoreException {
        String deployProjectName = OpenShiftServerUtils.getDeployProjectName((IServerAttributes)server);
        IProject deployProject = ProjectUtils.getProject((String)deployProjectName);
        if (!ProjectUtils.isAccessible((IProject)deployProject)) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.openshift.core", NLS.bind((String)"Server adapter {0} cannot publish. Required project {1} is missing or inaccessible.", (Object)server.getName(), (Object)deployProjectName)));
        }
    }

    public int publishFinish(IServer server, IProgressMonitor monitor) throws CoreException {
        IService service = OpenShiftServerUtils.getService((IServerAttributes)server);
        if (service == null) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Server {0} could not determine the service to publish to.", (Object)server.getName())));
        }
        String sourcePath = OpenShiftServerUtils.getSourcePath((IServerAttributes)server);
        if (StringUtils.isEmpty((String)sourcePath)) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Server {0} could not determine the source to publish.", (Object)server.getName())));
        }
        String podPath = OpenShiftServerUtils.getPodPath((IServerAttributes)server);
        if (StringUtils.isEmpty((String)podPath)) {
            throw new CoreException(OpenShiftCoreActivator.statusFactory().errorStatus(NLS.bind((String)"Server {0} could not determine the destination directory to publish to.", (Object)server.getName())));
        }
        MultiStatus status = new MultiStatus("org.jboss.tools.openshift.core", 0, NLS.bind((String)"Could not sync {0} to all pods running the service {1}", (Object)sourcePath, (Object)service.getName()), null);
        new RSync(sourcePath, service, podPath, server).run(status);
        return 1;
    }

    public int publishModule(IServer server, int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        return 1;
    }

    private static class RSync
    extends OCBinaryOperation {
        private static final Collection<String> IGNORED_DIRS = Arrays.asList("tempDeploy", "deploy");
        private static final FilenameFilter SERVER_DIR_FILTER = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !IGNORED_DIRS.contains(name);
            }
        };
        private String sourcePath;
        private IService service;
        private String podPath;
        private IServer server;

        public RSync(String sourcePath, IService service, String podPath, IServer server) {
            this.sourcePath = sourcePath;
            this.service = service;
            this.podPath = RSync.sanitizePath(podPath);
            this.server = server;
        }

        private static String sanitizePath(String path) {
            if (path == null) {
                return null;
            }
            if (path.endsWith("/") || path.endsWith("/.")) {
                return path;
            }
            return String.valueOf(path) + "/";
        }

        @Override
        protected void runOCBinary(MultiStatus status) {
            for (IPod pod : this.service.getPods()) {
                try {
                    this.sync(this.sourcePath, pod, this.podPath, this.server);
                }
                catch (OpenShiftException | IOException e) {
                    status.add((IStatus)new Status(4, "org.jboss.tools.openshift.core", e.getMessage()));
                }
            }
        }

        private void sync(String sourcePath, IPod pod, String podPath, IServer server) throws IOException {
            File tmpCopy = this.getLocalDeploymentDirectory(server);
            if (!tmpCopy.exists() || tmpCopy.listFiles(SERVER_DIR_FILTER).length == 0) {
                this.syncPodToDirectory(pod, podPath, tmpCopy);
            }
            this.publishLocally(sourcePath, tmpCopy);
            this.syncDirectoryToPod(pod, tmpCopy, podPath);
        }

        private void syncPodToDirectory(final IPod pod, final String podPath, File destination) throws IOException {
            destination.mkdirs();
            final String destinationPath = RSync.sanitizePath(destination.getAbsolutePath());
            pod.accept((CapabilityVisitor)new CapabilityVisitor<IRSyncable, IRSyncable>(){

                public IRSyncable visit(IRSyncable rsyncable) {
                    rsyncable.sync((IRSyncable.Peer)new IRSyncable.PodPeer(podPath, pod), (IRSyncable.Peer)new IRSyncable.LocalPeer(destinationPath));
                    return rsyncable;
                }
            }, null);
        }

        private void syncDirectoryToPod(final IPod pod, File source, final String podPath) throws IOException {
            final String sourcePath = RSync.sanitizePath(source.getAbsolutePath());
            pod.accept((CapabilityVisitor)new CapabilityVisitor<IRSyncable, IRSyncable>(){

                public IRSyncable visit(IRSyncable rsyncable) {
                    rsyncable.sync((IRSyncable.Peer)new IRSyncable.LocalPeer(sourcePath), (IRSyncable.Peer)new IRSyncable.PodPeer(podPath, pod));
                    return rsyncable;
                }
            }, null);
        }

        private void publishLocally(String sourcePath, File localDeploymentDirectory) throws IOException {
            File source = new File(sourcePath);
            FileUtils.copyDir((File)source, (File)localDeploymentDirectory, (boolean)true, (boolean)true, (boolean)true, (FileFilter)new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String filename = file.getName();
                    return !filename.endsWith(".git") && !filename.endsWith(".gitignore") && !filename.endsWith(".svn") && !filename.endsWith(".settings") && !filename.endsWith(".project") && !filename.endsWith(".classpath");
                }
            });
        }

        private File getLocalDeploymentDirectory(IServer server) {
            return ServerUtil.getServerStateLocation((IServer)server).toFile();
        }
    }
}

